/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JTable;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.LabelOptions;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.session.CySession;
import org.cytoscape.view.model.CyNetworkView;

public class AnnotationSet {
    public static final List<Integer> DEFAULT_WORDSIZE_THRESHOLDS = Collections.unmodifiableList(Arrays.asList(30, 80, 90, 90, 90, 90));
    public static final double[] DEFAULT_LABEL_POSITION = new double[]{0.5, 0.0};
    private TreeMap<Integer, Cluster> clusterMap;
    private String name;
    private String clusterColumnName;
    private String nameColumnName;
    private CyNetworkView view;
    private boolean useGroups;
    private boolean selected = false;
    private JTable clusterTable;
    private boolean manualSelection = false;
    boolean constantFontSize = false;
    boolean showEllipses = true;
    int fontSize = 12;
    int ellipseWidth = 3;
    int ellipseOpacity = 20;
    String shapeType = "ELLIPSE";
    boolean showLabel = true;
    private int maxWords = 4;
    private List<Integer> wordSizeThresholds = DEFAULT_WORDSIZE_THRESHOLDS;
    private double[] labelPosition = DEFAULT_LABEL_POSITION;
    private int sameClusterBonus = 8;
    private int centralityBonus = 4;

    public AnnotationSet() {
        this.clusterMap = new TreeMap();
    }

    public AnnotationSet(String cloudNamePrefix, CyNetworkView view, String clusterColumnName, String nameColumnName) {
        this();
        this.name = cloudNamePrefix;
        this.view = view;
        this.clusterColumnName = clusterColumnName;
        this.nameColumnName = nameColumnName;
    }

    public CyNetworkView getView() {
        return this.view;
    }

    public void setView(CyNetworkView view) {
        this.view = view;
    }

    public void addCluster(Cluster cluster) {
        this.clusterMap.put(cluster.getClusterNumber(), cluster);
    }

    public int getNextClusterNumber() {
        int clusterNumber = 1;
        while (this.clusterMap.containsKey(clusterNumber)) {
            ++clusterNumber;
        }
        return clusterNumber;
    }

    public void updateCoordinates() {
        for (Cluster cluster : this.clusterMap.values()) {
            cluster.updateCoordinates();
        }
    }

    public TreeMap<Integer, Cluster> getClusterMap() {
        return this.clusterMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClusterColumnName() {
        return this.clusterColumnName;
    }

    public void setClusterColumnName(String clusterColumnName) {
        this.clusterColumnName = clusterColumnName;
    }

    public String getNameColumnName() {
        return this.nameColumnName;
    }

    public void setNameColumnName(String nameColumnName) {
        this.nameColumnName = nameColumnName;
    }

    public boolean usingGroups() {
        return this.useGroups;
    }

    public void setUseGroups(boolean useGroups) {
        this.useGroups = useGroups;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isConstantFontSize() {
        return this.constantFontSize;
    }

    public void setConstantFontSize(boolean constantFontSize) {
        this.constantFontSize = constantFontSize;
    }

    public boolean isShowEllipses() {
        return this.showEllipses;
    }

    public void setShowEllipses(boolean showEllipses) {
        this.showEllipses = showEllipses;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getEllipseWidth() {
        return this.ellipseWidth;
    }

    public void setEllipseWidth(int ellipseWidth) {
        this.ellipseWidth = ellipseWidth;
        for (Cluster cluster : this.clusterMap.values()) {
            if (cluster.isSelected()) {
                cluster.getEllipse().setBorderWidth((double)(ellipseWidth * 2));
            } else {
                cluster.getEllipse().setBorderWidth((double)ellipseWidth);
            }
            cluster.getEllipse().update();
        }
    }

    public int getEllipseOpacity() {
        return this.ellipseOpacity;
    }

    public void setEllipseOpacity(int ellipseOpacity) {
        this.ellipseOpacity = ellipseOpacity;
        for (Cluster cluster : this.clusterMap.values()) {
            cluster.getEllipse().setFillOpacity((double)ellipseOpacity);
            cluster.getEllipse().update();
        }
    }

    public boolean isManualSelection() {
        return this.manualSelection;
    }

    public void setManualSelection(boolean manualSelection) {
        this.manualSelection = manualSelection;
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(String shapeType) {
        this.shapeType = shapeType;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public int getMaxWords() {
        return this.maxWords;
    }

    public void setMaxWords(int maxWords) {
        this.maxWords = maxWords;
    }

    public List<Integer> getWordSizeThresholds() {
        return this.wordSizeThresholds;
    }

    public void setWordSizeThresholds(List<Integer> wordSizeThresholds) {
        this.wordSizeThresholds = wordSizeThresholds;
    }

    public double[] getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(double[] labelPosition) {
        this.labelPosition = labelPosition;
    }

    public int getSameClusterBonus() {
        return this.sameClusterBonus;
    }

    public void setSameClusterBonus(int sameClusterBonus) {
        this.sameClusterBonus = sameClusterBonus;
    }

    public int getCentralityBonus() {
        return this.centralityBonus;
    }

    public void setCentralityBonus(int centralityBonus) {
        this.centralityBonus = centralityBonus;
    }

    public void setLabelOptions(LabelOptions labelOptions) {
        if (labelOptions != null) {
            this.setMaxWords(labelOptions.getMaxWords());
            this.setWordSizeThresholds(labelOptions.getWordSizeThresholds());
            this.setLabelPosition(labelOptions.getLabelPosition());
            this.setSameClusterBonus(labelOptions.getSameClusterBonus());
            this.setCentralityBonus(labelOptions.getCentralityBonus());
            for (Cluster cluster : this.clusterMap.values()) {
                cluster.setLabel(cluster.makeLabel(cluster.getWordInfos(), cluster.getMostCentralNodeLabel(), this.sameClusterBonus, this.centralityBonus, this.wordSizeThresholds, this.maxWords));
                cluster.getTextAnnotation().setText(cluster.getLabel());
            }
        }
    }

    public JTable getClusterTable() {
        return this.clusterTable;
    }

    public void setClusterTable(JTable clusterTable) {
        this.clusterTable = clusterTable;
    }

    public String toSessionString() {
        String sessionString = "";
        sessionString = sessionString + this.name + "\n";
        sessionString = sessionString + this.clusterColumnName + "\n";
        sessionString = sessionString + this.nameColumnName + "\n";
        sessionString = sessionString + this.useGroups + "\n";
        sessionString = sessionString + this.constantFontSize + "\n";
        sessionString = sessionString + this.showEllipses + "\n";
        sessionString = sessionString + this.fontSize + "\n";
        sessionString = sessionString + this.ellipseWidth + "\n";
        sessionString = sessionString + this.ellipseOpacity + "\n";
        sessionString = sessionString + this.shapeType + "\n";
        sessionString = sessionString + this.showLabel + "\n";
        sessionString = sessionString + this.maxWords + "\n";
        sessionString = sessionString + this.sameClusterBonus + "\n";
        sessionString = sessionString + this.centralityBonus + "\n";
        sessionString = sessionString + this.labelPosition[0] + "\t" + this.labelPosition[1] + "\n";
        Iterator<Comparable<Integer>> i$ = this.wordSizeThresholds.iterator();
        while (i$.hasNext()) {
            int wordSizeThreshold = i$.next();
            sessionString = sessionString + wordSizeThreshold + "\t";
        }
        sessionString = sessionString + "\n";
        for (Cluster cluster : this.clusterMap.values()) {
            sessionString = sessionString + cluster.toSessionString();
        }
        sessionString = sessionString + "End of annotation set\n";
        return sessionString;
    }

    public void load(ArrayList<String> text, CySession session) {
        this.setName(text.get(0));
        this.setClusterColumnName(text.get(1));
        this.setNameColumnName(text.get(2));
        this.setUseGroups(Boolean.valueOf(text.get(3)));
        this.setConstantFontSize(Boolean.valueOf(text.get(4)));
        this.setShowEllipses(Boolean.valueOf(text.get(5)));
        this.setFontSize(Integer.valueOf(text.get(6)));
        this.setEllipseWidth(Integer.valueOf(text.get(7)));
        this.setEllipseOpacity(Integer.valueOf(text.get(8)));
        this.setShapeType(text.get(9));
        this.setShowLabel(Boolean.valueOf(text.get(10)));
        this.setMaxWords(Integer.valueOf(text.get(11)));
        this.setSameClusterBonus(Integer.valueOf(text.get(12)));
        this.setCentralityBonus(Integer.valueOf(text.get(13)));
        String[] labelPositionString = text.get(14).split("\t");
        double[] labelPosition = new double[]{Double.valueOf(labelPositionString[0]), Double.valueOf(labelPositionString[1])};
        this.setLabelPosition(labelPosition);
        String[] wordSizeThresholdString = text.get(15).split("\t");
        this.wordSizeThresholds = new ArrayList<Integer>();
        for (String wordSizeThreshold : wordSizeThresholdString) {
            this.wordSizeThresholds.add(Integer.valueOf(wordSizeThreshold));
        }
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        for (CyTable table : autoAnnotationManager.getTableManager().getAllTables(true)) {
            if (!table.getTitle().equals(this.name)) continue;
            ((CyNetwork)this.view.getModel()).getRow((CyIdentifiable)this.view.getModel()).set(this.name, (Object)table.getSUID());
            break;
        }
        ArrayList<String> clusterLines = new ArrayList<String>();
        for (int lineNumber = 16; lineNumber < text.size(); ++lineNumber) {
            String line = text.get(lineNumber);
            if (line.equals("End of cluster")) {
                Cluster cluster = new Cluster();
                cluster.setParent(this);
                cluster.load(clusterLines, session);
                this.clusterMap.put(cluster.getClusterNumber(), cluster);
                clusterLines = new ArrayList();
                continue;
            }
            clusterLines.add(line);
        }
    }

    public String toString() {
        return this.name;
    }
}

