/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.actions.BuildPostAnalysisActionListener;
import org.baderlab.csplugins.enrichmentmap.actions.ShowAboutPanelAction;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisKnownSignaturePanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisSignatureDiscoveryPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.swing.DialogTaskManager;

public class PostAnalysisInputPanel
extends JPanel
implements CytoPanelComponent {
    private CyApplicationManager cyApplicationManager;
    private CySwingApplication application;
    private OpenBrowser browser;
    private FileUtil fileUtil;
    private CyServiceRegistrar registrar;
    private CySessionManager sessionManager;
    private StreamUtil streamUtil;
    private CyNetworkManager networkManager;
    private DialogTaskManager dialog;
    private CyEventHelper eventHelper;
    private JRadioButton knownSignature;
    private JRadioButton signatureDiscovery;
    private CollapsiblePanel userInputPanel;
    private JPanel optionsPanel;
    private PostAnalysisSignatureDiscoveryPanel signatureDiscoveryPanel;
    private PostAnalysisKnownSignaturePanel knownSignaturePanel;
    protected static String gmtTip = "File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...";
    protected static String gmt_instruction = "Please select the Gene Set file (.gmt)...";
    protected static String siggmt_instruction = "Please select the Signature Gene Set file (.gmt)...";
    private PostAnalysisParameters sigDiscoveryPaParams;
    private PostAnalysisParameters knownSigPaParams;

    public PostAnalysisInputPanel(CyApplicationManager cyApplicationManager, CySwingApplication application, OpenBrowser browser, FileUtil fileUtil, CySessionManager sessionManager, StreamUtil streamUtil, CyServiceRegistrar registrar, CyNetworkManager networkManager, DialogTaskManager dialog, CyEventHelper eventHelper) {
        this.cyApplicationManager = cyApplicationManager;
        this.application = application;
        this.browser = browser;
        this.fileUtil = fileUtil;
        this.registrar = registrar;
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.networkManager = networkManager;
        this.dialog = dialog;
        this.eventHelper = eventHelper;
        this.signatureDiscoveryPanel = new PostAnalysisSignatureDiscoveryPanel(this, cyApplicationManager, application, streamUtil, dialog, fileUtil);
        this.knownSignaturePanel = new PostAnalysisKnownSignaturePanel(this, cyApplicationManager, application, streamUtil, dialog, fileUtil);
        this.optionsPanel = this.knownSignaturePanel;
        this.userInputPanel = new CollapsiblePanel("User Input");
        this.userInputPanel.setCollapsed(false);
        this.userInputPanel.add(this.optionsPanel);
        this.setLayout(new BorderLayout());
        JPanel analysisTypePanel = this.createAnalysisTypePanel();
        this.add((Component)analysisTypePanel, "North");
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.userInputPanel);
        advancedOptionsContainer.add((Component)scrollPane, "Center");
        this.add((Component)advancedOptionsContainer, "Center");
        JPanel bottomPanel = this.createBottomPanel();
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createAnalysisTypePanel() {
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gridbag_buttons = new GridBagLayout();
        GridBagConstraints c_buttons = new GridBagConstraints();
        buttonsPanel.setLayout(gridbag_buttons);
        buttonsPanel.setBorder(BorderFactory.createTitledBorder("Info:"));
        JButton help = new JButton("Online Manual");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.browser.openURL(EnrichmentMapUtils.userManualUrl);
            }
        });
        JButton about = new JButton("About");
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("inMenuBar", "true");
        serviceProperties.put("preferredMenu", "Apps.EnrichmentMap");
        about.addActionListener((ActionListener)((Object)new ShowAboutPanelAction(serviceProperties, this.cyApplicationManager, null, this.application, this.browser)));
        c_buttons.weighty = 1.0;
        c_buttons.weightx = 1.0;
        c_buttons.insets = new Insets(0, 0, 0, 0);
        c_buttons.gridx = 0;
        c_buttons.gridwidth = 1;
        c_buttons.gridy = 0;
        c_buttons.fill = 2;
        c_buttons.gridy = 0;
        gridbag_buttons.setConstraints(about, c_buttons);
        buttonsPanel.add(about);
        c_buttons.gridy = 1;
        gridbag_buttons.setConstraints(help, c_buttons);
        buttonsPanel.add(help);
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.setBorder(BorderFactory.createTitledBorder("Post Analysis Type"));
        this.knownSignature = new JRadioButton("Known Signature", this.optionsPanel == this.knownSignaturePanel);
        this.knownSignature.setActionCommand("Known Signature");
        this.knownSignature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.knownSignature.setSelected(true);
        this.signatureDiscovery = new JRadioButton("Signature Discovery", this.optionsPanel == this.signatureDiscoveryPanel);
        this.signatureDiscovery.setActionCommand("Signature Discovery");
        this.signatureDiscovery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        ButtonGroup analysisOptions = new ButtonGroup();
        analysisOptions.add(this.knownSignature);
        analysisOptions.add(this.signatureDiscovery);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        gridbag.setConstraints(this.knownSignature, c);
        panel.add(this.knownSignature);
        c.gridy = 1;
        gridbag.setConstraints(this.signatureDiscovery, c);
        panel.add(this.signatureDiscovery);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)buttonsPanel, "East");
        topPanel.add((Component)panel, "Center");
        return topPanel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.resetPanel();
            }
        });
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        JButton importButton = new JButton();
        importButton.setText("Run");
        importButton.addActionListener(new BuildPostAnalysisActionListener(this, this.sessionManager, this.streamUtil, this.application, this.cyApplicationManager, this.dialog, this.eventHelper));
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    protected File chooseGMTFile(JFormattedTextField textField) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        List<FileChooserFilter> all_filters = Arrays.asList(filter);
        File file = this.fileUtil.getFile(EnrichmentMapUtils.getWindowInstance(this), "Import Signature GMT File", 0, all_filters);
        this.getPaParams().setSignatureGMTFileName("");
        if (file != null) {
            textField.setForeground(PostAnalysisInputPanel.checkFile(file.getAbsolutePath()));
            textField.setText(file.getAbsolutePath());
            textField.setValue(file.getAbsolutePath());
            this.getPaParams().setSignatureGMTFileName(file.getAbsolutePath());
            textField.setToolTipText(file.getAbsolutePath());
        }
        return file;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    public void close() {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    protected static Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private void selectAnalysisTypeActionPerformed(ActionEvent evt) {
        String analysisType = evt.getActionCommand();
        if (analysisType.equalsIgnoreCase("Signature Discovery")) {
            this.userInputPanel.remove(this.optionsPanel);
            this.optionsPanel = this.signatureDiscoveryPanel;
            this.userInputPanel.add(this.optionsPanel);
            this.optionsPanel.revalidate();
        } else {
            this.userInputPanel.remove(this.optionsPanel);
            this.optionsPanel = this.knownSignaturePanel;
            this.userInputPanel.add(this.optionsPanel);
            this.optionsPanel.revalidate();
        }
    }

    private void resetPanel() {
        if (this.knownSigPaParams != null) {
            this.knownSignaturePanel.resetPanel();
        }
        if (this.sigDiscoveryPaParams != null) {
            this.signatureDiscoveryPanel.resetPanel();
        }
    }

    public void updateContents(EnrichmentMap currentMap) {
        this.resetPanel();
        if (currentMap != null) {
            this.knownSigPaParams = new PostAnalysisParameters();
            this.knownSigPaParams.setSignatureHub(false);
            this.knownSigPaParams.setFilter(false);
            this.sigDiscoveryPaParams = new PostAnalysisParameters();
            this.sigDiscoveryPaParams.setSignatureHub(true);
            this.knownSignaturePanel.updateContents(currentMap, this.knownSigPaParams);
            this.signatureDiscoveryPanel.updateContents(currentMap, this.sigDiscoveryPaParams);
        }
    }

    public PostAnalysisParameters getPaParams() {
        return this.optionsPanel == this.signatureDiscoveryPanel ? this.sigDiscoveryPaParams : this.knownSigPaParams;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        return "Post Analysis Input Panel";
    }

    public void setAvSigCount(int avSigCount) {
        if (this.signatureDiscovery.isSelected()) {
            this.signatureDiscoveryPanel.setAvSigCount(avSigCount);
        }
    }
}

