/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate;

import java.util.HashMap;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.DrawClusterLabelTask;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class AutoAnnotationUtils {
    public static void updateFontSizes() {
        for (CyNetworkView view : AutoAnnotationManager.getInstance().getNetworkViewToAutoAnnotationParameters().keySet()) {
            AutoAnnotationParameters params = AutoAnnotationManager.getInstance().getNetworkViewToAutoAnnotationParameters().get(view);
            for (AnnotationSet annotationSet : params.getAnnotationSets().values()) {
                TaskIterator currentTasks = new TaskIterator(new Task[0]);
                for (Cluster cluster : annotationSet.getClusterMap().values()) {
                    cluster.eraseText();
                    DrawClusterLabelTask drawlabel = new DrawClusterLabelTask(cluster);
                    currentTasks.append((Task)drawlabel);
                    if (annotationSet.isSelected() && annotationSet.isShowLabel()) continue;
                    cluster.eraseText();
                }
                AutoAnnotationManager.getInstance().getDialogTaskManager().execute(currentTasks);
            }
        }
    }

    public static void updateNodeCentralities(Cluster cluster) {
        String edgeAttribute;
        CyNetwork network = (CyNetwork)cluster.getParent().getView().getModel();
        try {
            edgeAttribute = EnrichmentMapManager.getInstance().getCyNetworkList().get(network.getSUID()).getParams().getAttributePrefix() + EnrichmentMapVisualStyle.SIMILARITY_COEFFICIENT;
        }
        catch (NullPointerException e) {
            edgeAttribute = "--None--";
        }
        Set<CyNode> nodeSet = cluster.getNodes();
        HashMap<CyNode, Double> nodeCentralities = new HashMap<CyNode, Double>();
        for (CyNode node : nodeSet) {
            double clusterWeightedDegreeSum = 0.0;
            for (CyEdge edge : network.getAdjacentEdgeIterable(node, CyEdge.Type.ANY)) {
                if ((edge.getSource() == node || !nodeSet.contains(edge.getSource())) && (edge.getTarget() == node || !nodeSet.contains(edge.getTarget()))) continue;
                try {
                    clusterWeightedDegreeSum += ((Double)network.getRow((CyIdentifiable)edge).get(edgeAttribute, Double.class)).doubleValue();
                }
                catch (Exception e) {
                    clusterWeightedDegreeSum += 1.0;
                }
            }
            nodeCentralities.put(node, clusterWeightedDegreeSum);
        }
        cluster.setNodesToCentralities(nodeCentralities);
    }
}

