/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTask;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;

public class BuildPostAnalysisActionListener
implements ActionListener {
    private PostAnalysisInputPanel inputPanel;
    private CyNetworkManager networkManager;
    private CyApplicationManager applicationManager;
    private CySessionManager sessionManager;
    private StreamUtil streamUtil;
    private DialogTaskManager dialog;
    private CyEventHelper eventHelper;

    public BuildPostAnalysisActionListener(PostAnalysisInputPanel panel, CySessionManager sessionManager, StreamUtil streamUtil, CyNetworkManager networkManager, CyApplicationManager applicationManager, DialogTaskManager dialog, CyEventHelper eventHelper) {
        this.inputPanel = panel;
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.networkManager = networkManager;
        this.applicationManager = applicationManager;
        this.dialog = dialog;
        this.eventHelper = eventHelper;
    }

    public void actionPerformed(ActionEvent event) {
        PostAnalysisParameters paParams = this.inputPanel.getPaParams();
        EnrichmentMap current_map = EnrichmentMapManager.getInstance().getMap(this.applicationManager.getCurrentNetwork().getSUID());
        if (current_map != null) {
            paParams.setAttributePrefix(current_map.getParams().getAttributePrefix());
        }
        String errors = paParams.checkMinimalRequirements();
        TaskIterator currentTasks = new TaskIterator(new Task[0]);
        if (errors.equalsIgnoreCase("")) {
            if (paParams.isSignatureHub()) {
                BuildDiseaseSignatureTask new_signature = new BuildDiseaseSignatureTask(current_map, paParams, this.sessionManager, this.streamUtil, this.applicationManager, this.eventHelper);
                currentTasks.append((Task)new_signature);
                this.dialog.execute(currentTasks);
            } else {
                JOptionPane.showMessageDialog(this.inputPanel, errors, "No such Post-Analysis", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.inputPanel, errors, "Invalid Input", 2);
        }
    }
}

