/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task;

import java.util.ArrayList;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class RunClustermakerTaskFactory
implements TaskFactory {
    private CyNetwork network;
    private CyNetworkView view;
    private String clusterColumnName;
    private String algorithm;
    private TaskMonitor taskMonitor = null;

    public RunClustermakerTaskFactory(AutoAnnotationParameters params) {
        this.network = params.getNetwork();
        this.view = params.getNetworkView();
        this.clusterColumnName = params.getClusterColumnName();
        this.algorithm = params.getAlgorithm();
    }

    private String getCommand(String algorithm, String edgeAttribute, String networkName) {
        String command = "";
        if (algorithm == "Affinity Propagation Cluster") {
            command = "cluster ap attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "Cluster Fuzzifier") {
            command = "cluster fuzzifier attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "Community cluster (GLay)") {
            command = "cluster glay clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "ConnectedComponents Cluster") {
            command = "cluster connectedcomponents attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "Fuzzy C-Means Cluster") {
            command = "cluster fcml attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "MCL Cluster") {
            command = "cluster mcl attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        } else if (algorithm == "SCPS Cluster") {
            command = "cluster scps attribute=\"" + edgeAttribute + "\" clusterAttribute=\"" + this.clusterColumnName + "\" selectedOnly=true";
        }
        return command;
    }

    public TaskIterator createTaskIterator() {
        String edgeAttribute;
        if (this.network.getDefaultNodeTable().getColumn(this.clusterColumnName) != null) {
            this.network.getDefaultNodeTable().deleteColumn(this.clusterColumnName);
        }
        try {
            edgeAttribute = EnrichmentMapManager.getInstance().getCyNetworkList().get(((CyNetwork)this.view.getModel()).getSUID()).getParams().getAttributePrefix() + EnrichmentMapVisualStyle.SIMILARITY_COEFFICIENT;
        }
        catch (NullPointerException e) {
            edgeAttribute = "--None--";
        }
        for (View nodeView : this.view.getNodeViews()) {
            if (!((Boolean)nodeView.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue()) continue;
            this.network.getRow((CyIdentifiable)nodeView.getModel()).set("selected", (Object)true);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getCommand(this.algorithm, edgeAttribute, this.network.toString()));
        TaskIterator taskIterator = AutoAnnotationManager.getInstance().getCommandExecutor().createTaskIterator(commands, null);
        return taskIterator;
    }

    public boolean isReady() {
        return false;
    }
}

