/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.baderlab.wordcloud.internal.cluster.CloudDisplayStyles;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class CloudBuilder {
    private final NetworkParameters networkParams;
    private String cloudName = null;
    private List<CyNode> nodes = Collections.emptyList();
    private List<String> attributeNames = Collections.emptyList();
    private CloudDisplayStyles displayStyle = CloudDisplayStyles.getDefault();
    private int maxWords = 250;
    private double clusterCutoff = 1.0;
    private double netWeightFactor = 0.0;
    private int minWordOccurrence = 1;
    private String clusterColumnName = null;
    private CyTable clusterTable = null;

    CloudBuilder(NetworkParameters network) {
        this.networkParams = network;
    }

    public CloudParameters build() {
        return this.networkParams.createCloud(this);
    }

    public CloudBuilder copyFrom(CloudParameters other) {
        this.setNodes(other.getSelectedNodes());
        this.setAttributes(other.getAttributeNames());
        this.setDisplayStyle(other.getDisplayStyle());
        this.setMaxWords(other.getMaxWords());
        this.setClusterCutoff(other.getClusterCutoff());
        this.setNetWeightFactor(other.getNetWeightFactor());
        this.setMinWordOccurrence(other.getMinWordOccurrence());
        this.setClusterColumnName(other.getClusterColumnName());
        this.setClusterTable(other.getClusterTable());
        return this;
    }

    public CloudBuilder applyOverrideProperties() {
        CloudModelManager manager = this.networkParams.getManager();
        if (manager.overrideNetWeightProperty()) {
            this.setNetWeightFactor(manager.getNetWeightPropertyValue());
        }
        return this;
    }

    public CloudBuilder setName(String cloudName) {
        this.cloudName = cloudName;
        return this;
    }

    public CloudBuilder setNodes(Collection<CyNode> nodes) {
        this.nodes = nodes == null ? Collections.emptyList() : new ArrayList<CyNode>(nodes);
        return this;
    }

    public CloudBuilder setAttributes(Collection<String> attributeNames) {
        this.attributeNames = attributeNames == null ? Collections.emptyList() : new ArrayList<String>(attributeNames);
        return this;
    }

    public CloudBuilder setAllAttributes() {
        this.attributeNames = new ArrayList<String>();
        this.attributeNames.addAll(CloudModelManager.getColumnNames(this.networkParams.getNetwork(), CyNode.class));
        return this;
    }

    public CloudBuilder setDisplayStyle(CloudDisplayStyles displayStyle) {
        this.displayStyle = displayStyle;
        return this;
    }

    public CloudBuilder setMaxWords(int maxWords) {
        this.maxWords = maxWords;
        return this;
    }

    public CloudBuilder setClusterCutoff(double clusterCutoff) {
        this.clusterCutoff = clusterCutoff;
        return this;
    }

    public CloudBuilder setNetWeightFactor(double netWeightFactor) {
        this.netWeightFactor = netWeightFactor;
        return this;
    }

    public CloudBuilder setMinWordOccurrence(int minWordOccurrence) {
        this.minWordOccurrence = minWordOccurrence;
        return this;
    }

    public CloudBuilder setClusterColumnName(String clusterColumnName) {
        this.clusterColumnName = clusterColumnName;
        return this;
    }

    public CloudBuilder setClusterTable(CyTable clusterTable) {
        this.clusterTable = clusterTable;
        return this;
    }

    public Collection<CyNode> getNodes() {
        return this.nodes;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public NetworkParameters getNetworkParams() {
        return this.networkParams;
    }

    public String getName() {
        return this.cloudName;
    }

    public CloudDisplayStyles getDisplayStyle() {
        return this.displayStyle;
    }

    public int getMaxWords() {
        return this.maxWords;
    }

    public double getClusterCutoff() {
        return this.clusterCutoff;
    }

    public double getNetWeightFactor() {
        return this.netWeightFactor;
    }

    public int getMinWordOccurrence() {
        return this.minWordOccurrence;
    }

    public String getClusterColumnName() {
        return this.clusterColumnName;
    }

    public CyTable getClusterTable() {
        return this.clusterTable;
    }
}

