/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.action;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;
import org.baderlab.wordcloud.internal.cluster.WordPair;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.CloudProvider;
import org.baderlab.wordcloud.internal.ui.WordCloudVisualStyleFactory;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.visualize.ApplyPreferredLayoutTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.TaskManager;

public class CreateNetworkAction
extends AbstractCyAction {
    private final CloudProvider cloudProvider;
    private final WordCloudVisualStyleFactory cloudStyleFactory;
    private final CyNetworkFactory networkFactory;
    private final CyNetworkViewFactory networkViewFactory;
    private final CyNetworkManager networkManager;
    private final CyNetworkViewManager viewManager;
    private final VisualMappingManager visualMappingManager;
    private final ApplyPreferredLayoutTaskFactory layoutTaskFactory;
    private final TaskManager<?, ?> taskManager;

    public CreateNetworkAction(CloudProvider cloudProvider, CyServiceRegistrar registrar) {
        super("Create Network From Cloud");
        this.cloudProvider = cloudProvider;
        this.networkFactory = (CyNetworkFactory)registrar.getService(CyNetworkFactory.class);
        this.networkViewFactory = (CyNetworkViewFactory)registrar.getService(CyNetworkViewFactory.class);
        this.networkManager = (CyNetworkManager)registrar.getService(CyNetworkManager.class);
        this.viewManager = (CyNetworkViewManager)registrar.getService(CyNetworkViewManager.class);
        this.visualMappingManager = (VisualMappingManager)registrar.getService(VisualMappingManager.class);
        this.layoutTaskFactory = (ApplyPreferredLayoutTaskFactory)registrar.getService(ApplyPreferredLayoutTaskFactory.class);
        this.taskManager = (TaskManager)registrar.getService(TaskManager.class);
        VisualStyleFactory styleFactory = (VisualStyleFactory)registrar.getService(VisualStyleFactory.class);
        VisualMappingFunctionFactory continuousMappingFactory = (VisualMappingFunctionFactory)registrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=continuous)");
        VisualMappingFunctionFactory passthroughMappingFactory = (VisualMappingFunctionFactory)registrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=passthrough)");
        this.cloudStyleFactory = new WordCloudVisualStyleFactory(styleFactory, continuousMappingFactory, passthroughMappingFactory);
    }

    public void actionPerformed(ActionEvent ae) {
        CloudParameters cloud = this.cloudProvider.getCloud();
        if (cloud == null) {
            return;
        }
        CloudInfo cloudInfo = cloud.calculateCloud();
        Map<String, Double> ratios = cloudInfo.getRatios();
        Map<WordPair, Double> pairRatios = cloudInfo.getPairRatios();
        String newNetworkName = cloud.getNextNetworkName();
        CyNetwork network = this.createNetwork(newNetworkName);
        CyTable nodeTable = network.getDefaultNodeTable();
        nodeTable.createColumn(WordCloudVisualStyleFactory.WORD_VAL, Double.class, false);
        CyTable edgeTable = network.getDefaultEdgeTable();
        edgeTable.createColumn(WordCloudVisualStyleFactory.CO_VAL, Double.class, false);
        HashMap<String, CyNode> wordNodes = new HashMap<String, CyNode>();
        for (Map.Entry<String, Double> entry : ratios.entrySet()) {
            String curWord = entry.getKey();
            CyNode node = network.addNode();
            CyRow row = network.getRow((CyIdentifiable)node);
            row.set("name", (Object)curWord);
            Double nodeRatio = entry.getValue();
            row.set(WordCloudVisualStyleFactory.WORD_VAL, (Object)nodeRatio);
            wordNodes.put(curWord, node);
        }
        for (Map.Entry<Object, Double> entry : pairRatios.entrySet()) {
            WordPair pair = (WordPair)entry.getKey();
            Double edgeRatio = entry.getValue();
            String nodeName1 = pair.getFirstWord();
            String nodeName2 = pair.getSecondWord();
            CyNode node1 = (CyNode)wordNodes.get(nodeName1);
            CyNode node2 = (CyNode)wordNodes.get(nodeName2);
            Double node1Ratio = ratios.get(nodeName1);
            Double node2Ratio = ratios.get(nodeName2);
            Double conditionalRatio = edgeRatio / (node1Ratio * node2Ratio);
            if (!(conditionalRatio > 1.0)) continue;
            CyEdge edge = network.addEdge(node1, node2, false);
            CyRow row = network.getRow((CyIdentifiable)edge);
            row.set(WordCloudVisualStyleFactory.CO_VAL, (Object)conditionalRatio);
        }
        CyNetworkView view = this.createNetworkView(network);
        this.registerNetwork(network);
        this.registerNetworkView(view);
        this.applyVisualStyle(view, cloud);
        view.updateView();
        this.applyPreferredLayout(view);
    }

    private CyNetwork createNetwork(String name) {
        CyNetwork network = this.networkFactory.createNetwork();
        network.getRow((CyIdentifiable)network).set("name", (Object)name);
        return network;
    }

    private void registerNetwork(CyNetwork network) {
        this.networkManager.addNetwork(network);
    }

    private CyNetworkView createNetworkView(CyNetwork network) {
        return this.networkViewFactory.createNetworkView(network);
    }

    private void registerNetworkView(CyNetworkView view) {
        this.viewManager.addNetworkView(view);
    }

    public void applyVisualStyle(CyNetworkView view, CloudParameters cloud) {
        CyNetwork network = (CyNetwork)view.getModel();
        String newNetworkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        String vs_name = newNetworkName + "WordCloud_style";
        VisualStyle vs = this.getVisualStyle(vs_name);
        if (vs == null) {
            vs = this.cloudStyleFactory.createVisualStyle(vs_name, cloud);
            this.visualMappingManager.addVisualStyle(vs);
        }
        this.visualMappingManager.setVisualStyle(vs, view);
        vs.apply(view);
    }

    public void applyPreferredLayout(CyNetworkView view) {
        this.taskManager.execute(this.layoutTaskFactory.createTaskIterator(Collections.singleton(view)));
    }

    public VisualStyle getVisualStyle(String name) {
        for (VisualStyle style : this.visualMappingManager.getAllVisualStyles()) {
            if (!style.getTitle().equals(name)) continue;
            return style;
        }
        return null;
    }
}

