/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;
import org.baderlab.wordcloud.internal.cluster.WordPair;

public class ClusterPriorityQueue {
    private List<WordPair> queue = new LinkedList<WordPair>();
    private CloudInfo cloudInfo;

    public ClusterPriorityQueue(CloudInfo cloudInfo) {
        this.cloudInfo = cloudInfo;
        this.initialize();
    }

    private void initialize() {
        Map<WordPair, Integer> selectedPairCounts = this.cloudInfo.getSelectedPairCounts();
        this.queue = new ArrayList<WordPair>(selectedPairCounts.size());
        for (Map.Entry<WordPair, Integer> entry : selectedPairCounts.entrySet()) {
            WordPair curPair = entry.getKey();
            curPair.calculateProbability(entry.getValue());
            this.queue.add(curPair);
        }
        Collections.sort(this.queue);
        Collections.reverse(this.queue);
    }

    public WordPair peak() {
        if (!this.queue.isEmpty()) {
            return this.queue.get(0);
        }
        return null;
    }

    public WordPair remove() {
        if (this.queue.isEmpty()) {
            return null;
        }
        WordPair removedPair = this.queue.remove(0);
        String firstWord = removedPair.getFirstWord();
        String secondWord = removedPair.getSecondWord();
        int h1 = firstWord.hashCode();
        int h2 = secondWord.hashCode();
        Iterator<WordPair> iter = this.queue.iterator();
        while (iter.hasNext()) {
            WordPair curPair = iter.next();
            String curFirst = curPair.getFirstWord();
            String curSecond = curPair.getSecondWord();
            int c1 = curFirst.hashCode();
            int c2 = curSecond.hashCode();
            if (h1 != c1 && h2 != c2 && h1 != c2 && h2 != c1 || !firstWord.equals(curFirst) && !secondWord.equals(curSecond) && (!firstWord.equals(curSecond) || !secondWord.equals(curFirst))) continue;
            iter.remove();
        }
        return removedPair;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

