/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.cluster;

import java.util.Map;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;

public class WordPair
implements Comparable<WordPair> {
    private final String firstWord;
    private final String secondWord;
    private double probability;
    private final CloudInfo cloudInfo;

    public WordPair(String aWord, String nextWord, CloudInfo cloudInfo) {
        this.firstWord = aWord;
        this.secondWord = nextWord;
        this.cloudInfo = cloudInfo;
        this.probability = 0.0;
    }

    public void calculateProbability(int pairCount) {
        Map<String, Integer> selectedCounts = this.cloudInfo.getSelectedCounts();
        int firstCount = selectedCounts.get(this.firstWord);
        int secondCount = selectedCounts.get(this.secondWord);
        int numerator = pairCount * this.cloudInfo.getCountTotal();
        int denominator = firstCount * secondCount;
        this.probability = (double)numerator / (double)denominator;
    }

    @Override
    public int compareTo(WordPair second) {
        Double firstProb = this.probability;
        Double secondProb = second.probability;
        if (firstProb < secondProb) {
            return -1;
        }
        if (firstProb > secondProb) {
            return 1;
        }
        Double firstRatio = this.getCloudInfo().getPairRatios().get(this);
        Double secondRatio = second.getCloudInfo().getPairRatios().get(second);
        if (firstRatio < secondRatio) {
            return -1;
        }
        if (firstRatio > secondRatio) {
            return 1;
        }
        int result = this.firstWord.compareTo(second.firstWord);
        if (result != 0) {
            return result;
        }
        return this.secondWord.compareTo(second.secondWord);
    }

    public String getFirstWord() {
        return this.firstWord;
    }

    public String getSecondWord() {
        return this.secondWord;
    }

    public CloudInfo getCloudInfo() {
        return this.cloudInfo;
    }

    public double getProbability() {
        return this.probability;
    }

    public boolean equals(Object object) {
        if (!(object instanceof WordPair)) {
            return false;
        }
        WordPair other = (WordPair)object;
        return this.firstWord.equals(other.firstWord) && this.secondWord.equals(other.secondWord);
    }

    public int hashCode() {
        return this.firstWord.hashCode() * 31 + this.secondWord.hashCode();
    }
}

