/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.model;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.baderlab.wordcloud.internal.CyActivator;
import org.baderlab.wordcloud.internal.IoUtil;

public class WordFilter {
    private HashSet<String> stopWords = new HashSet();
    private HashSet<String> flaggedWords = new HashSet();
    private HashSet<String> addedWords = new HashSet();
    private Boolean filterNums = false;
    public static final String stopWordFile = "/StopWords.txt";
    public static final String flaggedWordFile = "/FlaggedWords.txt";
    public static final String newline = "\n";
    private static final String DELIMITER = "WordFilterDelimiter";

    public WordFilter(IoUtil ioUtil) {
        String stopPath = stopWordFile;
        String flaggedPath = flaggedWordFile;
        try {
            this.initialize(ioUtil, stopPath, this.stopWords);
            this.initialize(ioUtil, flaggedPath, this.flaggedWords);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WordFilter(String propFile) {
        String curWord;
        String[] words;
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split(newline);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        String value = (String)props.get("StopWords");
        if (value != null) {
            words = value.split(DELIMITER);
            for (int i = 0; i < words.length; ++i) {
                curWord = words[i];
                this.stopWords.add(curWord);
            }
        }
        if ((value = (String)props.get("FlaggedWords")) != null) {
            words = value.split(DELIMITER);
            for (int i = 0; i < words.length; ++i) {
                curWord = words[i];
                this.flaggedWords.add(curWord);
            }
        }
        if ((value = (String)props.get("AddedWords")) != null) {
            words = value.split(DELIMITER);
            for (int i = 0; i < words.length; ++i) {
                curWord = words[i];
                this.addedWords.add(curWord);
            }
        }
        if ((value = (String)props.get("FilterNums")) != null) {
            this.filterNums = Boolean.parseBoolean(value);
        }
    }

    public boolean contains(String aWord) {
        if (this.stopWords.contains(aWord)) {
            return true;
        }
        if (this.flaggedWords.contains(aWord)) {
            return true;
        }
        if (this.addedWords.contains(aWord)) {
            return true;
        }
        if (this.filterNums.booleanValue()) {
            return WordFilter.isDigits(aWord);
        }
        return false;
    }

    private static boolean isDigits(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void add(String aWord) {
        this.addedWords.add(aWord);
    }

    public void remove(String aWord) {
        if (this.stopWords.contains(aWord)) {
            this.stopWords.remove(aWord);
        } else if (this.flaggedWords.contains(aWord)) {
            this.flaggedWords.remove(aWord);
        } else if (this.addedWords.contains(aWord)) {
            this.addedWords.remove(aWord);
        }
    }

    private void initialize(IoUtil ioUtil, String resourcePath, HashSet<String> wordSet) throws IOException {
        URL myURL = CyActivator.class.getResource(resourcePath);
        try {
            StringTokenizer token = new StringTokenizer(ioUtil.readAll(myURL));
            while (token.hasMoreTokens()) {
                String curWord = token.nextToken();
                wordSet.add(curWord);
            }
        }
        catch (Exception e) {
            File f;
            try {
                f = new File(myURL.toURI());
            }
            catch (URISyntaxException ex) {
                f = new File(myURL.getPath());
            }
            String path = f.getAbsolutePath();
            String fullText = ioUtil.readAll(path);
            String[] lines = fullText.split(newline);
            for (int i = 0; i < lines.length; ++i) {
                String curWord = lines[i];
                wordSet.add(curWord);
            }
        }
    }

    public String toString() {
        StringBuffer filterVariables = new StringBuffer();
        StringBuffer output = new StringBuffer();
        if (this.stopWords.size() > 0) {
            for (String curWord : this.stopWords) {
                output.append(curWord + DELIMITER);
            }
            filterVariables.append("StopWords\t" + output.toString() + newline);
        }
        output = new StringBuffer();
        if (this.flaggedWords.size() > 0) {
            for (String curWord : this.flaggedWords) {
                output.append(curWord + DELIMITER);
            }
            filterVariables.append("FlaggedWords\t" + output.toString() + newline);
        }
        output = new StringBuffer();
        if (this.addedWords.size() > 0) {
            for (String curWord : this.addedWords) {
                output.append(curWord + DELIMITER);
            }
            filterVariables.append("AddedWords\t" + output.toString() + newline);
        }
        filterVariables.append("FilterNums\t" + this.filterNums + newline);
        return filterVariables.toString();
    }

    public HashSet<String> getStopWords() {
        return this.stopWords;
    }

    public HashSet<String> getFlaggedWords() {
        return this.flaggedWords;
    }

    public HashSet<String> getAddedWords() {
        return this.addedWords;
    }

    public Boolean getFilterNums() {
        return this.filterNums;
    }

    public void setFilterNums(Boolean val) {
        this.filterNums = val;
    }
}

