/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.action;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JOptionPane;
import org.baderlab.wordcloud.internal.SelectionUtils;
import org.baderlab.wordcloud.internal.model.CloudBuilder;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class CreateCloudAction
extends AbstractCyAction {
    private final CyApplicationManager applicationManager;
    private final CySwingApplication application;
    private final CloudModelManager cloudManager;
    private final UIManager uiManager;

    public CreateCloudAction(CyApplicationManager applicationManager, CySwingApplication application, CloudModelManager cloudManager, UIManager uiManager) {
        super("Create Cloud");
        this.applicationManager = applicationManager;
        this.application = application;
        this.cloudManager = cloudManager;
        this.uiManager = uiManager;
    }

    public void actionPerformed(ActionEvent ae) {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        if (!SelectionUtils.hasSelectedNodes(network)) {
            JOptionPane.showMessageDialog(this.application.getJFrame(), "Please select one or more nodes.");
            return;
        }
        Set<CyNode> nodes = SelectionUtils.getSelectedNodes(network);
        CloudBuilder builder = this.cloudManager.addNetwork(network).getCloudBuilder();
        CloudParameters currentCloud = this.uiManager.getCurrentCloud();
        if (currentCloud == null) {
            builder.setAllAttributes();
        } else {
            builder.copyFrom(currentCloud);
        }
        builder.setNodes(nodes);
        builder.applyOverrideProperties();
        builder.build();
    }
}

