/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.input;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.baderlab.wordcloud.internal.ui.action.CreateNetworkAction;
import org.baderlab.wordcloud.internal.ui.action.DeleteCloudAction;
import org.baderlab.wordcloud.internal.ui.action.ExportImageAction;
import org.baderlab.wordcloud.internal.ui.action.RenameCloudAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileUtil;

public class CloudListMouseListener
extends MouseAdapter {
    private JList<String> list;
    private CySwingApplication swingApplication;
    private UIManager uiManager;
    private CyServiceRegistrar registrar;
    private JCheckBox syncCheckBox;

    public CloudListMouseListener(UIManager uiManager, CySwingApplication swingApplication, CyServiceRegistrar registrar, JList<String> list, JCheckBox syncCheckBox) {
        this.uiManager = uiManager;
        this.swingApplication = swingApplication;
        this.list = list;
        this.registrar = registrar;
        this.syncCheckBox = syncCheckBox;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }

    private void showPopup(MouseEvent e) {
        int clicked = this.list.locationToIndex(e.getPoint());
        if (clicked != -1 && this.list.getCellBounds(clicked, clicked).contains(e.getPoint())) {
            this.syncCheckBox.setSelected(false);
            this.list.setSelectedIndex(clicked);
            String cloudName = this.list.getSelectedValue();
            CloudParameters cloud = this.uiManager.getCurrentNetwork().getCloud(cloudName);
            if (e.isPopupTrigger()) {
                FileUtil fileUtil = (FileUtil)this.registrar.getService(FileUtil.class);
                JPopupMenu menu = new JPopupMenu();
                menu.add((Action)((Object)new DeleteCloudAction(cloud, this.swingApplication)));
                menu.add((Action)((Object)new RenameCloudAction(cloud, this.swingApplication, this.uiManager)));
                menu.add((Action)((Object)new CreateNetworkAction(cloud, this.registrar)));
                menu.add((Action)((Object)new ExportImageAction(this.swingApplication, fileUtil, this.uiManager)));
                menu.show(this.list, e.getX(), e.getY());
            } else {
                this.uiManager.updateNodeSelection(cloud);
            }
        }
    }
}

