/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderBarPanel
extends JPanel {
    private final int DIM_HEIGHT = 72;
    private final int DIM_WIDTH = 150;
    private int min;
    private int max;
    private final double precision = 100.0;
    private int dec_precision = (int)Math.log10(100.0);
    private JLabel label;
    private String sliderLabel;
    private JSlider slider;

    public SliderBarPanel(double min, double max, String sliderLabel, int desired_width) {
        this.setPreferredSize(new Dimension(150, 72));
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        if (min <= 1.0 && max <= 1.0) {
            this.min = (int)(min * 100.0);
            this.max = (int)(max * 100.0);
        } else {
            this.min = (int)min;
            this.max = (int)max;
        }
        this.sliderLabel = sliderLabel;
        this.label = new JLabel(sliderLabel);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        Dimension currentsize = this.label.getPreferredSize();
        currentsize.height = 6;
        this.label.setPreferredSize(currentsize);
        this.initPanel(desired_width);
    }

    private void initPanel(int desired_width) {
        this.slider = new JSlider(0, this.min, this.max, this.min);
        this.slider.setMajorTickSpacing((this.max - this.min) / 10);
        this.slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(this.min, new JLabel(String.valueOf((double)this.min / 100.0)));
        labelTable.put(this.max, new JLabel(String.valueOf((double)this.max / 100.0)));
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        Dimension currentsize = this.slider.getPreferredSize();
        currentsize.width = desired_width;
        currentsize.height = 66;
        this.slider.setPreferredSize(currentsize);
        this.setLayout(new GridLayout(2, 1));
        this.add((Component)this.label, "North");
        this.add((Component)this.slider, "South");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderBarPanel.this.setLabel(SliderBarPanel.this.slider.getValue());
            }
        });
        this.revalidate();
    }

    public void setNetNormValue(double val) {
        long value = Math.round(val * this.getPrecision());
        int intValue = (int)value;
        this.slider.setValue(intValue);
    }

    public double getNetNormValue() {
        return (double)this.slider.getValue() / this.getPrecision();
    }

    public void setLabel(int current_value) {
        this.label.setText(String.format("<html>" + this.sliderLabel + " &#8594; " + "<font size=\"-2\"> %." + this.dec_precision + "f </font></html>", (double)current_value / 100.0));
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public double getPrecision() {
        return 100.0;
    }

    public double getMin() {
        return (double)this.min / 100.0;
    }

    public void setMin(double min) {
        this.min = (int)(min * 100.0);
    }

    public double getMax() {
        return (double)this.max / 100.0;
    }

    public void setMax(double max) {
        this.max = (int)(max * 100.0);
    }

    public JSlider getSlider() {
        return this.slider;
    }
}

