/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.input;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.baderlab.wordcloud.internal.model.WordDelimiters;
import org.baderlab.wordcloud.internal.model.WordFilter;

public class WordSelectPanel
extends JPanel {
    private final Model model;

    public WordSelectPanel(Model model) {
        this.model = model;
        this.createPanel();
    }

    public WordSelectPanel(final WordFilter filter) {
        this(new Model(){

            @Override
            public String getTitle() {
                return "Excluded words";
            }

            @Override
            public void remove(String word) {
                filter.remove(word);
            }

            @Override
            public void add(String word) {
                filter.add(word);
            }

            @Override
            public List<String> getCurrent() {
                ArrayList<String> words = new ArrayList<String>();
                words.add("--Added Words--");
                words.addAll(WordSelectPanel.sorted(filter.getAddedWords()));
                words.add("--Flagged Words--");
                words.addAll(WordSelectPanel.sorted(filter.getFlaggedWords()));
                words.add("--Stop Words--");
                words.addAll(WordSelectPanel.sorted(filter.getStopWords()));
                return words;
            }

            @Override
            public List<String> getAvailable() {
                return null;
            }

            @Override
            public boolean validate(Component parent, String word) {
                if (word.matches("[\\w]*")) {
                    return true;
                }
                String message = "Word must contain only letters and numbers (no spaces).";
                JOptionPane.showMessageDialog(parent, message, "Cannot add word", 2);
                return false;
            }
        });
    }

    public WordSelectPanel(final WordDelimiters delimeters) {
        this(new Model(){

            @Override
            public String getTitle() {
                return "Delimiters";
            }

            @Override
            public void remove(String s) {
                delimeters.removeDelimiter(s);
            }

            @Override
            public void add(String s) {
                delimeters.addDelimToUse(s);
            }

            @Override
            public List<String> getCurrent() {
                ArrayList<String> delims = new ArrayList<String>();
                delims.add("--Common Delimiters--");
                delims.addAll(delimeters.getDelimsInUse());
                delims.add("--User Defined--");
                delims.addAll(delimeters.getUserDelims());
                return delims;
            }

            @Override
            public List<String> getAvailable() {
                ArrayList<String> delims = new ArrayList<String>();
                delims.addAll(delimeters.getDelimsToAdd());
                return delims;
            }

            @Override
            public boolean validate(Component parent, String s) {
                return true;
            }
        });
    }

    private void createPanel() {
        JComboBox<String> addWordCombo;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Insets insets = new Insets(3, 3, 3, 3);
        JLabel title = new JLabel(this.model.getTitle());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        this.add((Component)title, c);
        final JList<String> wordList = new JList<String>(this.createListModel());
        JScrollPane wordScroll = new JScrollPane();
        wordScroll.setPreferredSize(wordList.getPreferredSize());
        wordScroll.setViewportView(wordList);
        wordScroll.setHorizontalScrollBarPolicy(31);
        wordScroll.setVerticalScrollBarPolicy(22);
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)wordScroll, c);
        JButton removeButton = new JButton("Remove");
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 11;
        c.fill = 2;
        this.add((Component)removeButton, c);
        final JTextField addWordTextField = new JTextField();
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        this.add((Component)addWordTextField, c);
        JButton addButton = new JButton("Add");
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        this.add((Component)addButton, c);
        List<String> available = this.model.getAvailable();
        if (available == null) {
            addWordCombo = null;
        } else {
            addWordCombo = new JComboBox<String>(this.createComboModel());
            addWordCombo.setEditable(false);
            JLabel inactiveLabel = new JLabel("Disabled common delimeters");
            c = new GridBagConstraints();
            c.insets = insets;
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.fill = 2;
            this.add((Component)inactiveLabel, c);
            c = new GridBagConstraints();
            c.insets = insets;
            c.gridx = 0;
            c.gridy = 4;
            c.fill = 2;
            this.add(addWordCombo, c);
            JButton enableButton = new JButton("Add");
            c = new GridBagConstraints();
            c.insets = insets;
            c.gridx = 1;
            c.gridy = 4;
            c.fill = 2;
            this.add((Component)enableButton, c);
            enableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String word = (String)addWordCombo.getSelectedItem();
                    if (word == null || word.isEmpty()) {
                        return;
                    }
                    word = word.toLowerCase();
                    if (WordSelectPanel.this.model.validate(WordSelectPanel.this, word)) {
                        WordSelectPanel.this.model.add(word);
                        wordList.setModel(WordSelectPanel.this.createListModel());
                        wordList.setSelectedValue(word, true);
                        addWordCombo.setModel(WordSelectPanel.this.createComboModel());
                    }
                }
            });
        }
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String word = addWordTextField.getText().trim();
                if (word.isEmpty()) {
                    return;
                }
                word = word.toLowerCase();
                if (WordSelectPanel.this.model.validate(WordSelectPanel.this, word)) {
                    WordSelectPanel.this.model.add(word);
                    wordList.setModel(WordSelectPanel.this.createListModel());
                    wordList.setSelectedValue(word, true);
                    addWordTextField.setText(null);
                }
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = wordList.getSelectedValuesList();
                for (String word : selectedValues) {
                    WordSelectPanel.this.model.remove(word);
                }
                wordList.setModel(WordSelectPanel.this.createListModel());
                if (addWordCombo != null) {
                    addWordCombo.setModel(WordSelectPanel.this.createComboModel());
                    if (!selectedValues.isEmpty()) {
                        addWordCombo.setSelectedItem(selectedValues.get(0));
                    }
                }
            }
        });
        JSeparator separator = new JSeparator(0);
        c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.fill = 2;
        this.add((Component)separator, c);
    }

    private ListModel<String> createListModel() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (String word : this.model.getCurrent()) {
            listModel.addElement(word);
        }
        return listModel;
    }

    private ComboBoxModel<String> createComboModel() {
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>();
        for (String s : this.model.getAvailable()) {
            comboModel.addElement(s);
        }
        return comboModel;
    }

    private static <T extends Comparable<T>> List<T> sorted(Collection<T> collection) {
        ArrayList<T> result = new ArrayList<T>(collection);
        Collections.sort(result);
        return result;
    }

    public JDialog createDialog(Component parent, String title) {
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(this);
        optionPane.setIcon(null);
        optionPane.setPreferredSize(new Dimension(350, 400));
        optionPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JDialog dialog = optionPane.createDialog(parent, title);
        return dialog;
    }

    private static interface Model {
        public String getTitle();

        public List<String> getCurrent();

        public List<String> getAvailable();

        public void add(String var1);

        public void remove(String var1);

        public boolean validate(Component var1, String var2);
    }
}

