/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ParametersPanel
extends JPanel
implements ActionListener {
    private Dimension defaultSize;
    private String[] paramLabels;
    private String[] paramValues;
    private boolean[] isList;
    private int[] paramValuesIndex;
    private String[][] paramChoices;
    private JLabel[] labels;
    private JComboBox[] fields;
    private Runnable action;

    public ParametersPanel(String[] stringArray, String[] stringArray2) {
        this(stringArray, new int[stringArray.length], new String[][]{stringArray2});
    }

    public ParametersPanel(String[] stringArray) {
        this(stringArray, new String[stringArray.length]);
    }

    public ParametersPanel(String[] stringArray, int[] nArray, String[][] stringArray2) {
        int n;
        this.paramLabels = stringArray;
        this.isList = new boolean[this.paramLabels.length];
        for (n = 0; n < this.isList.length; ++n) {
            this.isList[n] = true;
        }
        this.paramValuesIndex = nArray;
        this.paramChoices = stringArray2;
        this.paramValues = new String[this.paramLabels.length];
        for (n = 0; n < this.paramChoices.length; ++n) {
            this.paramValues[n] = this.paramChoices[n][this.paramValuesIndex[n]];
        }
        this.setComponents();
        this.setAppearence();
        this.draw();
    }

    public ParametersPanel(String[] stringArray, String[][] stringArray2) {
        this(stringArray, new int[stringArray.length], stringArray2);
    }

    private void setComponents() {
        this.labels = new JLabel[this.paramLabels.length];
        this.fields = new JComboBox[this.paramLabels.length];
        for (int i = 0; i < this.paramLabels.length; ++i) {
            this.labels[i] = new JLabel(this.paramLabels[i], 4);
            this.fields[i] = this.isList[i] ? new JComboBox<String>(this.paramChoices[i]) : new JComboBox();
            this.fields[i].setEditable(!this.isList[i]);
        }
        this.defaultSize = new Dimension(400, this.paramLabels.length * 30);
    }

    private void setAppearence() {
        this.setPreferredSize(this.defaultSize);
        this.setSize(this.defaultSize);
    }

    private void update() {
        this.updateValues();
        this.updateValuesIndex();
    }

    private void updateValues() {
        for (int i = 0; i < this.paramLabels.length; ++i) {
            this.paramValues[i] = (String)this.fields[i].getSelectedItem();
        }
    }

    private void updateValuesIndex() {
        for (int i = 0; i < this.paramLabels.length; ++i) {
            if (!this.isList[i]) continue;
            this.paramValuesIndex[i] = this.fields[i].getSelectedIndex();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.update();
        new Thread(this.action, "PanelParameters " + this.toString() + " selection").start();
    }

    public int getValueIndex(int n) {
        if (!this.isList[n]) {
            throw new IllegalArgumentException("This PanelParameter element is not set to give an Index.");
        }
        this.update();
        return this.paramValuesIndex[n];
    }

    public int[] getValuesIndex() {
        this.update();
        return this.paramValuesIndex;
    }

    public String[] getValues() {
        this.update();
        return this.paramValues;
    }

    public String getValue(int n) {
        this.update();
        return this.paramValues[n];
    }

    public void setAction(Runnable runnable) {
        this.action = runnable;
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private void draw() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        for (int i = 0; i < this.paramLabels.length; ++i) {
            this.fields[i].addActionListener(this);
            this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 50, 20);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labels[i], gridBagConstraints);
            jPanel.add(this.labels[i]);
            this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 50, 20);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.fields[i], gridBagConstraints);
            jPanel.add(this.fields[i]);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(this.getSize());
        jScrollPane.setSize(this.getSize());
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }
}

