/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui;

import java.awt.Color;
import org.jmathplot.gui.FrameView;
import org.jmathplot.gui.PlotPanel;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.Base2D;
import org.jmathplot.gui.plotObjects.Grid;
import org.jmathplot.gui.plots.BarPlot;
import org.jmathplot.gui.plots.BoxPlot2D;
import org.jmathplot.gui.plots.HistogramPlot2D;
import org.jmathplot.gui.plots.LinePlot;
import org.jmathplot.gui.plots.Plot;
import org.jmathplot.gui.plots.ScatterPlot;
import org.jmathplot.gui.plots.StaircasePlot;
import org.jmathplot.util.DoubleArray;

public class Plot2DPanel
extends PlotPanel {
    public Plot2DPanel() {
    }

    public Plot2DPanel(double[] dArray, double[] dArray2, int[] nArray, String[] stringArray) {
        super(dArray, dArray2, nArray, stringArray);
    }

    public Plot2DPanel(double[][] dArray, String string, String string2) {
        super(DoubleArray.getColumns(DoubleArray.min(dArray), 0, 1), DoubleArray.getColumns(DoubleArray.max(dArray), 0, 1));
        this.addPlot(dArray, string, string2);
    }

    public void initBasenGrid(double[] dArray, double[] dArray2, int[] nArray, String[] stringArray) {
        this.base = new Base2D(dArray, dArray2, panelSize, nArray, Base.DEFAULT_BORDER);
        this.grid = new Grid(this.base, stringArray);
    }

    public void initBasenGrid(double[] dArray, double[] dArray2) {
        this.initBasenGrid(dArray, dArray2, new int[]{0, 0}, new String[]{"X", "Y"});
    }

    public void initBasenGrid() {
        this.initBasenGrid(new double[]{0.0, 0.0}, new double[]{1.0, 1.0});
    }

    public void setAxesLabels(String string, String string2) {
        this.setAxesLabels(new String[]{string, string2});
    }

    public void addPlot(double[][] dArray, String string, String string2, Color color) {
        Plot plot = null;
        if (string2.equals("SCATTER")) {
            DoubleArray.checkColumnDimension(dArray, 2);
            plot = new ScatterPlot(dArray, color, string, this.base);
        } else if (string2.equals("LINE")) {
            DoubleArray.checkColumnDimension(dArray, 2);
            plot = new LinePlot(dArray, color, string, this.base);
        } else if (string2.equals("BAR")) {
            DoubleArray.checkColumnDimension(dArray, 2);
            plot = new BarPlot(dArray, color, string, this.base);
        } else if (string2.equals("HISTOGRAM")) {
            DoubleArray.checkColumnDimension(dArray, 3);
            plot = new HistogramPlot2D(DoubleArray.getColumns(dArray, 0, 1), DoubleArray.getColumns(dArray, 2, 2), color, string, this.base);
        } else if (string2.equals("BOX")) {
            DoubleArray.checkColumnDimension(dArray, 6);
            plot = new BoxPlot2D(DoubleArray.getColumns(dArray, 0, 1), DoubleArray.getColumns(dArray, 2, 5), color, string, this.base);
        } else if (string2.equals("STAIRCASE")) {
            DoubleArray.checkColumnDimension(dArray, 2);
            plot = new StaircasePlot(dArray, color, string, this.base);
        } else {
            throw new IllegalArgumentException("Plot type is unknown : " + string2);
        }
        this.addPlot(plot);
    }

    public static void main(String[] stringArray) {
        Plot2DPanel plot2DPanel = new Plot2DPanel(DoubleArray.random(10, 2), "plot 1", "SCATTER");
        new FrameView(plot2DPanel);
        plot2DPanel.addPlot(DoubleArray.random(10, 2), "plot 2", "SCATTER");
    }
}

