/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui;

import java.awt.Color;
import java.awt.event.MouseEvent;
import org.jmathplot.gui.PlotPanel;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.Base3D;
import org.jmathplot.gui.plotObjects.Grid;
import org.jmathplot.gui.plots.BarPlot;
import org.jmathplot.gui.plots.BoxPlot3D;
import org.jmathplot.gui.plots.HistogramPlot3D;
import org.jmathplot.gui.plots.LinePlot;
import org.jmathplot.gui.plots.Plot;
import org.jmathplot.gui.plots.ScatterPlot;
import org.jmathplot.gui.plots.StaircasePlot;
import org.jmathplot.util.DoubleArray;

public class Plot3DPanel
extends PlotPanel {
    public static final int ROTATION = 2;

    public Plot3DPanel() {
    }

    public Plot3DPanel(double[] dArray, double[] dArray2, int[] nArray, String[] stringArray) {
        super(dArray, dArray2, nArray, stringArray);
    }

    public Plot3DPanel(double[][] dArray, String string, String string2) {
        super(DoubleArray.getColumns(DoubleArray.min(dArray), 0, 2), DoubleArray.getColumns(DoubleArray.max(dArray), 0, 2));
        this.addPlot(dArray, string, string2);
    }

    public void initBasenGrid(double[] dArray, double[] dArray2, int[] nArray, String[] stringArray) {
        this.base = new Base3D(dArray, dArray2, panelSize, nArray, Base.DEFAULT_BORDER);
        this.grid = new Grid(this.base, stringArray);
    }

    public void initBasenGrid(double[] dArray, double[] dArray2) {
        this.initBasenGrid(dArray, dArray2, new int[]{0, 0, 0}, new String[]{"X", "Y", "Z"});
    }

    public void initBasenGrid() {
        this.initBasenGrid(new double[]{0.0, 0.0, 0.0}, new double[]{1.0, 1.0, 1.0});
    }

    public void setAxesLabels(String string, String string2, String string3) {
        this.setAxesLabels(new String[]{string, string2, string3});
    }

    public void addPlot(double[][] dArray, String string, String string2, Color color) {
        Plot plot = null;
        if (string2.equals("SCATTER")) {
            DoubleArray.checkColumnDimension(dArray, 3);
            plot = new ScatterPlot(dArray, color, string, this.base);
        } else if (string2.equals("LINE")) {
            DoubleArray.checkColumnDimension(dArray, 3);
            plot = new LinePlot(dArray, color, string, this.base);
        } else if (string2.equals("BAR")) {
            DoubleArray.checkColumnDimension(dArray, 3);
            plot = new BarPlot(dArray, color, string, this.base);
        } else if (string2.equals("HISTOGRAM")) {
            DoubleArray.checkColumnDimension(dArray, 5);
            plot = new HistogramPlot3D(DoubleArray.getColumns(dArray, 0, 2), DoubleArray.getColumns(dArray, 3, 4), color, string, this.base);
        } else if (string2.equals("BOX")) {
            DoubleArray.checkColumnDimension(dArray, 9);
            plot = new BoxPlot3D(DoubleArray.getColumns(dArray, 0, 2), DoubleArray.getColumns(dArray, 3, 8), color, string, this.base);
        } else if (string2.equals("STAIRCASE")) {
            DoubleArray.checkColumnDimension(dArray, 3);
            plot = new StaircasePlot(dArray, color, string, this.base);
        } else {
            throw new IllegalArgumentException("Plot type is unknown : " + string2);
        }
        this.addPlot(plot);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseCurent[0] = mouseEvent.getX();
        this.mouseCurent[1] = mouseEvent.getY();
        mouseEvent.consume();
        switch (this.ActionMode) {
            case 1: {
                int[] nArray = new int[]{this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]};
                this.base.translate(nArray);
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
                break;
            }
            case 2: {
                int[] nArray = new int[]{this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]};
                ((Base3D)this.base).rotate(nArray, panelSize, this.base.getBorder());
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
            }
        }
        this.repaint();
    }
}

