/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import org.jmathplot.gui.DataPanel;
import org.jmathplot.gui.PlotPanel;

public class DataToolBar
extends JToolBar {
    protected JButton buttonPasteToClipboard;
    protected JButton buttonSaveFile;
    private boolean denySaveSecurity;
    private JFileChooser fileChooser;
    private DataPanel dataPanel;

    public DataToolBar(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
        try {
            this.fileChooser = new JFileChooser();
        }
        catch (AccessControlException accessControlException) {
            this.denySaveSecurity = true;
        }
        this.buttonPasteToClipboard = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/toclipboard.png")));
        this.buttonPasteToClipboard.setToolTipText("Copy data to ClipBoard");
        this.buttonSaveFile = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/tofile.png")));
        this.buttonSaveFile.setToolTipText("Save data into ASCII file");
        this.buttonPasteToClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolBar.this.dataPanel.toClipBoard();
            }
        });
        this.buttonSaveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolBar.this.chooseFile();
            }
        });
        this.add((Component)this.buttonPasteToClipboard, null);
        this.add((Component)this.buttonSaveFile, null);
        if (!this.denySaveSecurity) {
            this.fileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolBar.this.saveFile();
                }
            });
        } else {
            this.buttonSaveFile.setEnabled(false);
        }
    }

    void saveFile() {
        File file = this.fileChooser.getSelectedFile();
        this.dataPanel.toASCIIFile(file);
    }

    void chooseFile() {
        this.fileChooser.showSaveDialog(this);
    }
}

