/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plotObjects;

import java.awt.Color;
import java.awt.Graphics;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.BaseLabel;
import org.jmathplot.gui.plotObjects.BaseScalesDependant;
import org.jmathplot.gui.plotObjects.Coord;
import org.jmathplot.gui.plotObjects.Label;
import org.jmathplot.gui.plotObjects.Line;
import org.jmathplot.gui.plotObjects.Plotable;
import org.jmathplot.gui.plotObjects.RelativeCoord;

public class Axe
implements Plotable,
BaseScalesDependant {
    public int linear_slicing;
    public double label_offset;
    protected int index;
    protected Base base;
    protected double[] linesSlicing;
    protected double[] labelsSlicing;
    protected String name;
    protected Coord origin;
    protected Coord end;
    protected Line darkLine;
    protected Line[][] lightLines;
    protected Label darkLabel;
    protected Label[] lightLabels;

    public Axe(Base base, String string, int n) {
        this.base = base;
        this.name = string;
        this.index = n;
        this.linear_slicing = 10;
        this.label_offset = 0.05;
        this.updateBase();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    private void setOriginEnd() {
        this.origin = new RelativeCoord(this.base.getCoords()[0].getPlotCoordCopy(), this.base);
        this.end = new RelativeCoord(this.base.getCoords()[this.index + 1].getPlotCoordCopy(), this.base);
    }

    private void setSlicing() {
        block5: {
            block4: {
                int n;
                if (this.base.getAxeScale(this.index) != 1) break block4;
                int n2 = (int)Math.rint(Math.log(this.base.getMaxBounds()[this.index] / this.base.getMinBounds()[this.index]) / Math.log(10.0));
                double d = Math.rint(Math.log(this.base.getMinBounds()[this.index]) / Math.log(10.0));
                this.linesSlicing = new double[n2 * 9 + 1];
                this.labelsSlicing = new double[n2 + 1];
                for (n = 0; n < n2 + 1; ++n) {
                    this.labelsSlicing[n] = Math.pow(10.0, (double)n + d);
                }
                for (n = 0; n < n2; ++n) {
                    for (int i = 0; i < 10; ++i) {
                        this.linesSlicing[n * 9 + i] = Math.pow(10.0, (double)n + d) * (double)(i + 1);
                    }
                }
                break block5;
            }
            if (this.base.getAxeScale(this.index) != 0) break block5;
            this.linesSlicing = new double[this.linear_slicing + 1];
            this.labelsSlicing = new double[this.linear_slicing + 1];
            double d = this.base.getMinBounds()[this.index];
            double d2 = (this.base.getCoords()[this.index + 1].getPlotCoordCopy()[this.index] - this.base.getCoords()[0].getPlotCoordCopy()[this.index]) / (double)this.linear_slicing;
            for (int i = 0; i < this.linear_slicing + 1; ++i) {
                this.linesSlicing[i] = d + (double)i * d2;
                this.labelsSlicing[i] = d + (double)i * d2;
            }
        }
    }

    public void plot(Graphics graphics) {
        int n;
        for (n = 0; n < this.lightLines.length; ++n) {
            for (int i = 1; i < this.lightLines[n].length; ++i) {
                this.lightLines[n][i].plot(graphics);
            }
        }
        for (n = 0; n < this.lightLabels.length; ++n) {
            this.lightLabels[n].plot(graphics);
        }
        this.darkLine.plot(graphics);
        this.darkLabel.plot(graphics);
    }

    private void setLightLabels() {
        int n;
        double[] dArray = new double[this.base.dimension];
        for (n = 0; n < this.base.getDimension(); ++n) {
            if (n == this.index) continue;
            dArray[n] = -this.label_offset;
        }
        n = 0;
        this.lightLabels = new Label[this.labelsSlicing.length];
        for (int i = 0; i < this.lightLabels.length; ++i) {
            RelativeCoord relativeCoord = BaseLabel.buildRelativeCoord(dArray, this.base);
            relativeCoord.setPlotCoord(this.labelsSlicing[i], this.index);
            if (this.base.getAxeScale(this.index) == 0) {
                n = -((int)(Math.log(this.base.getPrecisionUnit()[this.index] / 100.0) / Math.log(10.0)));
            } else if (this.base.getAxeScale(this.index) == 1) {
                n = -((int)Math.floor(Math.log(this.labelsSlicing[i]) / Math.log(10.0)));
            }
            String string = new String(Label.approx(relativeCoord.getPlotCoordCopy()[this.index], n) + "");
            this.lightLabels[i] = new Label(string, relativeCoord, Color.darkGray);
        }
    }

    private void setLightLines() {
        this.lightLines = new Line[this.base.getDimension() - 1][this.linesSlicing.length];
        int n = 0;
        for (int i = 0; i < this.base.getDimension() - 1; ++i) {
            if (n == this.index) {
                ++n;
            }
            for (int j = 0; j < this.lightLines[i].length; ++j) {
                double[] dArray = this.origin.getPlotCoordCopy();
                double[] dArray2 = this.base.getCoords()[n + 1].getPlotCoordCopy();
                dArray[this.index] = this.linesSlicing[j];
                dArray2[this.index] = this.linesSlicing[j];
                RelativeCoord relativeCoord = new RelativeCoord(dArray, this.base);
                RelativeCoord relativeCoord2 = new RelativeCoord(dArray2, this.base);
                this.lightLines[i][j] = new Line(relativeCoord, relativeCoord2, Color.green);
            }
            ++n;
        }
    }

    private void setDarkLines() {
        this.darkLine = new Line(this.origin, this.end, Color.black);
    }

    private void setDarkLabels() {
        this.darkLabel = new Label(this.name, this.end, Color.black);
        this.darkLabel.setCorner(0.0, 0.0);
    }

    public void updateBase() {
        this.setOriginEnd();
        this.setSlicing();
        this.setDarkLines();
        this.setDarkLabels();
        this.setLightLines();
        this.setLightLabels();
    }
}

