/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plotObjects;

import org.jmathplot.gui.plotObjects.AbsoluteCoord;
import org.jmathplot.gui.plotObjects.Coord;
import org.jmathplot.gui.plotObjects.RelativeCoord;
import org.jmathplot.io.CommandLinePrintable;

public abstract class Base
implements CommandLinePrintable {
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static double DEFAULT_BORDER = 0.15;
    protected Coord[] baseCoords;
    protected double[] precisionUnit;
    protected double[] Xmin;
    protected double[] Xmax;
    protected int[] panelSize;
    protected int dimension;
    protected double borderCoeff;
    protected int[] axesScales;

    public Base(Coord[] coordArray) {
        this.baseCoords = coordArray;
    }

    public Base(double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, double d) {
        this.dimension = dArray.length;
        this.axesScales = nArray2;
        this.panelSize = nArray;
        this.borderCoeff = d;
        this.initBounds(dArray.length);
        this.setnRoundBounds(dArray, dArray2);
        this.setBaseCoords();
    }

    public void setPanelSize(int[] nArray) {
        this.panelSize = nArray;
    }

    public void setAxesScales(int[] nArray) {
        this.axesScales = nArray;
        this.setnRoundBounds(this.Xmin, this.Xmax);
        this.setBaseCoords();
    }

    public void setAxesScales(int n, int n2) {
        this.axesScales[n] = n2;
        this.setnRoundBounds(this.Xmin, this.Xmax);
        this.setBaseCoords();
    }

    private void setPrecisionUnit(int n, double d, double d2) {
        this.precisionUnit[n] = d2 - d > 0.0 ? Math.pow(10.0, Math.rint(Math.log(d2 - d) / Math.log(10.0))) : 1.0;
    }

    public double getBorder() {
        return this.borderCoeff;
    }

    public Coord[] getCoords() {
        return this.baseCoords;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] getAxesScales() {
        return this.axesScales;
    }

    public int getAxeScale(int n) {
        return this.axesScales[n];
    }

    public double[] getMinBounds() {
        return this.Xmin;
    }

    public double[] getMaxBounds() {
        return this.Xmax;
    }

    public double[] getPrecisionUnit() {
        return this.precisionUnit;
    }

    private void initBounds(int n) {
        this.Xmin = new double[n];
        this.Xmax = new double[n];
    }

    private void setBounds(int n, double d, double d2) {
        if (d < 0.0 && this.axesScales[n] == 1) {
            throw new IllegalArgumentException("Error while bounding dimension " + (n + 1) + " : bounds [" + d + "," + d2 + "] are incompatible with Logarithm scale.");
        }
        if (d == d2) {
            d = d2 - 1.0;
        }
        if (d > d2) {
            throw new IllegalArgumentException("Error while bounding dimension " + (n + 1) + " : min " + d + " must be < to max " + d2);
        }
        this.Xmin[n] = d;
        this.Xmax[n] = d2;
    }

    private void setBounds(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            this.setBounds(i, dArray[i], dArray2[i]);
        }
    }

    public void setFixedBounds(int n, double d, double d2) {
        this.setPrecisionUnit(n, d, d2);
        this.setBounds(n, d, d2);
    }

    public void setFixedBounds(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            this.setFixedBounds(i, dArray[i], dArray2[i]);
        }
    }

    public void setnRoundBounds(int n, double d, double d2) {
        this.setPrecisionUnit(n, d, d2);
        if (this.axesScales[n] == 1) {
            this.setBounds(n, Math.pow(10.0, Math.floor(Math.log(d) / Math.log(10.0))), Math.pow(10.0, Math.ceil(Math.log(d2) / Math.log(10.0))));
        } else if (this.axesScales[n] == 0) {
            this.setBounds(n, this.precisionUnit[n] * Math.floor(d / this.precisionUnit[n]), this.precisionUnit[n] * Math.ceil(d2 / this.precisionUnit[n]));
        }
    }

    public void setnRoundBounds(double[] dArray, double[] dArray2) {
        this.precisionUnit = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.setnRoundBounds(i, dArray[i], dArray2[i]);
        }
    }

    public void includeInBounds(int n, double d) {
        double[] dArray = new double[this.Xmin.length];
        for (int i = 0; i < this.Xmin.length; ++i) {
            dArray[i] = i == n ? Math.min(d, this.Xmin[i]) : this.Xmin[i];
        }
        double[] dArray2 = new double[this.Xmax.length];
        for (int i = 0; i < this.Xmax.length; ++i) {
            dArray2[i] = i == n ? Math.max(d, this.Xmax[i]) : this.Xmax[i];
        }
        this.setnRoundBounds(dArray, dArray2);
        this.setBaseCoords();
    }

    public void includeInBounds(double[] dArray) {
        double[] dArray2 = new double[this.Xmin.length];
        for (int i = 0; i < this.Xmin.length; ++i) {
            dArray2[i] = Math.min(dArray[i], this.Xmin[i]);
        }
        double[] dArray3 = new double[this.Xmax.length];
        for (int i = 0; i < this.Xmax.length; ++i) {
            dArray3[i] = Math.max(dArray[i], this.Xmax[i]);
        }
        this.setnRoundBounds(dArray2, dArray3);
        this.setBaseCoords();
    }

    public void translate(int[] nArray) {
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i].setScreenCoord(new int[]{this.baseCoords[i].getScreenCoordCopy()[0] + nArray[0], this.baseCoords[i].getScreenCoordCopy()[1] + nArray[1]});
        }
    }

    public void dilate(int[] nArray, double[] dArray) {
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i].setScreenCoord(new int[]{(int)((double)(this.baseCoords[i].getScreenCoordCopy()[0] - nArray[0]) / dArray[0]), (int)((double)(this.baseCoords[i].getScreenCoordCopy()[1] - nArray[1]) / dArray[1])});
        }
    }

    public void updateScreenCoord() {
        for (int i = 0; i < this.baseCoords.length; ++i) {
            double[] dArray = this.baseCoordsScreenProjectionRatio(this.baseCoords[i].getPlotCoordCopy());
            int[] nArray = new int[]{(int)((double)this.panelSize[0] * (this.borderCoeff + (1.0 - 2.0 * this.borderCoeff) * dArray[0])), (int)((double)this.panelSize[1] - (double)this.panelSize[1] * (this.borderCoeff + (1.0 - 2.0 * this.borderCoeff) * dArray[1]))};
            this.baseCoords[i] = new AbsoluteCoord(this.baseCoords[i].getPlotCoordCopy(), nArray);
        }
    }

    public void setBaseCoords() {
        this.baseCoords = new AbsoluteCoord[this.Xmin.length + 1];
        for (int i = 0; i < this.Xmin.length + 1; ++i) {
            double[] dArray = (double[])this.Xmin.clone();
            if (i > 0) {
                dArray[i - 1] = this.Xmax[i - 1];
            }
            double[] dArray2 = this.baseCoordsScreenProjectionRatio(dArray);
            int[] nArray = new int[]{(int)((double)this.panelSize[0] * (this.borderCoeff + (1.0 - 2.0 * this.borderCoeff) * dArray2[0])), (int)((double)this.panelSize[1] - (double)this.panelSize[1] * (this.borderCoeff + (1.0 - 2.0 * this.borderCoeff) * dArray2[1]))};
            this.baseCoords[i] = new AbsoluteCoord(dArray, nArray);
        }
    }

    public int[] screenProjection(double[] dArray) {
        double[] dArray2 = new double[]{this.baseCoords[0].getScreenCoordCopy()[0], this.baseCoords[0].getScreenCoordCopy()[1]};
        for (int i = 0; i < this.baseCoords[0].getPlotCoordCopy().length; ++i) {
            if (this.axesScales[i] == 1) {
                dArray2[0] = dArray2[0] + (Math.log(dArray[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) / (Math.log(this.baseCoords[i + 1].getPlotCoordCopy()[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[0] - this.baseCoords[0].getScreenCoordCopy()[0]);
                dArray2[1] = dArray2[1] + (Math.log(dArray[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) / (Math.log(this.baseCoords[i + 1].getPlotCoordCopy()[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[1] - this.baseCoords[0].getScreenCoordCopy()[1]);
                continue;
            }
            if (this.axesScales[i] != 0) continue;
            dArray2[0] = dArray2[0] + (dArray[i] - this.baseCoords[0].getPlotCoordCopy()[i]) / (this.baseCoords[i + 1].getPlotCoordCopy()[i] - this.baseCoords[0].getPlotCoordCopy()[i]) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[0] - this.baseCoords[0].getScreenCoordCopy()[0]);
            dArray2[1] = dArray2[1] + (dArray[i] - this.baseCoords[0].getPlotCoordCopy()[i]) / (this.baseCoords[i + 1].getPlotCoordCopy()[i] - this.baseCoords[0].getPlotCoordCopy()[i]) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[1] - this.baseCoords[0].getScreenCoordCopy()[1]);
        }
        return new int[]{(int)dArray2[0], (int)dArray2[1]};
    }

    protected abstract double[] baseCoordsScreenProjectionRatio(double[] var1);

    public RelativeCoord getGravCenter() {
        double[] dArray = this.baseCoords[0].getPlotCoordCopy();
        for (int i = 0; i < this.baseCoords.length - 1; ++i) {
            dArray[i] = dArray[i] + this.baseCoords[i].getPlotCoordCopy()[i] / 2.0;
        }
        return new RelativeCoord(dArray, this);
    }

    public boolean authorizedLogScale(int n) {
        System.out.println("Xmin[" + n + "] = " + this.Xmin[n]);
        return this.Xmin[n] > 0.0;
    }

    public void toCommandLine(String string) {
        System.out.println(string + " : ");
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i].toCommandLine("point " + i);
        }
    }
}

