/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmathplot.gui.FrameView;
import org.jmathplot.gui.Plot2DPanel;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plots.Plot;
import org.jmathplot.util.DoubleArray;

public class BoxPlot2D
extends Plot {
    private double[][] widths;

    public BoxPlot2D(double[][] dArray, double[][] dArray2, Color color, String string, Base base) {
        super(dArray, color, string, base);
        this.widths = dArray2;
        double[] dArray3 = DoubleArray.min(this.datas);
        double[] dArray4 = DoubleArray.min(this.widths);
        double[] dArray5 = DoubleArray.max(this.datas);
        double[] dArray6 = DoubleArray.max(this.widths);
        this.base.includeInBounds(new double[]{dArray3[0] - dArray6[0], dArray3[1] - dArray6[2]});
        this.base.includeInBounds(new double[]{dArray5[0] + dArray6[1], dArray5[1] - dArray6[3]});
    }

    public void plot(Graphics graphics, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        for (int i = 0; i < this.datas.length; ++i) {
            double[] dArray = new double[]{this.datas[i][0] - this.widths[i][0], this.datas[i][1]};
            double[] dArray2 = new double[]{this.datas[i][0] + this.widths[i][1], this.datas[i][1]};
            double[] dArray3 = new double[]{this.datas[i][0], this.datas[i][1] - this.widths[i][2]};
            double[] dArray4 = new double[]{this.datas[i][0], this.datas[i][1] + this.widths[i][3]};
            double[] dArray5 = new double[]{this.datas[i][0], this.datas[i][1]};
            this.drawLine(dArray, dArray2, graphics2D);
            this.drawLine(dArray3, dArray4, graphics2D);
            this.drawDot(dArray5, graphics2D);
        }
    }

    public void note(Graphics graphics) {
        this.plot(graphics, Color.black);
    }

    public static void main(String[] stringArray) {
        double[][] dArray = DoubleArray.random(10, 6);
        new FrameView(new Plot2DPanel(dArray, "Box Plot 2D", "BOX"));
    }
}

