/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.io.files;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Calendar;
import java.util.Vector;
import org.jmathplot.io.files.DataFile;

public class ASCIIFile
extends DataFile {
    public ASCIIFile(File file) {
        super(file);
    }

    public static String read(File file) {
        ASCIIFile aSCIIFile = new ASCIIFile(file);
        return aSCIIFile.read();
    }

    public static String[] readLines(File file) {
        ASCIIFile aSCIIFile = new ASCIIFile(file);
        return aSCIIFile.readLines();
    }

    public static String readLine(File file, int n) {
        ASCIIFile aSCIIFile = new ASCIIFile(file);
        return aSCIIFile.readLine(n);
    }

    public static void write(File file, String string) {
        ASCIIFile aSCIIFile = new ASCIIFile(file);
        aSCIIFile.write(string, false);
    }

    public static void append(File file, String string) {
        ASCIIFile aSCIIFile = new ASCIIFile(file);
        aSCIIFile.write(string, true);
    }

    public String read() {
        StringBuffer stringBuffer = new StringBuffer((int)this.file.length());
        try {
            FileReader fileReader = new FileReader(this.file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean bl = false;
            String string = "\n";
            while (!bl) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    bl = true;
                    continue;
                }
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + iOException.toString());
        }
        return stringBuffer.toString();
    }

    public String[] readLines() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        try {
            stringArray = new FileReader(this.file);
            BufferedReader bufferedReader = new BufferedReader((Reader)stringArray);
            boolean bl = false;
            while (!bl) {
                String string = bufferedReader.readLine();
                if (string == null) {
                    bl = true;
                    continue;
                }
                vector.add(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + iOException.toString());
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public String readLine(int n) {
        String string = new String("");
        try {
            FileReader fileReader = new FileReader(this.file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    throw new IllegalArgumentException("Line " + n + " is not found in the file " + this.file.getName() + ".");
                }
                bufferedReader.readLine();
                if (string != null) continue;
                bl = true;
            }
            string = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + iOException.toString());
        }
        return string;
    }

    public void write(String string, boolean bl) {
        if (this.file.exists()) {
            System.out.println("Warning : the file " + this.file.getName() + " already exists !");
        }
        try {
            FileWriter fileWriter = new FileWriter(this.file, bl);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unwritable : " + iOException.toString());
        }
    }

    public static void main(String[] stringArray) {
        File file = new File("read.txt");
        System.out.println(ASCIIFile.read(file));
        String[] stringArray2 = ASCIIFile.readLines(file);
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("line " + i + " : " + stringArray2[i]);
        }
        System.out.println(ASCIIFile.readLine(file, 0));
        System.out.println(ASCIIFile.readLine(file, stringArray2.length - 1));
        ASCIIFile.append(new File("write.txt"), Calendar.getInstance().getTime().toString());
    }
}

