/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.csplugins.ExpressionCorrelation;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.jmathplot.gui.Plot2DPanel;
import org.mskcc.csplugins.ExpressionCorrelation.CorrelateSimilarityNetwork;
import org.mskcc.csplugins.ExpressionCorrelation.CorrelateTask;
import org.mskcc.csplugins.ExpressionCorrelation.JMultiLineToolTip;

public class CorrelateHistogramWindow
extends JDialog {
    private CorrelateSimilarityNetwork network;
    JFormattedTextField lowCutoffValue;
    JFormattedTextField highCutoffValue;
    JFormattedTextField interactionsValue;
    JCheckBox lowCheckBox;
    JCheckBox highCheckBox;
    JComboBox percentNumberComboBox;
    boolean isRow = false;
    double[] cutoffs = new double[2];
    Number valueLow;
    Number valueHigh;
    Number valueInteractions;
    String selectedString = "Number of Interactions";

    public CorrelateHistogramWindow(Frame frame, boolean bl, CorrelateSimilarityNetwork correlateSimilarityNetwork) {
        super(frame, "Matrix Parameters", false);
        this.setResizable(false);
        this.isRow = bl;
        this.network = correlateSimilarityNetwork;
        if (this.isRow) {
            this.network.loadRowCutoffs();
            this.network.rowHistogram();
        } else {
            this.network.loadColCutoffs();
            this.network.colHistogram();
        }
        if (this.network.cancelled()) {
            return;
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setParseIntegerOnly(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout(20, 4));
        this.lowCutoffValue = new JFormattedTextField(new DecimalFormat("-0.000")){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.lowCutoffValue.setColumns(4);
        this.lowCutoffValue.addPropertyChangeListener("value", new formattedTextFieldAction());
        String string = "Look at the Histogram and set the low cutoff for the network that you want displayed.\nOr deselect the checkbox if you do not want a low cutoff value";
        this.lowCutoffValue.setToolTipText(string);
        this.cutoffs = this.network.getCutoffs(this.isRow);
        this.lowCutoffValue.setText(Double.toString(this.cutoffs[0]));
        JLabel jLabel = new JLabel("Low Cutoff");
        this.lowCheckBox = new JCheckBox("Low", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.lowCheckBox.addItemListener(new lowCheckBoxAction());
        this.lowCheckBox.setToolTipText("If checked, allows you to set the low cutoff value. \nIf not, a low cuttof value will not be used in the percent calculation");
        this.lowCheckBox.setSelected(true);
        JPanel jPanel4 = new JPanel(new FlowLayout(0)){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel4.setToolTipText(string);
        jPanel4.add(jLabel);
        jPanel4.add(this.lowCutoffValue);
        jPanel4.add(this.lowCheckBox);
        jPanel3.add((Component)jPanel4, "West");
        this.highCutoffValue = new JFormattedTextField(new DecimalFormat("0.000")){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.highCutoffValue.setColumns(3);
        this.highCutoffValue.addPropertyChangeListener("value", new formattedTextFieldAction());
        String string2 = "Look at the Histogram and set the high cutoff for the network that you want displayed.\nOr deselect the checkbox if you do not want a high cutoff value";
        this.highCutoffValue.setToolTipText(string2);
        this.cutoffs = this.network.getCutoffs(this.isRow);
        this.highCutoffValue.setText(Double.toString(this.cutoffs[1]));
        JLabel jLabel2 = new JLabel("High Cutoff");
        this.highCheckBox = new JCheckBox("High", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.highCheckBox.addItemListener(new highCheckBoxAction());
        this.highCheckBox.setToolTipText("If checked, allows you to set the high cutoff value. \nIf not, a high cuttof value will not be used in the percent calculation");
        this.highCheckBox.setSelected(true);
        JPanel jPanel5 = new JPanel(new FlowLayout(2)){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel5.setToolTipText(string2);
        jPanel5.add(jLabel2);
        jPanel5.add(this.highCutoffValue);
        jPanel5.add(this.highCheckBox);
        jPanel3.add((Component)jPanel5, "East");
        JPanel jPanel6 = new JPanel(new BorderLayout(25, 4));
        this.interactionsValue = new JFormattedTextField(new DecimalFormat("########.0####")){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.interactionsValue.setColumns(6);
        this.interactionsValue.addPropertyChangeListener("value", new formattedTextFieldAction());
        String string3 = "Select either the number of interactions you want displayed.\nOr the percent of interactions you want diplayed";
        this.interactionsValue.setToolTipText(string3);
        this.cutoffs = this.network.getCutoffs(this.isRow);
        this.interactionsValue.setText(Integer.toString(this.network.getNumberOfInteractions(this.isRow, this.cutoffs)));
        JLabel jLabel3 = new JLabel("Enter: ");
        JPanel jPanel7 = new JPanel(new FlowLayout(2)){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel7.setToolTipText(string3);
        jPanel7.add(jLabel3);
        jPanel7.add(this.interactionsValue);
        jPanel6.add((Component)jPanel7, "West");
        String string4 = "Check this box to create a Network with the Number of Interactions \nyou want displayed and to set the appropriate cutoffs";
        this.percentNumberComboBox = new JComboBox();
        this.percentNumberComboBox.addItem("Number of Interactions");
        this.percentNumberComboBox.addItem("Percent of Interactions");
        this.percentNumberComboBox.addItemListener(new percentNumberComboBox_Action());
        this.percentNumberComboBox.setToolTipText(string4);
        JPanel jPanel8 = new JPanel(new FlowLayout(0)){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        jPanel8.setToolTipText(string4);
        jPanel8.add(this.percentNumberComboBox);
        jPanel6.add((Component)jPanel8, "East");
        jPanel6.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel9 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new OKAction(this));
        jPanel9.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new cancelAction(this));
        jPanel9.add(jButton2);
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jPanel6, "South");
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        Plot2DPanel plot2DPanel = new Plot2DPanel(this.network.getHistogram(this.isRow), "Similarity  Histogram", "HISTOGRAM");
        jPanel.add((Component)plot2DPanel, "Center");
        jPanel.add((Component)jPanel9, "South");
        this.setContentPane(jPanel);
    }

    public void lowGetSet() {
        this.valueLow = (Number)this.lowCutoffValue.getValue();
        if (this.valueLow != null) {
            double d = -this.valueLow.doubleValue();
            System.out.println("The low in the box is: " + d);
            if (d < 0.0 && d >= -1.0) {
                if (this.isRow) {
                    this.network.setRowNegCutoff(d);
                } else {
                    this.network.setColNegCutoff(d);
                }
                this.getSet();
                this.cutoffs = this.network.getCutoffs(this.isRow);
                System.out.println("Low change: " + this.isRow + " | " + this.cutoffs[0] + " + " + this.cutoffs[1]);
                this.lowCutoffValue.setText(Double.toString(this.cutoffs[0]));
            }
        }
    }

    public void highGetSet() {
        boolean bl = true;
        this.valueHigh = (Number)this.highCutoffValue.getValue();
        System.out.println("I am in HIGH");
        if (this.valueHigh != null) {
            double d = this.valueHigh.doubleValue();
            System.out.println("The high in the box is: " + d);
            if (d > 0.0 && d <= 1.0) {
                if (this.isRow) {
                    this.network.setRowPosCutoff(d);
                } else {
                    this.network.setColPosCutoff(d);
                }
                this.getSet();
                this.cutoffs = this.network.getCutoffs(this.isRow);
                System.out.println("High change: " + this.isRow + " | " + this.cutoffs[0] + " + " + this.cutoffs[1]);
                this.highCutoffValue.setText(Double.toString(this.cutoffs[1]));
            }
        }
    }

    public void getSet() {
        this.cutoffs = this.network.getCutoffs(this.isRow);
        this.selectedString = (String)this.percentNumberComboBox.getSelectedItem();
        if (this.selectedString.equals("Number of Interactions")) {
            System.out.println("Number of interactions cutoffs: " + this.cutoffs[0] + " | " + this.cutoffs[1]);
            this.interactionsValue.setText(Integer.toString(this.network.getNumberOfInteractions(this.isRow, this.cutoffs)));
        } else if (this.selectedString.equals("Percent of Interactions")) {
            this.interactionsValue.setText(Double.toString(this.network.getPercentOfInteractions(this.isRow, this.cutoffs)));
            System.out.println("Percent of interactions cutoffs: " + this.cutoffs[0] + " | " + this.cutoffs[1]);
        }
    }

    public void interactionsGetSet() {
        this.valueInteractions = (Number)this.interactionsValue.getValue();
        this.selectedString = (String)this.percentNumberComboBox.getSelectedItem();
        if (this.selectedString.equals("Number of Interactions") && this.valueInteractions != null) {
            int n = this.valueInteractions.intValue();
            if (n >= 0) {
                System.out.println("The intValue: " + n);
                this.network.setCutoffsInteractions(this.isRow, n);
                this.cutoffs = this.network.getCutoffs(this.isRow);
                System.out.println("Interactions cutoffs are:" + this.cutoffs[0] + " " + this.cutoffs[1]);
                this.lowCutoffValue.setText(Double.toString(this.cutoffs[0]));
                this.highCutoffValue.setText(Double.toString(this.cutoffs[1]));
                this.getSet();
            }
        } else if (this.selectedString.equals("Percent of Interactions") && this.valueInteractions != null) {
            double d = this.valueInteractions.doubleValue();
            if (d < 0.0 || d > 1.0) {
                d = 1.0;
                this.network.setCutoffsPercent(this.isRow, d);
                this.cutoffs = this.network.getCutoffs(this.isRow);
                this.interactionsValue.setText(Double.toString(this.network.getPercentOfInteractions(this.isRow, this.cutoffs)));
            }
            this.network.setCutoffsPercent(this.isRow, d);
            this.cutoffs = this.network.getCutoffs(this.isRow);
            this.lowCutoffValue.setText(Double.toString(this.cutoffs[0]));
            this.highCutoffValue.setText(Double.toString(this.cutoffs[1]));
        }
    }

    private class cancelAction
    extends AbstractAction {
        private JDialog dialog;

        cancelAction(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        private JDialog dialog;

        OKAction(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.dispose();
            int n = 1000;
            int n2 = 2;
            try {
                n = Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold"));
                System.out.println("viewThreshold is " + n);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (CorrelateHistogramWindow.this.isRow) {
                CorrelateHistogramWindow.this.interactionsGetSet();
                CorrelateHistogramWindow.this.network.saveRowCutoffs();
                n2 = 4;
            } else {
                CorrelateHistogramWindow.this.interactionsGetSet();
                CorrelateHistogramWindow.this.network.saveColCutoffs();
            }
            CorrelateHistogramWindow.this.cutoffs = CorrelateHistogramWindow.this.network.getCutoffs(CorrelateHistogramWindow.this.isRow);
            CorrelateTask correlateTask = new CorrelateTask(n2, CorrelateHistogramWindow.this.network);
            JTaskConfig jTaskConfig = new JTaskConfig();
            jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
            jTaskConfig.displayCloseButton(true);
            jTaskConfig.displayCancelButton(true);
            jTaskConfig.displayStatus(true);
            boolean bl = TaskManager.executeTask((Task)correlateTask, (JTaskConfig)jTaskConfig);
            CorrelateHistogramWindow.this.cutoffs = CorrelateHistogramWindow.this.network.getCutoffs(CorrelateHistogramWindow.this.isRow);
        }
    }

    private class percentNumberComboBox_Action
    implements ItemListener {
        private percentNumberComboBox_Action() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            String string = (String)CorrelateHistogramWindow.this.percentNumberComboBox.getSelectedItem();
            if (string.equals("Number of Interactions")) {
                CorrelateHistogramWindow.this.interactionsValue.setText(Integer.toString(CorrelateHistogramWindow.this.network.getNumberOfInteractions(CorrelateHistogramWindow.this.isRow, CorrelateHistogramWindow.this.cutoffs)));
            } else if (string.equals("Percent of Interactions")) {
                CorrelateHistogramWindow.this.interactionsValue.setText(Double.toString(CorrelateHistogramWindow.this.network.getPercentOfInteractions(CorrelateHistogramWindow.this.isRow, CorrelateHistogramWindow.this.cutoffs)));
            }
        }
    }

    private class highCheckBoxAction
    implements ItemListener {
        private highCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            double d = 1.0;
            if (itemEvent.getStateChange() == 2) {
                if (CorrelateHistogramWindow.this.isRow) {
                    CorrelateHistogramWindow.this.network.setRowPosUse(false);
                } else {
                    CorrelateHistogramWindow.this.network.setColPosUse(false);
                }
                CorrelateHistogramWindow.this.getSet();
                CorrelateHistogramWindow.this.highCutoffValue.setEnabled(false);
            } else {
                if (CorrelateHistogramWindow.this.isRow) {
                    CorrelateHistogramWindow.this.network.setRowPosUse(true);
                } else {
                    CorrelateHistogramWindow.this.network.setColPosUse(true);
                }
                if (CorrelateHistogramWindow.this.interactionsValue != null) {
                    CorrelateHistogramWindow.this.getSet();
                }
                CorrelateHistogramWindow.this.highCutoffValue.setEnabled(true);
            }
        }
    }

    private class lowCheckBoxAction
    implements ItemListener {
        private lowCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            double d = -1.0;
            if (itemEvent.getStateChange() == 2) {
                if (CorrelateHistogramWindow.this.isRow) {
                    CorrelateHistogramWindow.this.network.setRowNegUse(false);
                } else {
                    CorrelateHistogramWindow.this.network.setColNegUse(false);
                }
                CorrelateHistogramWindow.this.getSet();
                CorrelateHistogramWindow.this.lowCutoffValue.setEnabled(false);
            } else {
                if (CorrelateHistogramWindow.this.isRow) {
                    CorrelateHistogramWindow.this.network.setRowNegUse(true);
                } else {
                    CorrelateHistogramWindow.this.network.setColNegUse(true);
                }
                if (CorrelateHistogramWindow.this.interactionsValue != null) {
                    CorrelateHistogramWindow.this.getSet();
                }
                CorrelateHistogramWindow.this.lowCutoffValue.setEnabled(true);
            }
        }
    }

    private class formattedTextFieldAction
    implements PropertyChangeListener {
        private formattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object == CorrelateHistogramWindow.this.lowCutoffValue) {
                CorrelateHistogramWindow.this.lowGetSet();
            } else if (object == CorrelateHistogramWindow.this.highCutoffValue) {
                CorrelateHistogramWindow.this.highGetSet();
            } else if (object == CorrelateHistogramWindow.this.interactionsValue) {
                CorrelateHistogramWindow.this.interactionsGetSet();
            }
        }
    }
}

