/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.csplugins.ExpressionCorrelation;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.awt.Frame;
import org.mskcc.csplugins.ExpressionCorrelation.CorrelateHistogramWindow;
import org.mskcc.csplugins.ExpressionCorrelation.CorrelateSimilarityNetwork;

public class CorrelateTask
implements Task {
    private CorrelateSimilarityNetwork network;
    private TaskMonitor taskMonitor = null;
    private CorrelateHistogramWindow histogram = null;
    boolean colDone = false;
    public int event = 0;

    public CorrelateTask(int n, CorrelateSimilarityNetwork correlateSimilarityNetwork) {
        this.network = correlateSimilarityNetwork;
        this.event = n;
    }

    public void run() {
        if (this.network.getTaskMonitor() == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        switch (this.event) {
            case 1: {
                this.colRun();
                this.rowRun();
                break;
            }
            case 2: {
                this.colRun();
                break;
            }
            case 3: {
                this.colHistogram();
                break;
            }
            case 4: {
                this.rowRun();
                break;
            }
            case 5: {
                this.rowHistogram();
            }
        }
    }

    private void cleanup(String string) {
        System.out.println("Removing network with id: " + string);
        if (string != null) {
            CyNetwork cyNetwork = Cytoscape.getNetwork((String)string);
            Cytoscape.destroyNetwork((CyNetwork)cyNetwork);
        }
        System.out.println("Finished destroying Network");
    }

    public void halt() {
        this.network.cancel();
        System.out.println("User cancelled task.");
        if (this.histogram != null) {
            System.out.println("Disposing histogram dialog");
            this.histogram.dispose();
            this.histogram.setVisible(false);
        }
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.network.setTaskMonitor(taskMonitor);
    }

    public String getTitle() {
        return new String("Performing correlation calculations");
    }

    public void colRun() {
        if (Cytoscape.getExpressionData() != null) {
            System.out.println("Starting colRun");
            CyNetwork cyNetwork = this.network.calcCols();
            String string = cyNetwork.getIdentifier();
            if (this.network.cancelled()) {
                this.cleanup(string);
            }
            System.out.println("Finished colRun");
        }
    }

    public void rowRun() {
        if (Cytoscape.getExpressionData() != null) {
            System.out.println("Starting rowRun");
            CyNetwork cyNetwork = this.network.calcRows();
            String string = cyNetwork.getIdentifier();
            if (this.network.cancelled()) {
                this.cleanup(string);
            }
            System.out.println("Finished rowRun");
        }
    }

    public void colHistogram() {
        if (Cytoscape.getExpressionData() != null) {
            System.out.println("Starting colHistogram");
            this.histogram = new CorrelateHistogramWindow((Frame)Cytoscape.getDesktop(), false, this.network);
            this.histogram.pack();
            this.histogram.setVisible(true);
        }
    }

    public void rowHistogram() {
        if (Cytoscape.getExpressionData() != null) {
            System.out.println("Starting rowHistogram");
            this.histogram = new CorrelateHistogramWindow((Frame)Cytoscape.getDesktop(), true, this.network);
            this.histogram.pack();
            this.histogram.setVisible(true);
        }
    }
}

