/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.csplugins.ExpressionCorrelation;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import java.util.ArrayList;
import java.util.List;

public class SpearmanRank {
    private List rankInfoList;
    private DoubleMatrix2D distanceMatrix;

    public SpearmanRank(DoubleMatrix2D doubleMatrix2D) {
        System.out.println("Initializing Spearman Rank...");
        this.init(doubleMatrix2D);
    }

    private DoubleMatrix2D sort(DoubleMatrix2D doubleMatrix2D) {
        DoubleMatrix2D doubleMatrix2D2 = Sorting.quickSort.sort(doubleMatrix2D, 0);
        return doubleMatrix2D2;
    }

    private RankInfo rank(double[] dArray) {
        int n = 0;
        int n2 = dArray.length;
        double d = 0.0;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[i];
        }
        while (n < n2 && n != n2 - 1) {
            int n3;
            if (dArray2[n + 1] != dArray2[n] && n < n2) {
                dArray2[n] = n;
                ++n;
                continue;
            }
            for (n3 = n + 1; n3 < n2 && dArray2[n3] == dArray2[n]; ++n3) {
            }
            double d2 = 0.5 * (double)(n + n3 - 1);
            for (int i = n; i <= n3 - 1; ++i) {
                dArray2[i] = d2;
            }
            double d3 = n3 - n;
            d = d + d3 * d3 * d3 - 1.0;
            n = n3;
        }
        if (n == n2 - 1) {
            dArray2[n2 - 1] = n2 - 1;
        }
        return new RankInfo(dArray2, d);
    }

    private static DoubleMatrix2D addIndices(DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix1D.size();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, 2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d = doubleMatrix1D.get(i);
                if (j == 0) {
                    denseDoubleMatrix2D.setQuick(i, j, d);
                    continue;
                }
                denseDoubleMatrix2D.setQuick(i, j, (double)i);
            }
        }
        return denseDoubleMatrix2D;
    }

    private void init(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        this.rankInfoList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            DoubleMatrix1D doubleMatrix1D = doubleMatrix2D.viewRow(i);
            DoubleMatrix2D doubleMatrix2D2 = SpearmanRank.addIndices(doubleMatrix1D);
            DoubleMatrix2D doubleMatrix2D3 = this.sort(doubleMatrix2D2);
            DoubleMatrix1D doubleMatrix1D2 = doubleMatrix2D3.viewColumn(0);
            DoubleMatrix1D doubleMatrix1D3 = doubleMatrix2D3.viewColumn(1);
            double[] dArray = doubleMatrix1D2.toArray();
            RankInfo rankInfo = this.rank(dArray);
            rankInfo.setIndices(doubleMatrix1D3.toArray());
            this.rankInfoList.add(rankInfo);
        }
        System.out.println("rankInfoList contains: " + this.rankInfoList.size() + " number of RankInfos");
        Algebra algebra = new Algebra();
        this.distanceMatrix = Statistic.distance((DoubleMatrix2D)algebra.transpose(doubleMatrix2D), (Statistic.VectorVectorFunction)Statistic.EUCLID);
        System.out.println("The distance matrix is: " + this.distanceMatrix.rows() + " rows by " + this.distanceMatrix.columns() + "columns");
    }

    public double corr(int n, int n2) {
        if (this.rankInfoList.size() == 0) {
            return -2.0;
        }
        RankInfo rankInfo = (RankInfo)this.rankInfoList.get(n);
        RankInfo rankInfo2 = (RankInfo)this.rankInfoList.get(n2);
        double[] dArray = rankInfo.ranking;
        double d = rankInfo.s;
        double[] dArray2 = rankInfo.sortedIndices;
        double[] dArray3 = rankInfo2.ranking;
        double d2 = rankInfo2.s;
        double[] dArray4 = rankInfo2.sortedIndices;
        int n3 = dArray.length;
        double d3 = 0.0;
        double d4 = n3;
        double d5 = d4 * d4 * d4 - d4;
        double d6 = 1.0 - 6.0 * d3 / (d5 - (double)n3);
        return d6;
    }

    private class RankInfo {
        double[] ranking;
        double s = 0.0;
        double[] sortedIndices;

        public RankInfo(double[] dArray, double d) {
            this.ranking = dArray;
            this.s = d;
        }

        public void setIndices(double[] dArray) {
            this.sortedIndices = dArray;
        }
    }
}

