/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jmathplot.gui.components.DataToolBar;
import org.jmathplot.io.ClipBoardPrintable;
import org.jmathplot.io.FilePrintable;
import org.jmathplot.io.StringPrintable;

public abstract class DataPanel
extends JPanel
implements ComponentListener,
FilePrintable,
ClipBoardPrintable,
StringPrintable {
    protected DataToolBar toolBar;
    protected JScrollPane scrollPane;
    public static int[] dimension = new int[]{400, 400};

    public DataPanel() {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.init();
    }

    protected void initToolBar() {
        this.toolBar = new DataToolBar(this);
        this.add((Component)this.toolBar, "North");
        this.toolBar.setFloatable(false);
    }

    protected void init() {
        this.setSize(dimension[0], dimension[1]);
        this.setPreferredSize(new Dimension(dimension[0], dimension[1]));
        this.addComponentListener(this);
    }

    public void update() {
        this.remove(this.scrollPane);
        this.toWindow();
        this.updateUI();
    }

    protected abstract void toWindow();

    public abstract void toClipBoard();

    public abstract void toASCIIFile(File var1);

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        dimension = new int[]{(int)this.getSize().getWidth(), (int)this.getSize().getHeight()};
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

