/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jmathplot.gui.DataPanel;
import org.jmathplot.gui.FrameView;
import org.jmathplot.io.MatrixString;
import org.jmathplot.io.files.ASCIIFile;
import org.jmathplot.util.DoubleArray;

public class MatrixTablePanel
extends DataPanel {
    private JTable table;
    private TableModel model;
    private double[][] M;
    private boolean viewHeaders = false;
    private String[] headers;

    public MatrixTablePanel(double[][] dArray) {
        this.M = dArray;
        this.headers = new String[this.M[0].length];
        this.setModel();
        this.toWindow();
    }

    public void toClipBoard() {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(MatrixString.printMatrix(this.M)), null);
        }
        catch (IllegalStateException illegalStateException) {
            JOptionPane.showConfirmDialog(null, "Copy to clipboard failed : " + illegalStateException.getMessage(), "Error", -1, 0);
        }
    }

    public String toString() {
        return this.M.toString();
    }

    public void toASCIIFile(File file) {
        try {
            ASCIIFile.write(file, MatrixString.printMatrix(this.M));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setModel() {
        Object[][] objectArray = new Double[this.M.length][this.M[0].length];
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[i].length; ++j) {
                objectArray[i][j] = new Double(this.M[i][j]);
            }
        }
        this.model = new DefaultTableModel(objectArray, this.headers);
    }

    public void setHeaders(String[] stringArray) {
        if (stringArray.length != this.M[0].length) {
            throw new IllegalArgumentException("Headers of the table must have " + this.M[0].length + " elements.");
        }
        this.headers = stringArray;
        this.update();
    }

    public void update() {
        this.setModel();
        super.update();
    }

    public void setMatrix(double[][] dArray) {
        this.M = dArray;
        this.headers = new String[this.M[0].length];
        this.update();
    }

    protected void toWindow() {
        this.table = new JTable(this.model);
        if (!this.viewHeaders) {
            this.table.setTableHeader(null);
        }
        this.table.setAutoResizeMode(4);
        this.table.setCellSelectionEnabled(true);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(this.getSize());
        this.scrollPane.setSize(this.getSize());
        this.add((Component)this.scrollPane, "Center");
    }

    public double[][] getMatrix() {
        return this.M;
    }

    public static void main(String[] stringArray) {
        MatrixTablePanel matrixTablePanel = new MatrixTablePanel(DoubleArray.random(20, 3));
        FrameView frameView = new FrameView(matrixTablePanel);
        matrixTablePanel.setMatrix(DoubleArray.random(40, 4));
    }
}

