/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jmathplot.gui.components.DatasFrame;
import org.jmathplot.gui.components.PlotToolBar;
import org.jmathplot.gui.components.SetScalesFrame;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.BaseLabel;
import org.jmathplot.gui.plotObjects.BaseScalesDependant;
import org.jmathplot.gui.plotObjects.Coord;
import org.jmathplot.gui.plotObjects.Grid;
import org.jmathplot.gui.plotObjects.Label;
import org.jmathplot.gui.plotObjects.Plotable;
import org.jmathplot.gui.plotObjects.RelativeCoord;
import org.jmathplot.gui.plots.Plot;
import org.jmathplot.util.DoubleArray;

public abstract class PlotPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener,
BaseScalesDependant {
    public static final int ZOOM = 0;
    public static final int TRANSLATION = 1;
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static final String SCATTER = "SCATTER";
    public static final String LINE = "LINE";
    public static final String BAR = "BAR";
    public static final String HISTOGRAM = "HISTOGRAM";
    public static final String BOX = "BOX";
    public static final String STAIRCASE = "STAIRCASE";
    public static Color[] colorList = new Color[]{Color.blue, Color.red, Color.green, Color.yellow, Color.orange, Color.pink, Color.cyan, Color.magenta};
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    public static int[] panelSize = new int[]{400, 400};
    protected Base base;
    protected Grid grid;
    protected Vector plots;
    protected Vector objects;
    public int ActionMode = 0;
    protected int[] mouseCurent = new int[2];
    protected int[] mouseClick = new int[2];
    public PlotToolBar toolBar;

    public PlotPanel() {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.initPanel();
        this.initBasenGrid();
    }

    public PlotPanel(double[] dArray, double[] dArray2) {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.initPanel();
        this.initBasenGrid(dArray, dArray2);
    }

    public PlotPanel(double[] dArray, double[] dArray2, int[] nArray, String[] stringArray) {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.initPanel();
        this.initBasenGrid(dArray, dArray2, nArray, stringArray);
    }

    private void initToolBar() {
        this.toolBar = new PlotToolBar(this);
        this.add((Component)this.toolBar, "North");
        this.toolBar.setFloatable(false);
    }

    private void initPanel() {
        this.objects = new Vector();
        this.plots = new Vector();
        this.setSize(panelSize[0], panelSize[1]);
        this.setPreferredSize(new Dimension(panelSize[0], panelSize[1]));
        this.setBackground(Color.white);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setActionMode(int n) {
        this.ActionMode = n;
    }

    public void setNoteCoords(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.plots.size(); ++i) {
                ((Plot)this.plots.get(i)).setNoteEachCoord(true);
            }
        } else {
            for (int i = 0; i < this.plots.size(); ++i) {
                ((Plot)this.plots.get(i)).setNoteEachCoord(false);
            }
        }
    }

    public abstract void initBasenGrid(double[] var1, double[] var2, int[] var3, String[] var4);

    public abstract void initBasenGrid(double[] var1, double[] var2);

    public abstract void initBasenGrid();

    public void resetBase() {
        this.base.setBaseCoords();
        this.repaint();
    }

    public Base getBase() {
        return this.base;
    }

    public Plot[] getPlots() {
        Object[] objectArray = new Plot[this.plots.size()];
        this.plots.copyInto(objectArray);
        return objectArray;
    }

    public Plot getPlot(int n) {
        return (Plot)this.plots.get(n);
    }

    public Plotable[] getObjects() {
        Object[] objectArray = new Plotable[this.objects.size()];
        this.objects.copyInto(objectArray);
        return objectArray;
    }

    public Plotable getObject(int n) {
        return (Plotable)this.objects.get(n);
    }

    public Grid getGrid() {
        return this.grid;
    }

    public int[] getAxesScales() {
        return this.base.getAxesScales();
    }

    public void setAxesLabels(String[] stringArray) {
        this.grid.setLegend(stringArray);
        this.repaint();
    }

    public void setAxeLabel(int n, String string) {
        this.grid.setLegend(n, string);
        this.repaint();
    }

    public void setAxesScales(int[] nArray) {
        this.base.setAxesScales(nArray);
        this.setAutoBounds();
    }

    public void setAxeScale(int n, int n2) {
        this.base.setAxesScales(n, n2);
        this.setAutoBounds(n);
    }

    public void setFixedBounds(double[] dArray, double[] dArray2) {
        this.base.setFixedBounds(dArray, dArray2);
        this.updateBase();
        this.repaint();
    }

    public void setFixedBounds(int n, double d, double d2) {
        this.base.setFixedBounds(n, d, d2);
        this.updateBase();
        this.repaint();
    }

    public void setAutoBounds() {
        Object object;
        Object object2;
        if (this.plots.size() > 0) {
            object2 = this.getPlot(0);
            this.base.setnRoundBounds(DoubleArray.min(((Plot)object2).getDatas()), DoubleArray.max(((Plot)object2).getDatas()));
        } else {
            object2 = new double[this.base.getDimension()];
            object = new double[this.base.getDimension()];
            for (int i = 0; i < this.base.getDimension(); ++i) {
                if (this.base.getAxeScale(i) == 0) {
                    object2[i] = 0.0;
                    object[i] = 1.0;
                    continue;
                }
                if (this.base.getAxeScale(i) != 1) continue;
                object2[i] = 1.0;
                object[i] = 10.0;
            }
            this.base.setnRoundBounds((double[])object2, (double[])object);
        }
        for (int i = 1; i < this.plots.size(); ++i) {
            object = this.getPlot(i);
            this.base.includeInBounds(DoubleArray.min(((Plot)object).getDatas()));
            this.base.includeInBounds(DoubleArray.max(((Plot)object).getDatas()));
        }
        this.updateBase();
        this.repaint();
    }

    public void setAutoBounds(int n) {
        if (this.plots.size() > 0) {
            Plot plot = this.getPlot(0);
            this.base.setnRoundBounds(n, DoubleArray.min(plot.getDatas())[n], DoubleArray.max(plot.getDatas())[n]);
        } else {
            double d = 0.0;
            double d2 = 0.0;
            if (this.base.getAxeScale(n) == 0) {
                d = 0.0;
                d2 = 1.0;
            } else if (this.base.getAxeScale(n) == 1) {
                d = 1.0;
                d2 = 10.0;
            }
            this.base.setnRoundBounds(n, d, d2);
        }
        for (int i = 1; i < this.plots.size(); ++i) {
            Plot plot = this.getPlot(i);
            this.base.includeInBounds(n, DoubleArray.min(plot.getDatas())[n]);
            this.base.includeInBounds(n, DoubleArray.max(plot.getDatas())[n]);
        }
        this.updateBase();
        this.repaint();
    }

    public void updateBase() {
        this.base.setBaseCoords();
        this.grid.updateBase();
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof BaseScalesDependant)) continue;
            ((BaseScalesDependant)this.objects.get(i)).updateBase();
        }
    }

    public void addLabel(String string, double[] dArray, Color color) {
        this.addLabel(string, new RelativeCoord(dArray, this.base), color);
    }

    public void addLabel(String string, Coord coord, Color color) {
        this.addPlotable(new Label(string, coord, color));
    }

    public void addBaseLabel(String string, double[] dArray, Color color) {
        this.addPlotable(new BaseLabel(string, this.base, dArray, color));
    }

    public void addPlotable(Plotable plotable) {
        this.objects.add(plotable);
        this.repaint();
    }

    public void removePlotable(Plotable plotable) {
        this.objects.remove(plotable);
        this.repaint();
    }

    public void removePlotable(int n) {
        this.objects.remove(n);
        this.repaint();
    }

    public void addPlot(Plot plot) {
        this.plots.add(plot);
        this.setAutoBounds();
    }

    public void addPlot(double[][] dArray, String string, String string2) {
        this.addPlot(dArray, string, string2, colorList[this.plots.size() % colorList.length]);
    }

    public abstract void addPlot(double[][] var1, String var2, String var3, Color var4);

    public void removePlot(int n) {
        this.plots.remove(n);
        if (this.plots.size() == 0) {
            this.initBasenGrid();
        } else {
            this.setAutoBounds();
        }
    }

    public void removePlot(Plot plot) {
        this.plots.remove(plot);
        if (this.plots.size() == 0) {
            this.initBasenGrid();
        } else {
            this.setAutoBounds();
        }
    }

    public void removeAllPlots() {
        this.plots.removeAllElements();
        this.initBasenGrid();
    }

    public void toGraphicFile(File file) {
        this.toolBar.setVisible(false);
        this.repaint();
        Image image = this.createImage(this.getWidth(), this.getHeight());
        this.paint(image.getGraphics());
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, Color.WHITE, null);
        graphics2D.dispose();
        this.toolBar.setVisible(true);
        this.repaint();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "JPEG", file);
        }
        catch (IOException iOException) {
            JOptionPane.showConfirmDialog(null, "Save failed : " + iOException.getMessage(), "Error", -1, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void displaySetScalesFrame() {
        new SetScalesFrame(this);
    }

    public void displayDatasFrame() {
        new DatasFrame(this);
    }

    public void paint(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.addRenderingHints(AALIAS);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.grid.plot(graphics);
        for (n = 0; n < this.objects.size(); ++n) {
            this.getObject(n).plot(graphics);
        }
        for (n = 0; n < this.plots.size(); ++n) {
            this.getPlot(n).plot(graphics);
            this.getPlot(n).tryNote(this.mouseCurent, graphics);
        }
        switch (this.ActionMode) {
            case 0: {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(Math.min(this.mouseClick[0], this.mouseCurent[0]), Math.min(this.mouseClick[1], this.mouseCurent[1]), Math.abs(this.mouseCurent[0] - this.mouseClick[0]), Math.abs(this.mouseCurent[1] - this.mouseClick[1]));
            }
        }
        this.setBackground(Color.white);
        if (this.toolBar.isVisible()) {
            this.toolBar.update(graphics);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseCurent[0] = mouseEvent.getX();
        this.mouseCurent[1] = mouseEvent.getY();
        mouseEvent.consume();
        switch (this.ActionMode) {
            case 1: {
                int[] nArray = new int[]{this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]};
                this.base.translate(nArray);
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClick[0] = mouseEvent.getX();
        this.mouseClick[1] = mouseEvent.getY();
        mouseEvent.consume();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseCurent[0] = mouseEvent.getX();
        this.mouseCurent[1] = mouseEvent.getY();
        mouseEvent.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        switch (this.ActionMode) {
            case 0: {
                double[] dArray;
                int[] nArray;
                if (mouseEvent.getModifiers() == 16) {
                    nArray = new int[]{this.mouseCurent[0] - panelSize[0] / 4, this.mouseCurent[1] - panelSize[1] / 4};
                    dArray = new double[]{0.5, 0.5};
                } else {
                    nArray = new int[]{this.mouseCurent[0] - panelSize[0], this.mouseCurent[1] - panelSize[1]};
                    dArray = new double[]{2.0, 2.0};
                }
                this.base.dilate(nArray, dArray);
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseCurent[0] = mouseEvent.getX();
        this.mouseCurent[1] = mouseEvent.getY();
        mouseEvent.consume();
        switch (this.ActionMode) {
            case 0: {
                if (mouseEvent.getModifiers() != 16 || this.mouseCurent[0] == this.mouseClick[0] || this.mouseCurent[1] == this.mouseClick[1]) break;
                int[] nArray = new int[]{Math.min(this.mouseClick[0], this.mouseCurent[0]), Math.min(this.mouseClick[1], this.mouseCurent[1])};
                double[] dArray = new double[]{Math.abs((double)(this.mouseCurent[0] - this.mouseClick[0]) / (double)panelSize[0]), Math.abs((double)(this.mouseCurent[1] - this.mouseClick[1]) / (double)panelSize[1])};
                this.base.dilate(nArray, dArray);
            }
        }
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseCurent[0] = mouseEvent.getX();
        this.mouseCurent[1] = mouseEvent.getY();
        mouseEvent.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        panelSize = new int[]{(int)this.getSize().getWidth(), (int)this.getSize().getHeight()};
        this.base.setPanelSize(panelSize);
        this.base.updateScreenCoord();
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

