/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jmathplot.gui.PlotPanel;

public class PlotToolBar
extends JToolBar {
    protected ButtonGroup buttonGroup;
    protected JToggleButton buttonCenter;
    protected JToggleButton buttonZoom;
    protected JToggleButton buttonRotate;
    protected JToggleButton buttonViewCoords;
    protected JButton buttonSetScales;
    protected JButton buttonDatas;
    protected JButton buttonSaveGraphic;
    protected JButton buttonReset;
    private boolean denySaveSecurity;
    private JFileChooser fileChooser;
    private PlotPanel plotPanel;

    public PlotToolBar(PlotPanel plotPanel) {
        this.plotPanel = plotPanel;
        try {
            this.fileChooser = new JFileChooser();
        }
        catch (AccessControlException accessControlException) {
            this.denySaveSecurity = true;
        }
        this.buttonGroup = new ButtonGroup();
        this.buttonZoom = new JToggleButton("Zoom", new ImageIcon("icons\\zoom.png"));
        this.buttonZoom.setToolTipText("Zoom");
        this.buttonSaveGraphic = new JButton("Save", new ImageIcon("icons\\tofile.png"));
        this.buttonSaveGraphic.setToolTipText("Save graphics in a .PNG File");
        this.buttonReset = new JButton("Reset", new ImageIcon("icons\\back.png"));
        this.buttonReset.setToolTipText("Reset axes");
        this.buttonZoom.setSelected(true);
        this.buttonZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((PlotToolBar)PlotToolBar.this).plotPanel.ActionMode = 0;
            }
        });
        this.buttonSaveGraphic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotToolBar.this.chooseFile();
            }
        });
        this.buttonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotToolBar.this.plotPanel.resetBase();
            }
        });
        this.buttonGroup.add(this.buttonCenter);
        this.buttonGroup.add(this.buttonZoom);
        this.add((Component)this.buttonZoom, null);
        this.add((Component)this.buttonSaveGraphic, null);
        this.add((Component)this.buttonReset, null);
        if (!this.denySaveSecurity) {
            this.fileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlotToolBar.this.saveFile();
                }
            });
        } else {
            this.buttonSaveGraphic.setEnabled(false);
        }
    }

    public int getActionMode() {
        return this.plotPanel.ActionMode;
    }

    public PlotPanel getPlotPanel() {
        return this.plotPanel;
    }

    void chooseFile() {
        this.fileChooser.showSaveDialog(this);
    }

    void saveFile() {
        File file = this.fileChooser.getSelectedFile();
        this.plotPanel.toGraphicFile(file);
    }
}

