/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.components;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jmathplot.gui.PlotPanel;

public class SetScalesFrame
extends JFrame {
    private PlotPanel plotPanel;
    private JPanel panel;

    public SetScalesFrame(PlotPanel plotPanel) {
        super("scales settings");
        this.plotPanel = plotPanel;
        this.setPanel();
        this.setContentPane(this.panel);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void setPanel() {
        int n = this.plotPanel.getBase().getDimension();
        this.setSize(n * 300, 200);
        this.panel = new JPanel();
        GridLayout gridLayout = new GridLayout(1, n);
        this.panel.setLayout(gridLayout);
        for (int i = 0; i < n; ++i) {
            ScalePanel scalePanel = new ScalePanel(this.plotPanel, i);
            this.panel.add(scalePanel);
        }
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public class ScalePanel
    extends JPanel {
        private PlotPanel plotPanel;
        private int numAxe;
        private String title;
        private int scaleType;
        private double min;
        private double max;
        private JLabel title_label = new JLabel("Title");
        private JTextField title_field;
        private JLabel scale_label = new JLabel("Scale");
        private ButtonGroup scale_group = new ButtonGroup();
        private JRadioButton linear_check = new JRadioButton("Linear");
        private JRadioButton log_check = new JRadioButton("Logarithmic");
        private JLabel bounds_label = new JLabel("Bounds");
        private JLabel min_label = new JLabel("Min");
        private JLabel max_label = new JLabel("Max");
        private JTextField min_field;
        private JTextField max_field;
        private JButton bounds_auto = new JButton("Automatic");

        public ScalePanel(PlotPanel plotPanel, int n) {
            this.numAxe = n;
            this.plotPanel = plotPanel;
            this.title = this.plotPanel.getGrid().getLegend(this.numAxe);
            this.scaleType = this.plotPanel.getAxesScales()[this.numAxe];
            this.min = this.plotPanel.getBase().getMinBounds()[this.numAxe];
            this.max = this.plotPanel.getBase().getMaxBounds()[this.numAxe];
            this.setComponents();
            this.addComponents();
            this.setListeners();
        }

        private void setComponents() {
            this.title_field = new JTextField(this.title);
            this.scale_group.add(this.linear_check);
            this.scale_group.add(this.log_check);
            this.log_check.setSelected(this.scaleType == 1);
            this.linear_check.setSelected(this.scaleType == 0);
            this.min_field = new JTextField("" + this.min);
            this.max_field = new JTextField("" + this.max);
        }

        private void addComponents() {
            this.setSize(300, 200);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 40, 20);
            gridBagConstraints.fill = 10;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.title_label, gridBagConstraints);
            this.add(this.title_label);
            this.buildConstraints(gridBagConstraints, 1, 0, 2, 1, 60, 20);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.title_field, gridBagConstraints);
            this.add(this.title_field);
            this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 40, 20);
            gridBagConstraints.fill = 10;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.scale_label, gridBagConstraints);
            this.add(this.scale_label);
            this.buildConstraints(gridBagConstraints, 1, 1, 2, 1, 60, 20);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.linear_check, gridBagConstraints);
            this.add(this.linear_check);
            this.buildConstraints(gridBagConstraints, 1, 2, 2, 1, 60, 20);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.log_check, gridBagConstraints);
            this.add(this.log_check);
            this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 40, 20);
            gridBagConstraints.fill = 10;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.bounds_label, gridBagConstraints);
            this.add(this.bounds_label);
            this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 20, 20);
            gridBagConstraints.fill = 10;
            gridBagConstraints.fill = 10;
            gridBagLayout.setConstraints(this.min_label, gridBagConstraints);
            this.add(this.min_label);
            this.buildConstraints(gridBagConstraints, 2, 3, 1, 1, 50, 20);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.min_field, gridBagConstraints);
            this.add(this.min_field);
            this.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 20, 20);
            gridBagConstraints.fill = 10;
            gridBagConstraints.fill = 10;
            gridBagLayout.setConstraints(this.max_label, gridBagConstraints);
            this.add(this.max_label);
            this.buildConstraints(gridBagConstraints, 2, 4, 1, 1, 50, 20);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.max_field, gridBagConstraints);
            this.add(this.max_field);
            this.buildConstraints(gridBagConstraints, 1, 5, 2, 1, 60, 20);
            gridBagConstraints.fill = 10;
            gridBagLayout.setConstraints(this.bounds_auto, gridBagConstraints);
            this.add(this.bounds_auto);
        }

        private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            gridBagConstraints.weightx = n5;
            gridBagConstraints.weighty = n6;
        }

        private void setListeners() {
            this.title_field.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                    ScalePanel.this.setTitle();
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.log_check.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalePanel.this.setScale();
                }
            });
            this.linear_check.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalePanel.this.setScale();
                }
            });
            this.min_field.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                    ScalePanel.this.setBounds();
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.max_field.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                    ScalePanel.this.setBounds();
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.bounds_auto.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalePanel.this.setBoundsAuto();
                }
            });
        }

        public void toCommandLine(String string) {
            System.out.println(string + " : ");
            System.out.println("title = " + this.title);
            System.out.println("scaleType = " + this.scaleType);
            System.out.println("min = " + this.min);
            System.out.println("max = " + this.max);
        }

        private void setTitle() {
            this.plotPanel.setAxeLabel(this.numAxe, this.title_field.getText());
        }

        private void setBounds() {
            try {
                this.plotPanel.setFixedBounds(this.numAxe, Double.parseDouble(this.min_field.getText()), Double.parseDouble(this.max_field.getText()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showConfirmDialog(null, illegalArgumentException.getMessage(), "Error", -1, 0);
                this.updateBoundsFields();
            }
        }

        private void setScale() {
            try {
                this.plotPanel.setAxeScale(this.numAxe, this.log_check.isSelected() ? 1 : 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showConfirmDialog(null, illegalArgumentException.getMessage(), "Error", -1, 0);
                this.updateBoundsFields();
            }
        }

        private void setBoundsAuto() {
            this.plotPanel.setAutoBounds(this.numAxe);
            this.updateBoundsFields();
        }

        private void updateBoundsFields() {
            this.min = this.plotPanel.getBase().getMinBounds()[this.numAxe];
            this.max = this.plotPanel.getBase().getMaxBounds()[this.numAxe];
            this.min_field.setText("" + this.min);
            this.max_field.setText("" + this.max);
        }
    }
}

