/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plotObjects;

import java.awt.Color;
import org.jmathplot.gui.FrameView;
import org.jmathplot.gui.Plot3DPanel;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.BaseScalesDependant;
import org.jmathplot.gui.plotObjects.Coord;
import org.jmathplot.gui.plotObjects.Label;
import org.jmathplot.gui.plotObjects.RelativeCoord;
import org.jmathplot.util.DoubleArray;

public class BaseLabel
extends Label
implements BaseScalesDependant {
    private double[] positionOnAxes;
    private Base base;

    public BaseLabel(String string, Base base, double[] dArray, Color color) {
        super(string, BaseLabel.buildRelativeCoord(dArray, base), color);
        this.positionOnAxes = dArray;
        this.base = base;
    }

    public static RelativeCoord buildRelativeCoord(double[] dArray, Base base) {
        Coord coord = base.getCoords()[0];
        int n = base.dimension;
        double[] dArray2 = new double[base.dimension];
        for (int i = 0; i < n; ++i) {
            if (base.getAxeScale(i) == 0) {
                dArray2[i] = coord.getPlotCoordCopy()[i] + (base.getCoords()[i + 1].getPlotCoordCopy()[i] - coord.getPlotCoordCopy()[i]) * dArray[i];
                continue;
            }
            if (base.getAxeScale(i) != 1) continue;
            int n2 = (int)Math.rint(Math.log(base.getMaxBounds()[i] / base.getMinBounds()[i]) / Math.log(10.0));
            dArray2[i] = coord.getPlotCoordCopy()[i] * Math.pow(10.0, (double)n2 * dArray[i]);
        }
        return new RelativeCoord(dArray2, base);
    }

    public void updateBase() {
        this.coord = BaseLabel.buildRelativeCoord(this.positionOnAxes, this.base);
    }

    public static void main(String[] stringArray) {
        Plot3DPanel plot3DPanel = new Plot3DPanel(new double[]{0.0, 0.0, 0.0}, new double[]{10.0, 10.0, 10.0}, new int[3], new String[]{"x", "y", "z"});
        new FrameView(plot3DPanel);
        plot3DPanel.addPlot(DoubleArray.random(10, 3), "plot", "SCATTER");
        plot3DPanel.addPlotable(new BaseLabel("label", plot3DPanel.getBase(), new double[]{-0.1, 0.5, 0.5}, Color.RED));
    }
}

