/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plotObjects;

import java.awt.Graphics;
import org.jmathplot.gui.plotObjects.Axe;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.BaseScalesDependant;
import org.jmathplot.gui.plotObjects.Plotable;

public class Grid
implements Plotable,
BaseScalesDependant {
    public static double borderCoeff = 0.1;
    protected Base base;
    protected Axe[] axes;

    public Grid(Base base, String[] stringArray) {
        this.base = base;
        if (stringArray.length != this.base.dimension) {
            throw new IllegalArgumentException("String array of axes names must have " + this.base.dimension + " elements.");
        }
        this.axes = new Axe[this.base.dimension];
        for (int i = 0; i < this.base.dimension; ++i) {
            this.axes[i] = new Axe(this.base, stringArray[i], i);
        }
        this.updateBase();
    }

    public void setLegend(String[] stringArray) {
        if (stringArray.length != this.base.dimension) {
            throw new IllegalArgumentException("String array of axes names must have " + this.base.dimension + " elements.");
        }
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i].setName(stringArray[i]);
        }
        this.updateBase();
    }

    public void setLegend(int n, String string) {
        this.axes[n].setName(string);
        this.updateBase();
    }

    public String[] getLegend() {
        String[] stringArray = new String[this.axes.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.axes[i].getName();
        }
        return stringArray;
    }

    public String getLegend(int n) {
        return this.axes[n].getName();
    }

    public void setBase(Base base) {
        this.base = base;
        this.updateBase();
    }

    public void plot(Graphics graphics) {
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i].plot(graphics);
        }
    }

    public Axe getAxe(int n) {
        return this.axes[n];
    }

    public void updateBase() {
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i].updateBase();
        }
    }
}

