/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plotObjects;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.jmathplot.gui.plotObjects.Coord;
import org.jmathplot.gui.plotObjects.Plotable;

public class Label
implements Plotable {
    protected Coord coord;
    protected String label;
    protected Color color;
    protected double cornerN = 0.5;
    protected double cornerE = 0.5;

    public Label(String string, Coord coord, Color color) {
        this.label = string;
        this.coord = coord;
        this.color = color;
    }

    public Label(String string, Coord coord) {
        this(string, coord, Color.black);
    }

    public Label(Coord coord) {
        this(Label.coordToString(coord), coord, Color.black);
    }

    public void setCorner(double d, double d2) {
        this.cornerN = d;
        this.cornerE = d2;
    }

    public void setOffset(double[] dArray) {
        double[] dArray2 = this.coord.getPlotCoordCopy();
        for (int i = 0; i < dArray2.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
        }
        this.coord.setPlotCoord(dArray2);
    }

    public void plot(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics2D.setColor(this.color);
        Font font = graphics2D.getFont();
        int n = this.coord.getScreenCoordCopy()[0];
        int n2 = this.coord.getScreenCoordCopy()[1];
        float f = font.getSize2D();
        graphics2D.drawString(this.label, n -= (int)(font.getStringBounds(this.label, fontRenderContext).getWidth() * this.cornerE), n2 += (int)((double)f * this.cornerN));
    }

    public static double approx(double d, int n) {
        if (n < 0) {
            return Math.rint(d / Math.pow(10.0, -n)) * Math.pow(10.0, -n);
        }
        return Math.rint(d * Math.pow(10.0, n)) / Math.pow(10.0, n);
    }

    public static String coordToString(Coord coord) {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < coord.getPlotCoordCopy().length; ++i) {
            stringBuffer.append(Label.approx(coord.getPlotCoordCopy()[i], 2)).append(",");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

