/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plotObjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.Coord;
import org.jmathplot.gui.plotObjects.Noteable;

public class RelativeCoord
extends Coord
implements Noteable {
    protected Base base;
    protected boolean isNoteable = true;

    public RelativeCoord(double[] dArray, Base base) {
        this.base = base;
        this.plotCoord = dArray;
        this.updateScreenCoord();
    }

    public static RelativeCoord barycenter(RelativeCoord relativeCoord, double d, Coord coord, double d2) {
        double[] dArray = new double[relativeCoord.getPlotCoordCopy().length];
        for (int i = 0; i < relativeCoord.getPlotCoordCopy().length; ++i) {
            dArray[i] = (relativeCoord.getPlotCoordCopy()[i] * d + coord.getPlotCoordCopy()[i] * d2) / (d + d2);
        }
        return new RelativeCoord(dArray, relativeCoord.getBase());
    }

    public int[] getScreenCoordCopy() {
        this.updateScreenCoord();
        return super.getScreenCoordCopy();
    }

    public Base getBase() {
        return this.base;
    }

    public void setBase(Base base) {
        this.base = base;
    }

    public void setPlotCoord(double[] dArray) {
        this.plotCoord = dArray;
        this.updateScreenCoord();
    }

    public void setPlotCoord(double d, int n) {
        this.plotCoord[n] = d;
        this.updateScreenCoord();
    }

    public RelativeCoord projection(int n) {
        double[] dArray = this.getPlotCoordCopy();
        dArray[n] = this.base.getCoords()[0].getPlotCoordCopy()[n];
        return new RelativeCoord(dArray, this.getBase());
    }

    public RelativeCoord addVector(double[] dArray) {
        double[] dArray2 = this.getPlotCoordCopy();
        for (int i = 0; i < dArray2.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
        }
        return new RelativeCoord(dArray2, this.base);
    }

    public void addVectorEquals(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            this.plotCoord[n] = this.plotCoord[n] + dArray[i];
        }
        this.updateScreenCoord();
    }

    public void addVectorEquals(double d, int n) {
        int n2 = n;
        this.plotCoord[n2] = this.plotCoord[n2] + d;
        this.updateScreenCoord();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < this.plotCoord.length - 1; ++i) {
            String string = new String("" + RelativeCoord.approx(this.getPlotCoordCopy()[i], RelativeCoord.getPower(this.base.getPrecisionUnit()[i])));
            stringBuffer.append(string).append(",");
        }
        String string = new String("" + RelativeCoord.approx(this.getPlotCoordCopy()[this.plotCoord.length - 1], RelativeCoord.getPower(this.base.getPrecisionUnit()[this.plotCoord.length - 1])));
        stringBuffer.append(string).append(")");
        return stringBuffer.toString();
    }

    public void setNotable(boolean bl) {
        this.isNoteable = bl;
    }

    public boolean tryNote(int[] nArray) {
        return nArray[0] > this.screenCoord[0] - 5 && nArray[0] < this.screenCoord[0] + 5 && nArray[1] > this.screenCoord[1] - 5 && nArray[1] < this.screenCoord[1] + 5;
    }

    public boolean tryNote(int[] nArray, Graphics graphics) {
        if (this.isNoteable && this.tryNote(nArray)) {
            this.note(graphics);
            return true;
        }
        return false;
    }

    public void note(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.drawString(this.toString(), this.screenCoord[0], this.screenCoord[1]);
        for (int i = 0; i < this.base.getCoords().length - 1; ++i) {
            RelativeCoord relativeCoord = this.projection(i);
            graphics2D.drawLine(this.getScreenCoordCopy()[0], this.getScreenCoordCopy()[1], ((Coord)relativeCoord).getScreenCoordCopy()[0], ((Coord)relativeCoord).getScreenCoordCopy()[1]);
        }
    }

    private void updateScreenCoord() {
        this.screenCoord = this.base.screenProjection(this.plotCoord);
    }

    private static int getPower(double d) {
        return -((int)(Math.log(d / 10000.0) / Math.log(10.0)));
    }

    public static double approx(double d, int n) {
        if (n < 0) {
            return Math.rint(d / Math.pow(10.0, -n)) * Math.pow(10.0, -n);
        }
        return Math.rint(d * Math.pow(10.0, n)) / Math.pow(10.0, n);
    }

    public void checkSameRelativesBases(RelativeCoord relativeCoord) {
        if (this.base != relativeCoord.base) {
            throw new IllegalArgumentException("Using two Coordinates, their bases must be the same");
        }
    }
}

