/*
 * Decompiled with CFR 0.152.
 */
package org.jmathplot.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmathplot.gui.plotObjects.Base;
import org.jmathplot.gui.plotObjects.Coord;
import org.jmathplot.gui.plotObjects.Noteable;
import org.jmathplot.gui.plotObjects.Plotable;
import org.jmathplot.gui.plotObjects.RelativeCoord;

public abstract class Plot
implements Plotable,
Noteable {
    public int dot_radius = 2;
    protected String name;
    protected Base base;
    protected double[][] datas;
    protected Color color;
    protected boolean noteEachCoord = false;

    public Plot(double[][] dArray, Color color, String string, Base base) {
        this.name = string;
        this.datas = dArray;
        this.base = base;
        this.color = color;
        this.base = base;
    }

    public void setNoteEachCoord(boolean bl) {
        this.noteEachCoord = bl;
    }

    public void setDatas(double[][] dArray) {
        this.datas = dArray;
    }

    public double[][] getDatas() {
        return this.datas;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public RelativeCoord[] getCoords() {
        RelativeCoord[] relativeCoordArray = new RelativeCoord[this.datas.length];
        for (int i = 0; i < this.datas.length; ++i) {
            relativeCoordArray[i] = new RelativeCoord(this.datas[i], this.base);
        }
        return relativeCoordArray;
    }

    public boolean tryNote(int[] nArray) {
        RelativeCoord[] relativeCoordArray = this.getCoords();
        for (int i = 0; i < relativeCoordArray.length; ++i) {
            if (!relativeCoordArray[i].tryNote(nArray)) continue;
            return true;
        }
        return false;
    }

    public boolean tryNote(int[] nArray, Graphics graphics) {
        RelativeCoord[] relativeCoordArray = this.getCoords();
        if (this.noteEachCoord) {
            for (int i = 0; i < relativeCoordArray.length; ++i) {
                if (!relativeCoordArray[i].tryNote(nArray, graphics)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < relativeCoordArray.length; ++i) {
            if (!relativeCoordArray[i].tryNote(nArray)) continue;
            this.note(graphics);
            graphics.setColor(Color.black);
            graphics.drawString(this.name, nArray[0], nArray[1]);
            return true;
        }
        return false;
    }

    public abstract void note(Graphics var1);

    public abstract void plot(Graphics var1, Color var2);

    public void plot(Graphics graphics) {
        this.plot(graphics, this.color);
    }

    protected void drawLine(double[] dArray, double[] dArray2, Graphics2D graphics2D) {
        RelativeCoord relativeCoord = new RelativeCoord(dArray, this.base);
        RelativeCoord relativeCoord2 = new RelativeCoord(dArray2, this.base);
        this.drawLine(relativeCoord, relativeCoord2, graphics2D);
    }

    protected void drawLargeLine(double[] dArray, double[] dArray2, Graphics2D graphics2D) {
        RelativeCoord relativeCoord = new RelativeCoord(dArray, this.base);
        RelativeCoord relativeCoord2 = new RelativeCoord(dArray2, this.base);
        this.drawLargeLine(relativeCoord, relativeCoord2, graphics2D);
    }

    protected void drawDot(double[] dArray, Graphics2D graphics2D) {
        RelativeCoord relativeCoord = new RelativeCoord(dArray, this.base);
        this.drawDot(relativeCoord, this.dot_radius, graphics2D);
    }

    protected void drawDot(double[] dArray, int n, Graphics2D graphics2D) {
        RelativeCoord relativeCoord = new RelativeCoord(dArray, this.base);
        this.drawDot(relativeCoord, n, graphics2D);
    }

    protected void drawPloygon(double[][] dArray, Graphics2D graphics2D) {
        Coord[] coordArray = new RelativeCoord[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            coordArray[i] = new RelativeCoord(dArray[i], this.base);
        }
        this.drawPloygon(coordArray, graphics2D);
    }

    protected void fillPloygon(double[][] dArray, Graphics2D graphics2D) {
        Coord[] coordArray = new RelativeCoord[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            coordArray[i] = new RelativeCoord(dArray[i], this.base);
        }
        this.fillPloygon(coordArray, graphics2D);
    }

    protected void drawLargeLine(Coord coord, Coord coord2, Graphics2D graphics2D) {
        graphics2D.drawLine(coord.getScreenCoordCopy()[0] + 1, coord.getScreenCoordCopy()[1], coord2.getScreenCoordCopy()[0] + 1, coord2.getScreenCoordCopy()[1]);
        graphics2D.drawLine(coord.getScreenCoordCopy()[0] - 1, coord.getScreenCoordCopy()[1], coord2.getScreenCoordCopy()[0] - 1, coord2.getScreenCoordCopy()[1]);
        graphics2D.drawLine(coord.getScreenCoordCopy()[0], coord.getScreenCoordCopy()[1] + 1, coord2.getScreenCoordCopy()[0], coord2.getScreenCoordCopy()[1] + 1);
        graphics2D.drawLine(coord.getScreenCoordCopy()[0], coord.getScreenCoordCopy()[1] - 1, coord2.getScreenCoordCopy()[0], coord2.getScreenCoordCopy()[1] - 1);
    }

    protected void drawLine(Coord coord, Coord coord2, Graphics2D graphics2D) {
        graphics2D.drawLine(coord.getScreenCoordCopy()[0], coord.getScreenCoordCopy()[1], coord2.getScreenCoordCopy()[0], coord2.getScreenCoordCopy()[1]);
    }

    protected void drawDot(Coord coord, int n, Graphics2D graphics2D) {
        graphics2D.fillOval(coord.getScreenCoordCopy()[0] - n, coord.getScreenCoordCopy()[1] - n, 2 * n, 2 * n);
    }

    protected void drawPloygon(Coord[] coordArray, Graphics2D graphics2D) {
        int[] nArray = new int[coordArray.length];
        for (int i = 0; i < coordArray.length; ++i) {
            nArray[i] = coordArray[i].getScreenCoordCopy()[0];
        }
        int[] nArray2 = new int[coordArray.length];
        for (int i = 0; i < coordArray.length; ++i) {
            nArray2[i] = coordArray[i].getScreenCoordCopy()[1];
        }
        graphics2D.drawPolygon(nArray, nArray2, nArray.length);
    }

    protected void fillPloygon(Coord[] coordArray, Graphics2D graphics2D) {
        int[] nArray = new int[coordArray.length];
        for (int i = 0; i < coordArray.length; ++i) {
            nArray[i] = coordArray[i].getScreenCoordCopy()[0];
        }
        int[] nArray2 = new int[coordArray.length];
        for (int i = 0; i < coordArray.length; ++i) {
            nArray2[i] = coordArray[i].getScreenCoordCopy()[1];
        }
        graphics2D.fillPolygon(nArray, nArray2, nArray.length);
    }
}

