/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.csplugins.ExpressionCorrelation;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import cytoscape.task.TaskMonitor;
import giny.model.Edge;
import giny.model.Node;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.mskcc.csplugins.ExpressionCorrelation.CorrelateCutoffStorage;

public class CorrelateSimilarityNetwork {
    private String rowNetName = "Gene Network";
    private int rowCurrentStep = 0;
    private int rowTotalSteps = 0;
    private boolean rowDone = false;
    private double rowPosCutoff = 0.95;
    private double rowNegCutoff = -0.95;
    private int[] rowHistogram;
    private String[] rowHistogramLabels;
    private boolean rowUsePos = true;
    private boolean rowUseNeg = true;
    private int numberOfRows = 0;
    private String colNetName = "Cond Network";
    private int colCurrentStep = 0;
    private int colTotalSteps = 0;
    private boolean colDone = false;
    private double colPosCutoff = 0.95;
    private double colNegCutoff = -0.95;
    private int[] colHistogram;
    private String[] colHistogramLabels;
    private boolean colUsePos = true;
    private boolean colUseNeg = true;
    private int numberOfCols = 0;
    private boolean cancel = false;
    private int maxDigits = 5;
    private TaskMonitor taskMonitor = null;

    public CorrelateSimilarityNetwork() {
    }

    public CorrelateSimilarityNetwork(String string) {
        this.rowNetName = string + " (genes)";
        this.colNetName = string + " (conditions)";
    }

    public String getRowNetName() {
        return this.rowNetName;
    }

    public String getColNetName() {
        return this.colNetName;
    }

    public void setRowNetName(String string) {
        this.rowNetName = string;
    }

    public void setColNetName(String string) {
        this.rowNetName = string;
    }

    public void nameNetwork() {
        ExpressionData expressionData = Cytoscape.getExpressionData();
        String string = expressionData.getFileName();
        int n = string.lastIndexOf(47);
        String string2 = string.substring(n + 1);
        this.rowNetName = string2 + " (genes)";
        this.colNetName = string2 + " (conditions)";
    }

    public int getMaxDigits() {
        return this.maxDigits;
    }

    public void setMaxDigits(int n) {
        this.maxDigits = n;
    }

    public double format(double d) {
        int n = (int)(d * 1000.0);
        double d2 = (double)n / 1000.0;
        return d2;
    }

    public CyNetwork calcRows() {
        this.rowDone = false;
        if (this.rowNetName.equals("Gene Network")) {
            this.nameNetwork();
        }
        return this.calcRows(this.rowNetName + ": " + this.rowNegCutoff + " & " + this.rowPosCutoff, this.rowNegCutoff, this.rowPosCutoff);
    }

    public CyNetwork calcRows(String string) {
        this.rowDone = false;
        return this.calcRows(string, this.rowNegCutoff, this.rowPosCutoff);
    }

    public CyNetwork calcRows(String string, double d, double d2) {
        this.rowDone = false;
        ExpressionData expressionData = Cytoscape.getExpressionData();
        return this.calcRows(string, expressionData, d, d2);
    }

    public CyNetwork calcRows(String string, ExpressionData expressionData, double d, double d2) {
        this.rowDone = false;
        String[] stringArray = expressionData.getGeneNames();
        DoubleMatrix2D doubleMatrix2D = this.getExpressionMatrix(expressionData);
        return this.calcRows(string, doubleMatrix2D, d, d2, stringArray);
    }

    public CyNetwork calcRows(String string, DoubleMatrix2D doubleMatrix2D, double d, double d2, String[] stringArray) {
        this.rowDone = false;
        return this.calc(true, string, doubleMatrix2D, d, d2, stringArray);
    }

    public CyNetwork calcRows(int n) {
        this.rowDone = false;
        ExpressionData expressionData = Cytoscape.getExpressionData();
        String[] stringArray = expressionData.getGeneNames();
        DoubleMatrix2D doubleMatrix2D = this.getExpressionMatrix(expressionData);
        return this.calc(true, doubleMatrix2D, this.rowNegCutoff, this.rowPosCutoff, stringArray, n);
    }

    public CyNetwork calcRows(DoubleMatrix2D doubleMatrix2D, double d, double d2, String[] stringArray, int n) {
        this.rowDone = false;
        return this.calc(true, doubleMatrix2D, d, d2, stringArray, n);
    }

    public CyNetwork calcCols() {
        this.colDone = false;
        if (this.colNetName.equals("Cond Network")) {
            this.nameNetwork();
        }
        return this.calcCols(this.colNetName + ": " + this.colNegCutoff + " & " + this.colPosCutoff, this.colNegCutoff, this.colPosCutoff);
    }

    public CyNetwork calcCols(String string) {
        this.colDone = false;
        return this.calcCols(string, this.colNegCutoff, this.colPosCutoff);
    }

    public CyNetwork calcCols(String string, double d, double d2) {
        this.colDone = false;
        ExpressionData expressionData = Cytoscape.getExpressionData();
        return this.calcCols(string, expressionData, d, d2);
    }

    public CyNetwork calcCols(String string, ExpressionData expressionData, double d, double d2) {
        this.colDone = false;
        String[] stringArray = expressionData.getConditionNames();
        DoubleMatrix2D doubleMatrix2D = this.getExpressionMatrix(expressionData);
        return this.calc(false, string, doubleMatrix2D, d, d2, stringArray);
    }

    public CyNetwork calcCols(String string, DoubleMatrix2D doubleMatrix2D, double d, double d2, String[] stringArray) {
        this.colDone = false;
        return this.calc(false, string, doubleMatrix2D, d, d2, stringArray);
    }

    public CyNetwork calcCols(int n) {
        this.rowDone = false;
        ExpressionData expressionData = Cytoscape.getExpressionData();
        String[] stringArray = expressionData.getConditionNames();
        DoubleMatrix2D doubleMatrix2D = this.getExpressionMatrix(expressionData);
        return this.calc(false, doubleMatrix2D, this.colNegCutoff, this.colPosCutoff, stringArray, n);
    }

    public CyNetwork calcCols(DoubleMatrix2D doubleMatrix2D, double d, double d2, String[] stringArray, int n) {
        this.colDone = false;
        return this.calc(false, doubleMatrix2D, d, d2, stringArray, n);
    }

    public CyNetwork calc(boolean bl, String string, DoubleMatrix2D doubleMatrix2D, double d, double d2, String[] stringArray) {
        CyNetwork cyNetwork = Cytoscape.createNetwork((int[])new int[0], (int[])new int[0], (String)string, null, (boolean)false);
        initiationData initiationData2 = new initiationData(bl, doubleMatrix2D, true);
        double[] dArray = this.cutoffCheck(bl, d, d2);
        d = dArray[0];
        d2 = dArray[1];
        int n = initiationData2.columns % 10;
        if (initiationData2.columns <= 10) {
            n = 0;
        }
        if (this.taskMonitor != null) {
            String string2 = "condition";
            if (bl) {
                string2 = "gene";
            }
            this.taskMonitor.setPercentCompleted(-1);
            this.taskMonitor.setStatus("Constructing " + string2 + " correlation network...");
        }
        for (int i = 0; i < initiationData2.columns; ++i) {
            this.core(cyNetwork, initiationData2, i, d, d2, stringArray, false);
            if (this.cancel) {
                return cyNetwork;
            }
            if (i * 10 % (initiationData2.columns - n) != 0 || this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted((int)((double)(i * 100) / (double)initiationData2.columns));
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus("Finished constructing network");
        }
        if (bl) {
            this.rowDone = true;
        } else {
            this.colDone = true;
        }
        this.cancel = false;
        if (cyNetwork.getNodeCount() < Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold"))) {
            Cytoscape.createNetworkView((CyNetwork)cyNetwork);
        }
        return cyNetwork;
    }

    public CyNetwork calc(boolean bl, DoubleMatrix2D doubleMatrix2D, double d, double d2, String[] stringArray, int n) {
        CyNetwork cyNetwork = Cytoscape.createNetwork((int[])new int[0], (int[])new int[0], (String)stringArray[n], null, (boolean)false);
        initiationData initiationData2 = new initiationData(bl, doubleMatrix2D, false);
        double[] dArray = this.cutoffCheck(bl, d, d2);
        d = dArray[0];
        d2 = dArray[1];
        int n2 = n;
        this.core(cyNetwork, initiationData2, n2, d, d2, stringArray, true);
        if (bl) {
            this.rowDone = true;
        } else {
            this.colDone = true;
        }
        this.cancel = false;
        if (cyNetwork.getNodeCount() < Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold"))) {
            Cytoscape.createNetworkView((CyNetwork)cyNetwork);
        }
        return cyNetwork;
    }

    public void createEdge(CyNetwork cyNetwork, int n, int n2, String[] stringArray, double d) {
        CyNode cyNode = Cytoscape.getCyNode((String)stringArray[n]);
        if (cyNode == null) {
            cyNode = Cytoscape.getCyNode((String)stringArray[n], (boolean)true);
            cyNetwork.addNode((Node)cyNode);
        } else if (cyNetwork.getIndex((Node)cyNode) == 0) {
            cyNetwork.addNode((Node)cyNode);
        }
        CyNode cyNode2 = Cytoscape.getCyNode((String)stringArray[n2]);
        if (cyNode2 == null) {
            cyNode2 = Cytoscape.getCyNode((String)stringArray[n2], (boolean)true);
            cyNetwork.addNode((Node)cyNode2);
        } else if (cyNetwork.getIndex((Node)cyNode2) == 0) {
            cyNetwork.addNode((Node)cyNode2);
        }
        CyEdge cyEdge = d > 0.0 ? Cytoscape.getCyEdge((String)stringArray[n], (String)(stringArray[n] + "_interaction_" + stringArray[n2]), (String)stringArray[n2], (String)"pos_interaction") : Cytoscape.getCyEdge((String)stringArray[n], (String)(stringArray[n] + "_interaction_" + stringArray[n2]), (String)stringArray[n2], (String)"neg_interaction");
        Double d2 = new Double(d);
        CyAttributes cyAttributes = Cytoscape.getEdgeAttributes();
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "Strength", d2);
        cyNetwork.addEdge((Edge)cyEdge);
    }

    public double[] cutoffCheck(boolean bl, double d, double d2) {
        Object object;
        if (Math.abs(d) > 1.0 | Math.abs(d2) > 1.0) {
            if (bl) {
                d = this.rowNegCutoff;
                d2 = this.rowPosCutoff;
            } else {
                d = this.colNegCutoff;
                d2 = this.colPosCutoff;
            }
            object = "Unrealistic lowCutoff or highCutoff values. \nUsing default values: lowCutoff=" + d + ", highCutoff=" + d2;
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), object);
        }
        if (d > 0.0) {
            d = -d;
        }
        object = new double[]{d, d2};
        return object;
    }

    public void core(CyNetwork cyNetwork, initiationData initiationData2, int n, double d, double d2, String[] stringArray, boolean bl) {
        int n2 = n;
        if (bl) {
            n2 = initiationData2.columns;
        }
        for (int i = 0; i < n2; ++i) {
            if (initiationData2.isRowNetwork) {
                ++this.rowCurrentStep;
            } else {
                ++this.colCurrentStep;
            }
            double d3 = this.calcPearsonCorr(initiationData2, n, i);
            if (d3 < -1.0) continue;
            if (d3 > d2 && n != i && initiationData2.usePos) {
                this.createEdge(cyNetwork, n, i, stringArray, d3);
            }
            if (d3 < d && initiationData2.useNeg) {
                this.createEdge(cyNetwork, n, i, stringArray, d3);
            }
            if (!this.cancel) continue;
            return;
        }
    }

    public int calcTimeFull(DoubleMatrix2D doubleMatrix2D) {
        double d = doubleMatrix2D.columns();
        double d2 = d * d / 2.0 + 5.0 * d / 2.0;
        return (int)d2;
    }

    public int calcTimeSingle(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.columns();
        int n2 = 3 * n;
        return n2;
    }

    public int getRowTotalSteps() {
        if (this.rowTotalSteps == 0) {
            Algebra algebra = new Algebra();
            DoubleMatrix2D doubleMatrix2D = algebra.transpose(this.getExpressionMatrix());
            this.rowTotalSteps = this.calcTimeFull(doubleMatrix2D);
        }
        return this.rowTotalSteps;
    }

    public int getColTotalSteps() {
        if (this.colTotalSteps == 0) {
            this.colTotalSteps = this.calcTimeFull(this.getExpressionMatrix());
        }
        return this.colTotalSteps;
    }

    public int getRowCurrentStep() {
        return this.rowCurrentStep;
    }

    public int getColCurrentStep() {
        return this.colCurrentStep;
    }

    public boolean rowIsDone() {
        return this.rowDone;
    }

    public boolean colIsDone() {
        return this.colDone;
    }

    public void rowHistogram() {
        this.rowHistogram(this.getExpressionMatrix());
    }

    public void rowHistogram(DoubleMatrix2D doubleMatrix2D) {
        this.histogram(true, doubleMatrix2D);
    }

    public void colHistogram() {
        this.colHistogram(this.getExpressionMatrix());
    }

    public void colHistogram(DoubleMatrix2D doubleMatrix2D) {
        this.histogram(false, doubleMatrix2D);
    }

    private double calcPearsonCorr(initiationData initiationData2, int n, int n2) {
        double d = initiationData2.cols[n].zDotProduct(initiationData2.cols[n2]);
        double d2 = (d - initiationData2.sums[n] * initiationData2.sums[n2] / (double)initiationData2.rows) / (double)initiationData2.rows;
        double d3 = d2 / (initiationData2.stdDev.get(n) * initiationData2.stdDev.get(n2));
        if (initiationData2.stdDev.get(n) == 0.0 || initiationData2.stdDev.get(n2) == 0.0) {
            return -2.0;
        }
        return d3;
    }

    public void histogram(boolean bl, DoubleMatrix2D doubleMatrix2D) {
        int n;
        initiationData initiationData2 = new initiationData(bl, doubleMatrix2D, true);
        int n2 = 2000;
        int[] nArray = new int[n2];
        int n3 = initiationData2.columns % 10;
        if (initiationData2.columns <= 10) {
            n3 = 0;
        }
        if (this.taskMonitor != null) {
            String string = "condition";
            if (bl) {
                string = "gene";
            }
            this.taskMonitor.setPercentCompleted(-1);
            this.taskMonitor.setStatus("Constructing  " + string + " correlation histogram...");
        }
        for (int i = 0; i < initiationData2.columns; ++i) {
            for (n = 0; n < i; ++n) {
                if (bl) {
                    ++this.rowCurrentStep;
                } else {
                    ++this.colCurrentStep;
                }
                double d = this.calcPearsonCorr(initiationData2, i, n);
                if (d < -1.0) continue;
                if (i != n) {
                    int n4;
                    int n5 = n4 = (int)((d + 1.0) * (((double)n2 - 1.0) / 2.0));
                    nArray[n5] = nArray[n5] + 1;
                }
                if (!this.cancel) continue;
                return;
            }
            if (i * 10 % (initiationData2.columns - n3) != 0) continue;
            System.out.print("*");
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted((int)((double)(i * 100) / (double)initiationData2.columns));
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus("Finished constructing histogram");
        }
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = "" + this.format(-1.0 + (double)n / ((double)n2 / 2.0));
        }
        if (bl) {
            this.rowHistogram = nArray;
            this.rowHistogramLabels = stringArray;
            this.rowDone = true;
        } else {
            this.colHistogram = nArray;
            this.colHistogramLabels = stringArray;
            this.colDone = true;
        }
    }

    public int[] getRowHistogram() {
        return this.rowHistogram;
    }

    public int[] getColHistogram() {
        return this.colHistogram;
    }

    public String[] getRowHistogramLabels() {
        return this.rowHistogramLabels;
    }

    public String[] getColHistogramLabels() {
        return this.colHistogramLabels;
    }

    public double getRowNegCutoff() {
        return this.format(this.rowNegCutoff);
    }

    public double getRowPosCutoff() {
        return this.format(this.rowPosCutoff);
    }

    public double getColNegCutoff() {
        return this.format(this.colNegCutoff);
    }

    public double getColPosCutoff() {
        return this.format(this.colPosCutoff);
    }

    public double[] getRowCutoffs() {
        return this.getCutoffs(true);
    }

    public double[] getColCutoffs() {
        return this.getCutoffs(false);
    }

    public double[] getCutoffs(boolean bl) {
        double[] dArray = new double[2];
        if (bl) {
            dArray[0] = this.format(this.rowNegCutoff);
            dArray[1] = this.format(this.rowPosCutoff);
        } else {
            dArray[0] = this.format(this.colNegCutoff);
            dArray[1] = this.format(this.colPosCutoff);
        }
        return dArray;
    }

    public double[] getCutoffs(boolean bl, boolean bl2, boolean bl3, double d) {
        int n;
        int n2 = 0;
        if (bl) {
            for (n = 0; n < this.rowHistogram.length; ++n) {
                n2 += this.rowHistogram[n];
            }
        } else {
            for (n = 0; n < this.colHistogram.length; ++n) {
                n2 += this.colHistogram[n];
            }
        }
        n = (int)(d * (double)n2);
        return this.getCutoffs(bl, n, bl2, bl3);
    }

    public double[] getCutoffs(boolean bl, int n, boolean bl2, boolean bl3) {
        double[] dArray = new double[2];
        int n2 = -1;
        int n3 = 0;
        double[] dArray2 = this.getCutoffs(bl);
        int[] nArray = bl ? this.rowHistogram : this.colHistogram;
        while (n3 < n && n2 < nArray.length / 2 - 1) {
            ++n2;
            if (bl2) {
                n3 += nArray[n2];
            }
            if (!bl3) continue;
            n3 += nArray[nArray.length - n2 - 1];
        }
        dArray[0] = bl2 ? -1.0 + (double)n2 * 2.0 / (double)nArray.length : dArray2[0];
        dArray[1] = bl3 ? 1.0 - (double)n2 * 2.0 / (double)nArray.length : dArray2[1];
        return dArray;
    }

    public void setRowNegCutoff(double d) {
        this.rowNegCutoff = this.format(d);
    }

    public void setColNegCutoff(double d) {
        this.colNegCutoff = this.format(d);
    }

    public void setRowPosCutoff(double d) {
        this.rowPosCutoff = this.format(d);
    }

    public void setColPosCutoff(double d) {
        this.colPosCutoff = this.format(d);
    }

    public void setRowCutoffs(double[] dArray) {
        this.rowNegCutoff = this.format(dArray[0]);
        this.rowPosCutoff = this.format(dArray[1]);
    }

    public void setRowCutoffs(double d, double d2) {
        this.rowNegCutoff = this.format(d);
        this.rowPosCutoff = this.format(d2);
    }

    public void setColCutoffs(double[] dArray) {
        this.colNegCutoff = this.format(dArray[0]);
        this.colPosCutoff = this.format(dArray[1]);
    }

    public void setColCutoffs(double d, double d2) {
        this.colNegCutoff = this.format(d);
        this.colPosCutoff = this.format(d2);
    }

    public void setColPosUse(boolean bl) {
        this.colUsePos = bl;
    }

    public void setColNegUse(boolean bl) {
        this.colUseNeg = bl;
    }

    public void setRowPosUse(boolean bl) {
        this.rowUsePos = bl;
    }

    public void setRowNegUse(boolean bl) {
        this.rowUseNeg = bl;
    }

    public void setUses(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.rowUseNeg = bl2;
            this.rowUsePos = bl3;
        } else {
            this.colUseNeg = bl2;
            this.colUsePos = bl3;
        }
    }

    public boolean getColPosUse() {
        return this.colUsePos;
    }

    public boolean getColNegUse() {
        return this.colUseNeg;
    }

    public boolean getRowPosUse() {
        return this.rowUsePos;
    }

    public boolean getRowNegUse() {
        return this.rowUseNeg;
    }

    public boolean[] getUses(boolean bl) {
        boolean[] blArray = new boolean[2];
        if (bl) {
            blArray[0] = this.rowUseNeg;
            blArray[1] = this.rowUsePos;
        } else {
            blArray[0] = this.colUseNeg;
            blArray[1] = this.colUsePos;
        }
        return blArray;
    }

    public void setCutoffsInteractions(boolean bl, int n) {
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            bl2 = this.rowUsePos;
            bl3 = this.rowUseNeg;
        } else {
            bl2 = this.colUsePos;
            bl3 = this.colUseNeg;
        }
        double[] dArray = this.getCutoffs(bl, n, bl3, bl2);
        if (bl) {
            this.rowNegCutoff = this.format(dArray[0]);
            this.rowPosCutoff = this.format(dArray[1]);
        } else {
            this.colNegCutoff = this.format(dArray[0]);
            this.colPosCutoff = this.format(dArray[1]);
        }
    }

    public void setCutoffs(boolean bl, int n, boolean bl2, boolean bl3) {
        double[] dArray = this.getCutoffs(bl, n, bl2, bl3);
        if (bl) {
            this.rowNegCutoff = this.format(dArray[0]);
            this.rowPosCutoff = this.format(dArray[1]);
        } else {
            this.colNegCutoff = this.format(dArray[0]);
            this.colPosCutoff = this.format(dArray[1]);
        }
    }

    public void setCutoffsPercent(boolean bl, double d) {
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            bl2 = this.rowUsePos;
            bl3 = this.rowUseNeg;
        } else {
            bl2 = this.colUsePos;
            bl3 = this.colUseNeg;
        }
        double[] dArray = this.getCutoffs(bl, bl3, bl2, d);
        if (bl) {
            this.rowNegCutoff = this.format(dArray[0]);
            this.rowPosCutoff = this.format(dArray[1]);
        } else {
            this.colNegCutoff = this.format(dArray[0]);
            this.colPosCutoff = this.format(dArray[1]);
        }
    }

    public void setCutoffs(boolean bl, boolean bl2, boolean bl3, double d) {
        double[] dArray = this.getCutoffs(bl, bl2, bl3, d);
        if (bl) {
            this.rowNegCutoff = this.format(dArray[0]);
            this.rowPosCutoff = this.format(dArray[1]);
        } else {
            this.colNegCutoff = this.format(dArray[0]);
            this.colPosCutoff = this.format(dArray[1]);
        }
    }

    public int getNumberOfInteractions(boolean bl, double[] dArray) {
        int n;
        if (dArray == null || dArray.length < 2) {
            return 0;
        }
        int n2 = 0;
        int[] nArray = bl ? this.rowHistogram : this.colHistogram;
        boolean[] blArray = this.getUses(bl);
        if (blArray[0]) {
            n = 0;
            while (-1.0 + (double)n * 2.0 / (double)nArray.length < dArray[0]) {
                n2 += nArray[n];
                ++n;
            }
        }
        if (blArray[1]) {
            n = 0;
            while (1.0 - (double)n * 2.0 / (double)nArray.length >= dArray[1]) {
                n2 += nArray[nArray.length - n - 1];
                ++n;
            }
        }
        return n2;
    }

    public double getPercentOfInteractions(boolean bl, double[] dArray) {
        int[] nArray = bl ? this.rowHistogram : this.colHistogram;
        int n = this.getNumberOfInteractions(bl, dArray);
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 += nArray[i];
        }
        return this.format((double)n / (double)n2);
    }

    public DoubleMatrix2D getExpressionMatrix() {
        ExpressionData expressionData = Cytoscape.getExpressionData();
        return this.getExpressionMatrix(expressionData);
    }

    public DoubleMatrix2D getExpressionMatrix(ExpressionData expressionData) {
        String[] stringArray = expressionData.getConditionNames();
        int n = expressionData.getNumberOfGenes();
        int n2 = expressionData.getNumberOfConditions();
        System.out.println("Expression matrix loaded- geneNumber:" + n + " condNumber:" + n2);
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n2);
        Vector vector = expressionData.getAllMeasurements();
        for (int i = 0; i < n; ++i) {
            Vector vector2 = (Vector)vector.get(i);
            for (int j = 0; j < n2; ++j) {
                mRNAMeasurement mRNAMeasurement2 = (mRNAMeasurement)vector2.get(j);
                double d = mRNAMeasurement2.getRatio();
                denseDoubleMatrix2D.set(i, j, d);
            }
        }
        this.numberOfRows = expressionData.getNumberOfGenes();
        this.numberOfCols = expressionData.getNumberOfConditions();
        return denseDoubleMatrix2D;
    }

    public int getNumberOfRows() {
        if (this.numberOfRows < 1) {
            ExpressionData expressionData = Cytoscape.getExpressionData();
            this.numberOfRows = expressionData.getNumberOfGenes();
        }
        return this.numberOfRows;
    }

    public int getNumberOfCols() {
        if (this.numberOfCols < 1) {
            ExpressionData expressionData = Cytoscape.getExpressionData();
            this.numberOfCols = expressionData.getNumberOfConditions();
        }
        return this.numberOfCols;
    }

    public void loadCutoffs() {
        CorrelateCutoffStorage correlateCutoffStorage = CorrelateCutoffStorage.getInstance();
        this.setRowCutoffs(correlateCutoffStorage.getCutoffs(true));
        this.setColCutoffs(correlateCutoffStorage.getCutoffs(false));
    }

    public void loadColCutoffs() {
        CorrelateCutoffStorage correlateCutoffStorage = CorrelateCutoffStorage.getInstance();
        this.setColCutoffs(correlateCutoffStorage.getCutoffs(false));
    }

    public void loadRowCutoffs() {
        CorrelateCutoffStorage correlateCutoffStorage = CorrelateCutoffStorage.getInstance();
        this.setRowCutoffs(correlateCutoffStorage.getCutoffs(true));
    }

    public void saveCutoffs() {
        CorrelateCutoffStorage correlateCutoffStorage = CorrelateCutoffStorage.getInstance();
        correlateCutoffStorage.setCutoffs(true, this.getCutoffs(true));
        correlateCutoffStorage.setCutoffs(false, this.getCutoffs(false));
    }

    public void saveColCutoffs() {
        CorrelateCutoffStorage correlateCutoffStorage = CorrelateCutoffStorage.getInstance();
        correlateCutoffStorage.setCutoffs(false, this.getCutoffs(false));
    }

    public void saveRowCutoffs() {
        CorrelateCutoffStorage correlateCutoffStorage = CorrelateCutoffStorage.getInstance();
        correlateCutoffStorage.setCutoffs(true, this.getCutoffs(true));
    }

    public double[][] getHistogram(boolean bl) {
        int[] nArray = bl ? this.getRowHistogram() : this.getColHistogram();
        double[][] dArray = new double[nArray.length][3];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i][0] = -1.0 + (double)i / ((double)nArray.length / 2.0);
            dArray[i][1] = nArray[i];
            dArray[i][2] = 1000 / nArray.length;
        }
        return dArray;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean cancelled() {
        return this.cancel;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    private class initiationData {
        public DoubleMatrix2D inputMatrix;
        public boolean isRowNetwork;
        public int columns;
        public int rows;
        public double[] sums;
        public DoubleMatrix1D[] cols;
        public DenseDoubleMatrix1D stdDev;
        public boolean usePos = true;
        public boolean useNeg = true;
        boolean fullNetwork;
        TaskMonitor taskMonitor = null;

        initiationData(boolean bl, DoubleMatrix2D doubleMatrix2D, boolean bl2) {
            this.inputMatrix = doubleMatrix2D;
            this.isRowNetwork = bl;
            this.fullNetwork = bl2;
            this.tempSetup();
        }

        private void tempSetup() {
            int n;
            if (this.isRowNetwork) {
                CorrelateSimilarityNetwork.this.rowDone = false;
                CorrelateSimilarityNetwork.this.rowCurrentStep = 0;
                this.usePos = CorrelateSimilarityNetwork.this.rowUsePos;
                this.useNeg = CorrelateSimilarityNetwork.this.rowUseNeg;
                Algebra algebra = new Algebra();
                this.inputMatrix = algebra.transpose(this.inputMatrix);
                if (this.fullNetwork) {
                    CorrelateSimilarityNetwork.this.rowTotalSteps = CorrelateSimilarityNetwork.this.calcTimeFull(this.inputMatrix);
                } else {
                    CorrelateSimilarityNetwork.this.rowTotalSteps = CorrelateSimilarityNetwork.this.calcTimeSingle(this.inputMatrix);
                }
            } else {
                CorrelateSimilarityNetwork.this.colDone = false;
                CorrelateSimilarityNetwork.this.colCurrentStep = 0;
                this.usePos = CorrelateSimilarityNetwork.this.colUsePos;
                this.useNeg = CorrelateSimilarityNetwork.this.colUseNeg;
                if (this.fullNetwork) {
                    CorrelateSimilarityNetwork.this.colTotalSteps = CorrelateSimilarityNetwork.this.calcTimeFull(this.inputMatrix);
                } else {
                    CorrelateSimilarityNetwork.this.colTotalSteps = CorrelateSimilarityNetwork.this.calcTimeSingle(this.inputMatrix);
                }
            }
            this.rows = this.inputMatrix.rows();
            this.columns = this.inputMatrix.columns();
            this.sums = new double[this.columns];
            this.cols = new DoubleMatrix1D[this.columns];
            for (n = 0; n < this.columns; ++n) {
                if (this.isRowNetwork) {
                    CorrelateSimilarityNetwork.this.rowCurrentStep++;
                } else {
                    CorrelateSimilarityNetwork.this.colCurrentStep++;
                }
                this.cols[n] = this.inputMatrix.viewColumn(n);
                this.sums[n] = this.cols[n].zSum();
                if (!CorrelateSimilarityNetwork.this.cancel) continue;
                return;
            }
            this.stdDev = new DenseDoubleMatrix1D(this.columns);
            for (n = 0; n < this.columns; ++n) {
                if (this.isRowNetwork) {
                    CorrelateSimilarityNetwork.this.rowCurrentStep++;
                } else {
                    CorrelateSimilarityNetwork.this.colCurrentStep++;
                }
                double d = this.cols[n].zDotProduct(this.cols[n]);
                this.stdDev.set(n, Math.sqrt((d - this.sums[n] * this.sums[n] / (double)this.rows) / (double)this.rows));
                if (!CorrelateSimilarityNetwork.this.cancel) continue;
                return;
            }
        }
    }
}

