/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ApplicationTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ApplicationTest.class);
    }

    public ApplicationTest(String name) {
        super(name);
    }

    public void testLs() {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("a", "all", false, "do not hide entries starting with .");
        options.addOption("A", "almost-all", false, "do not list implied . and ..");
        options.addOption("b", "escape", false, "print octal escapes for nongraphic characters");
        OptionBuilder.withLongOpt("block-size");
        OptionBuilder.withDescription("use SIZE-byte blocks");
        OptionBuilder.withValueSeparator('=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        options.addOption("B", "ignore-backups", false, "do not list implied entried ending with ~");
        options.addOption("c", false, "with -lt: sort by, and show, ctime (time of last modification of file status information) with -l:show ctime and sort by name otherwise: sort by ctime");
        options.addOption("C", false, "list entries by columns");
        String[] args = new String[]{"--block-size=10"};
        try {
            CommandLine line = parser.parse(options, args);
            ApplicationTest.assertTrue((boolean)line.hasOption("block-size"));
            ApplicationTest.assertEquals((String)line.getOptionValue("block-size"), (String)"10");
        }
        catch (ParseException exp) {
            ApplicationTest.fail((String)("Unexpected exception:" + exp.getMessage()));
        }
    }

    public void testAnt() {
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("help", false, "print this message");
        options.addOption("projecthelp", false, "print project help information");
        options.addOption("version", false, "print the version information and exit");
        options.addOption("quiet", false, "be extra quiet");
        options.addOption("verbose", false, "be extra verbose");
        options.addOption("debug", false, "print debug information");
        options.addOption("version", false, "produce logging information without adornments");
        options.addOption("logfile", true, "use given file for log");
        options.addOption("logger", true, "the class which is to perform the logging");
        options.addOption("listener", true, "add an instance of a class as a project listener");
        options.addOption("buildfile", true, "use given buildfile");
        OptionBuilder.withDescription("use value for given property");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        options.addOption(OptionBuilder.create('D'));
        options.addOption("find", true, "search for buildfile towards the root of the filesystem and use it");
        String[] args = new String[]{"-buildfile", "mybuild.xml", "-Dproperty=value", "-Dproperty1=value1", "-projecthelp"};
        try {
            CommandLine line = parser.parse(options, args);
            String[] opts = line.getOptionValues("D");
            ApplicationTest.assertEquals((String)"property", (String)opts[0]);
            ApplicationTest.assertEquals((String)"value", (String)opts[1]);
            ApplicationTest.assertEquals((String)"property1", (String)opts[2]);
            ApplicationTest.assertEquals((String)"value1", (String)opts[3]);
            ApplicationTest.assertEquals((String)line.getOptionValue("buildfile"), (String)"mybuild.xml");
            ApplicationTest.assertTrue((boolean)line.hasOption("projecthelp"));
        }
        catch (ParseException exp) {
            ApplicationTest.fail((String)("Unexpected exception:" + exp.getMessage()));
        }
    }
}

