/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ParseRequiredTest
extends TestCase {
    private Options _options = null;
    private CommandLineParser parser = new PosixParser();

    public static Test suite() {
        return new TestSuite(ParseRequiredTest.class);
    }

    public ParseRequiredTest(String name) {
        super(name);
    }

    public void setUp() {
        Options options = new Options().addOption("a", "enable-a", false, "turn [a] on or off");
        OptionBuilder.withLongOpt("bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription("set the value of [b]");
        this._options = options.addOption(OptionBuilder.create('b'));
    }

    public void tearDown() {
    }

    public void testWithRequiredOption() {
        String[] args = new String[]{"-b", "file"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            ParseRequiredTest.assertTrue((String)"Confirm -a is NOT set", (!cl.hasOption("a") ? 1 : 0) != 0);
            ParseRequiredTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseRequiredTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("file"));
            ParseRequiredTest.assertTrue((String)"Confirm NO of extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ParseRequiredTest.fail((String)e.toString());
        }
    }

    public void testOptionAndRequiredOption() {
        String[] args = new String[]{"-a", "-b", "file"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            ParseRequiredTest.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
            ParseRequiredTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseRequiredTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("file"));
            ParseRequiredTest.assertTrue((String)"Confirm NO of extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ParseRequiredTest.fail((String)e.toString());
        }
    }

    public void testMissingRequiredOption() {
        block2: {
            String[] args = new String[]{"-a"};
            try {
                CommandLine cl = this.parser.parse(this._options, args);
                ParseRequiredTest.fail((String)"exception should have been thrown");
            }
            catch (ParseException e) {
                if (e instanceof MissingOptionException) break block2;
                ParseRequiredTest.fail((String)"expected to catch MissingOptionException");
            }
        }
    }
}

