/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ValueTest
extends TestCase {
    private CommandLine _cl = null;
    private CommandLine _clOptional = null;
    private Options opts = new Options();

    public static Test suite() {
        return new TestSuite(ValueTest.class);
    }

    public ValueTest(String name) {
        super(name);
    }

    public void setUp() {
        this.opts.addOption("a", false, "toggle -a");
        this.opts.addOption("b", true, "set -b");
        this.opts.addOption("c", "c", false, "toggle -c");
        this.opts.addOption("d", "d", true, "set -d");
        OptionBuilder.hasOptionalArg();
        this.opts.addOption(OptionBuilder.create('e'));
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt("fish");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withLongOpt("gravy");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs(2);
        OptionBuilder.withLongOpt("hide");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs(2);
        this.opts.addOption(OptionBuilder.create('i'));
        OptionBuilder.hasOptionalArgs();
        this.opts.addOption(OptionBuilder.create('j'));
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator(',');
        this.opts.addOption(OptionBuilder.create('k'));
        String[] args = new String[]{"-a", "-b", "foo", "--c", "--d", "bar"};
        try {
            PosixParser parser = new PosixParser();
            this._cl = parser.parse(this.opts, args);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void tearDown() {
    }

    public void testShortNoArg() {
        ValueTest.assertTrue((boolean)this._cl.hasOption("a"));
        ValueTest.assertNull((Object)this._cl.getOptionValue("a"));
    }

    public void testShortWithArg() {
        ValueTest.assertTrue((boolean)this._cl.hasOption("b"));
        ValueTest.assertNotNull((Object)this._cl.getOptionValue("b"));
        ValueTest.assertEquals((String)this._cl.getOptionValue("b"), (String)"foo");
    }

    public void testLongNoArg() {
        ValueTest.assertTrue((boolean)this._cl.hasOption("c"));
        ValueTest.assertNull((Object)this._cl.getOptionValue("c"));
    }

    public void testLongWithArg() {
        ValueTest.assertTrue((boolean)this._cl.hasOption("d"));
        ValueTest.assertNotNull((Object)this._cl.getOptionValue("d"));
        ValueTest.assertEquals((String)this._cl.getOptionValue("d"), (String)"bar");
    }

    public void testShortOptionalArgNoValue() {
        String[] args = new String[]{"-e"};
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("e"));
            ValueTest.assertNull((Object)cmd.getOptionValue("e"));
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testShortOptionalArgValue() {
        String[] args = new String[]{"-e", "everything"};
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("e"));
            ValueTest.assertEquals((String)"everything", (String)cmd.getOptionValue("e"));
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testLongOptionalNoValue() {
        String[] args = new String[]{"--fish"};
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("fish"));
            ValueTest.assertNull((Object)cmd.getOptionValue("fish"));
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testLongOptionalArgValue() {
        String[] args = new String[]{"--fish", "face"};
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("fish"));
            ValueTest.assertEquals((String)"face", (String)cmd.getOptionValue("fish"));
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testShortOptionalArgValues() {
        String[] args = new String[]{"-j", "ink", "idea"};
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("j"));
            ValueTest.assertEquals((String)"ink", (String)cmd.getOptionValue("j"));
            ValueTest.assertEquals((String)"ink", (String)cmd.getOptionValues("j")[0]);
            ValueTest.assertEquals((String)"idea", (String)cmd.getOptionValues("j")[1]);
            ValueTest.assertEquals((int)cmd.getArgs().length, (int)0);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testLongOptionalArgValues() {
        String[] args = new String[]{"--gravy", "gold", "garden"};
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("gravy"));
            ValueTest.assertEquals((String)"gold", (String)cmd.getOptionValue("gravy"));
            ValueTest.assertEquals((String)"gold", (String)cmd.getOptionValues("gravy")[0]);
            ValueTest.assertEquals((String)"garden", (String)cmd.getOptionValues("gravy")[1]);
            ValueTest.assertEquals((int)cmd.getArgs().length, (int)0);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testShortOptionalNArgValues() {
        String[] args = new String[]{"-i", "ink", "idea", "isotope", "ice"};
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("i"));
            ValueTest.assertEquals((String)"ink", (String)cmd.getOptionValue("i"));
            ValueTest.assertEquals((String)"ink", (String)cmd.getOptionValues("i")[0]);
            ValueTest.assertEquals((String)"idea", (String)cmd.getOptionValues("i")[1]);
            ValueTest.assertEquals((int)cmd.getArgs().length, (int)2);
            ValueTest.assertEquals((String)"isotope", (String)cmd.getArgs()[0]);
            ValueTest.assertEquals((String)"ice", (String)cmd.getArgs()[1]);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testLongOptionalNArgValues() {
        String[] args = new String[]{"--hide", "house", "hair", "head"};
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(this.opts, args);
            ValueTest.assertTrue((boolean)cmd.hasOption("hide"));
            ValueTest.assertEquals((String)"house", (String)cmd.getOptionValue("hide"));
            ValueTest.assertEquals((String)"house", (String)cmd.getOptionValues("hide")[0]);
            ValueTest.assertEquals((String)"hair", (String)cmd.getOptionValues("hide")[1]);
            ValueTest.assertEquals((int)cmd.getArgs().length, (int)1);
            ValueTest.assertEquals((String)"head", (String)cmd.getArgs()[0]);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testPropertyOptionSingularValue() {
        Properties properties = new Properties();
        properties.setProperty("hide", "seek");
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(this.opts, null, properties);
            ValueTest.assertTrue((boolean)cmd.hasOption("hide"));
            ValueTest.assertEquals((String)"seek", (String)cmd.getOptionValue("hide"));
            ValueTest.assertTrue((!cmd.hasOption("fake") ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testPropertyOptionFlags() {
        CommandLine cmd;
        Properties properties = new Properties();
        properties.setProperty("a", "true");
        properties.setProperty("c", "yes");
        properties.setProperty("e", "1");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(this.opts, null, properties);
            ValueTest.assertTrue((boolean)cmd.hasOption("a"));
            ValueTest.assertTrue((boolean)cmd.hasOption("c"));
            ValueTest.assertTrue((boolean)cmd.hasOption("e"));
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
        properties = new Properties();
        properties.setProperty("a", "false");
        properties.setProperty("c", "no");
        properties.setProperty("e", "0");
        try {
            cmd = parser.parse(this.opts, null, properties);
            ValueTest.assertTrue((!cmd.hasOption("a") ? 1 : 0) != 0);
            ValueTest.assertTrue((!cmd.hasOption("c") ? 1 : 0) != 0);
            ValueTest.assertTrue((!cmd.hasOption("e") ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
        properties = new Properties();
        properties.setProperty("a", "TRUE");
        properties.setProperty("c", "nO");
        properties.setProperty("e", "TrUe");
        try {
            cmd = parser.parse(this.opts, null, properties);
            ValueTest.assertTrue((boolean)cmd.hasOption("a"));
            ValueTest.assertTrue((!cmd.hasOption("c") ? 1 : 0) != 0);
            ValueTest.assertTrue((boolean)cmd.hasOption("e"));
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
        properties = new Properties();
        properties.setProperty("a", "just a string");
        properties.setProperty("e", "");
        try {
            cmd = parser.parse(this.opts, null, properties);
            ValueTest.assertTrue((!cmd.hasOption("a") ? 1 : 0) != 0);
            ValueTest.assertTrue((!cmd.hasOption("c") ? 1 : 0) != 0);
            ValueTest.assertTrue((!cmd.hasOption("e") ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testPropertyOptionMultipleValues() {
        Properties properties = new Properties();
        properties.setProperty("k", "one,two");
        PosixParser parser = new PosixParser();
        Object[] values = new String[]{"one", "two"};
        try {
            CommandLine cmd = parser.parse(this.opts, null, properties);
            ValueTest.assertTrue((boolean)cmd.hasOption("k"));
            ValueTest.assertTrue((boolean)Arrays.equals(values, cmd.getOptionValues('k')));
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void testPropertyOverrideValues() {
        String[] args = new String[]{"-j", "found", "-i", "ink"};
        Properties properties = new Properties();
        properties.setProperty("j", "seek");
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.opts, args, properties);
            ValueTest.assertTrue((boolean)cmd.hasOption("j"));
            ValueTest.assertEquals((String)"found", (String)cmd.getOptionValue("j"));
            ValueTest.assertTrue((boolean)cmd.hasOption("i"));
            ValueTest.assertEquals((String)"ink", (String)cmd.getOptionValue("i"));
            ValueTest.assertTrue((!cmd.hasOption("fake") ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ValueTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }
}

