/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ValuesTest
extends TestCase {
    private CommandLine _cmdline = null;
    private Option _option = null;

    public static Test suite() {
        return new TestSuite(ValuesTest.class);
    }

    public ValuesTest(String name) {
        super(name);
    }

    public void setUp() {
        Options opts = new Options();
        opts.addOption("a", false, "toggle -a");
        opts.addOption("b", true, "set -b");
        opts.addOption("c", "c", false, "toggle -c");
        opts.addOption("d", "d", true, "set -d");
        OptionBuilder.withLongOpt("e");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("set -e ");
        opts.addOption(OptionBuilder.create('e'));
        opts.addOption("f", "f", false, "jk");
        OptionBuilder.withLongOpt("g");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withDescription("set -g");
        opts.addOption(OptionBuilder.create('g'));
        OptionBuilder.withLongOpt("h");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withDescription("set -h");
        opts.addOption(OptionBuilder.create('h'));
        OptionBuilder.withLongOpt("i");
        OptionBuilder.withDescription("set -i");
        opts.addOption(OptionBuilder.create('i'));
        OptionBuilder.withLongOpt("j");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("set -j");
        OptionBuilder.withValueSeparator('=');
        opts.addOption(OptionBuilder.create('j'));
        OptionBuilder.withLongOpt("k");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("set -k");
        OptionBuilder.withValueSeparator('=');
        opts.addOption(OptionBuilder.create('k'));
        OptionBuilder.withLongOpt("m");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("set -m");
        OptionBuilder.withValueSeparator();
        this._option = OptionBuilder.create('m');
        opts.addOption(this._option);
        String[] args = new String[]{"-a", "-b", "foo", "--c", "--d", "bar", "-e", "one", "two", "-f", "arg1", "arg2", "-g", "val1", "val2", "arg3", "-h", "val1", "-i", "-h", "val2", "-jkey=value", "-j", "key=value", "-kkey1=value1", "-kkey2=value2", "-mkey=value"};
        PosixParser parser = new PosixParser();
        try {
            this._cmdline = parser.parse(opts, args);
        }
        catch (ParseException e) {
            ValuesTest.fail((String)("Cannot setUp() CommandLine: " + e.toString()));
        }
    }

    public void tearDown() {
    }

    public void testShortArgs() {
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("a"));
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("c"));
        ValuesTest.assertNull((Object)this._cmdline.getOptionValues("a"));
        ValuesTest.assertNull((Object)this._cmdline.getOptionValues("c"));
    }

    public void testShortArgsWithValue() {
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("b"));
        ValuesTest.assertTrue((boolean)this._cmdline.getOptionValue("b").equals("foo"));
        ValuesTest.assertTrue((this._cmdline.getOptionValues("b").length == 1 ? 1 : 0) != 0);
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("d"));
        ValuesTest.assertTrue((boolean)this._cmdline.getOptionValue("d").equals("bar"));
        ValuesTest.assertTrue((this._cmdline.getOptionValues("d").length == 1 ? 1 : 0) != 0);
    }

    public void testMultipleArgValues() {
        String[] result = this._cmdline.getOptionValues("e");
        Object[] values = new String[]{"one", "two"};
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("e"));
        ValuesTest.assertTrue((this._cmdline.getOptionValues("e").length == 2 ? 1 : 0) != 0);
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues("e")));
    }

    public void testTwoArgValues() {
        String[] result = this._cmdline.getOptionValues("g");
        Object[] values = new String[]{"val1", "val2"};
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("g"));
        ValuesTest.assertTrue((this._cmdline.getOptionValues("g").length == 2 ? 1 : 0) != 0);
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues("g")));
    }

    public void testComplexValues() {
        String[] result = this._cmdline.getOptionValues("h");
        Object[] values = new String[]{"val1", "val2"};
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("i"));
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("h"));
        ValuesTest.assertTrue((this._cmdline.getOptionValues("h").length == 2 ? 1 : 0) != 0);
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues("h")));
    }

    public void testExtraArgs() {
        Object[] args = new String[]{"arg1", "arg2", "arg3"};
        ValuesTest.assertTrue((this._cmdline.getArgs().length == 3 ? 1 : 0) != 0);
        ValuesTest.assertTrue((boolean)Arrays.equals(args, this._cmdline.getArgs()));
    }

    public void testCharSeparator() {
        Object[] values = new String[]{"key", "value", "key", "value"};
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("j"));
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption('j'));
        ValuesTest.assertEquals((int)4, (int)this._cmdline.getOptionValues("j").length);
        ValuesTest.assertEquals((int)4, (int)this._cmdline.getOptionValues('j').length);
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues("j")));
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues('j')));
        values = new String[]{"key1", "value1", "key2", "value2"};
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("k"));
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption('k'));
        ValuesTest.assertTrue((this._cmdline.getOptionValues("k").length == 4 ? 1 : 0) != 0);
        ValuesTest.assertTrue((this._cmdline.getOptionValues('k').length == 4 ? 1 : 0) != 0);
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues("k")));
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues('k')));
        values = new String[]{"key", "value"};
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption("m"));
        ValuesTest.assertTrue((boolean)this._cmdline.hasOption('m'));
        ValuesTest.assertTrue((this._cmdline.getOptionValues("m").length == 2 ? 1 : 0) != 0);
        ValuesTest.assertTrue((this._cmdline.getOptionValues('m').length == 2 ? 1 : 0) != 0);
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues("m")));
        ValuesTest.assertTrue((boolean)Arrays.equals(values, this._cmdline.getOptionValues('m')));
    }
}

