/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.geneassociation;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.ontology.GeneOntology;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.synonyms.Aliases;
import cytoscape.util.BioDataServerUtil;
import cytoscape.util.URLUtil;
import edu.ucsd.bioeng.coreplugin.tableImport.reader.TextFileDelimiters;
import edu.ucsd.bioeng.coreplugin.tableImport.reader.TextTableReader;
import giny.model.Node;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ccbr.bader.geneassociation.GeneAssociationTags;
import org.ccbr.bader.yeast.GONamespace;
import org.ccbr.bader.yeast.export.GOFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneAssociationReaderUtil
implements TextTableReader {
    private static final String GO_PREFIX = "GO";
    private static final String ANNOTATION_PREFIX = "annotation";
    private static final String GA_DELIMITER = TextFileDelimiters.TAB.toString();
    private static final String ID = "ID";
    private static final int EXPECTED_COL_COUNT = GeneAssociationTags.values().length;
    private static final int DB_OBJ_ID = 1;
    private static final int KEY = 2;
    private static final int OBJ_NAME = 9;
    private static final int SYNONYM = 10;
    private static final int GOID = 4;
    private static final String TAXON_RESOURCE_FILE = "/cytoscape/resources/tax_report.txt";
    private InputStream is;
    private final String keyAttributeName;
    private Aliases nodeAliases;
    private Map<String, List<String>> attr2id;
    private CyAttributes nodeAttributes;
    private GeneOntology geneOntology;
    private HashMap speciesMap;
    private boolean importAll = false;
    protected Map<String, List<String>> GOIDToGeneID = new HashMap<String, List<String>>();
    protected Map<String, List<String>> GOIDToGeneSynonyms = new HashMap<String, List<String>>();
    private Set<String> geneIds = new HashSet<String>();
    private Set<String> molecularFunctionGeneIds = new HashSet<String>();
    private Set<String> biologicalProcessGeneIds = new HashSet<String>();
    private Set<String> cellularComponentGeneIds = new HashSet<String>();
    private static final int ONTOLOGY_NAMESPACE = 8;
    StringBuffer headerComment = new StringBuffer();
    private static final String lsep = System.getProperty("line.separator");
    Collection<String[]> annotationEntries = new ArrayList<String[]>();

    public GeneAssociationReaderUtil(String ontologyName, URL url, String keyAttributeName) throws IOException, GOFormatException {
        this(ontologyName, URLUtil.getInputStream((URL)url), keyAttributeName, false);
    }

    public GeneAssociationReaderUtil(String ontologyName, URL url, String keyAttributeName, boolean importAll) throws IOException, GOFormatException {
        this(ontologyName, URLUtil.getInputStream((URL)url), keyAttributeName, importAll);
    }

    public GeneAssociationReaderUtil(String ontologyName, InputStream is, String keyAttributeName, boolean importAll) throws IOException, GOFormatException {
        this.importAll = importAll;
        this.is = is;
        this.keyAttributeName = keyAttributeName;
        this.nodeAliases = Cytoscape.getOntologyServer().getNodeAliases();
        this.nodeAttributes = Cytoscape.getNodeAttributes();
        Ontology testOntology = (Ontology)Cytoscape.getOntologyServer().getOntologies().get(ontologyName);
        if (testOntology.getClass() != GeneOntology.class) {
            throw new GOFormatException("Given ontology is not GO.");
        }
        this.geneOntology = (GeneOntology)testOntology;
        BufferedReader taxonFileReader = new BufferedReader(new InputStreamReader(this.getClass().getResource(TAXON_RESOURCE_FILE).openStream()));
        BioDataServerUtil bdsu = new BioDataServerUtil();
        this.speciesMap = bdsu.getTaxonMap(taxonFileReader);
        taxonFileReader.close();
        if (this.keyAttributeName != null && !this.keyAttributeName.equals(ID)) {
            this.buildMap();
        }
    }

    private void buildMap() {
        this.attr2id = new HashMap<String, List<String>>();
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        String nodeID = null;
        Node node = null;
        String attributeValue = null;
        List<String> nodeIdList = null;
        while (it.hasNext()) {
            node = (Node)it.next();
            nodeID = node.getIdentifier();
            attributeValue = this.nodeAttributes.getStringAttribute(nodeID, this.keyAttributeName);
            if (attributeValue == null) continue;
            nodeIdList = this.attr2id.containsKey(attributeValue) ? this.attr2id.get(attributeValue) : new ArrayList<String>();
            nodeIdList.add(nodeID);
            this.attr2id.put(attributeValue, nodeIdList);
        }
    }

    public void readTable() throws IOException {
        BufferedReader bufRd = new BufferedReader(new InputStreamReader(this.is));
        String line = null;
        int global = 0;
        while ((line = bufRd.readLine()) != null) {
            ++global;
            String[] parts = line.split(GA_DELIMITER);
            if (line.charAt(0) == '!') {
                this.headerComment.append(line);
                this.headerComment.append(lsep);
                continue;
            }
            if (parts.length != EXPECTED_COL_COUNT) continue;
            this.parseGA(parts);
        }
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
        if (bufRd != null) {
            bufRd.close();
            bufRd = null;
        }
    }

    private String setAlias(String key, String objName, String synoString, String dbSpecificId) {
        String[] tempObj;
        String[] synos = synoString.split(TextFileDelimiters.PIPE.toString());
        TreeSet<String> idSet = new TreeSet<String>();
        if (objName != null && objName.length() != 0 && (tempObj = objName.split(":")).length != 0) {
            String[] objNames;
            for (String name : objNames = tempObj[0].split(",")) {
                idSet.add(name);
            }
        }
        idSet.add(key);
        if (dbSpecificId != null && dbSpecificId.length() != 0) {
            idSet.add(dbSpecificId);
        }
        for (String synonym : synos) {
            idSet.add(synonym);
        }
        for (String id : idSet) {
            if (Cytoscape.getCyNode((String)id) == null) continue;
            if (idSet.size() != 1) {
                idSet.remove(id);
            }
            this.nodeAliases.add(id, new ArrayList(idSet));
            return id;
        }
        return null;
    }

    private List<String> setMultipleAliases(String key, String synoString) {
        String[] synos = synoString.split(TextFileDelimiters.PIPE.toString());
        TreeSet<String> idSet = new TreeSet<String>();
        idSet.add(key);
        for (String synonym : synos) {
            idSet.add(synonym);
        }
        for (String id : idSet) {
            if (!this.attr2id.containsKey(id)) continue;
            List<String> nodeIDs = this.attr2id.get(id);
            for (String nodeID : nodeIDs) {
                this.nodeAliases.add(nodeID, new ArrayList(idSet));
            }
            return nodeIDs;
        }
        return null;
    }

    private void parseGA(String[] entries) {
        if (this.geneOntology.getAspect(entries[4]) == null) {
            return;
        }
        this.annotationEntries.add(entries);
        String curGOID = entries[4];
        ArrayList<String> annotatedGeneIDs = this.GOIDToGeneID.containsKey(curGOID) ? this.GOIDToGeneID.get(curGOID) : new ArrayList<String>();
        annotatedGeneIDs.add(entries[1]);
        this.GOIDToGeneID.put(curGOID, annotatedGeneIDs);
        curGOID = entries[4];
        ArrayList<String> annotatedGeneSyns = this.GOIDToGeneSynonyms.containsKey(curGOID) ? this.GOIDToGeneSynonyms.get(curGOID) : new ArrayList<String>();
        String geneSyns = entries[10];
        if (!geneSyns.matches("\\s*")) {
            if (geneSyns.contains("|")) {
                for (String geneSyn : geneSyns.split("\\|")) {
                    if (geneSyn.matches("\\s*")) continue;
                    annotatedGeneSyns.add(geneSyn.trim());
                }
            } else {
                annotatedGeneSyns.add(geneSyns);
            }
            this.GOIDToGeneSynonyms.put(curGOID, annotatedGeneSyns);
        }
        String ontologyNamespace = entries[8];
        switch (ontologyNamespace.charAt(0)) {
            case 'C': {
                this.cellularComponentGeneIds.add(entries[1]);
                break;
            }
            case 'P': {
                this.biologicalProcessGeneIds.add(entries[1]);
                break;
            }
            case 'F': {
                this.molecularFunctionGeneIds.add(entries[1]);
                break;
            }
            default: {
                throw new RuntimeException("Invalid entry '" + ontologyNamespace + "' found for ontology namespace in column '" + 8 + "' of gene association file.");
            }
        }
        this.geneIds.add(entries[1]);
        String attributeName = "annotation.GO " + this.geneOntology.getAspect(entries[4]).name();
        if (this.importAll) {
            if (entries[10] != null && entries[10].length() != 0) {
                String[] alias = entries[10].split(TextFileDelimiters.PIPE.toString());
                this.nodeAliases.add(entries[2], Arrays.asList(alias));
            }
            this.mapEntry(entries, entries[2], attributeName);
        } else if (this.keyAttributeName.equals(ID)) {
            String newKey = this.setAlias(entries[2], entries[9], entries[10], entries[1]);
            if (newKey != null) {
                this.mapEntry(entries, newKey, attributeName);
            }
        } else {
            List<String> keys = this.setMultipleAliases(entries[2], entries[10]);
            if (keys != null) {
                for (String key : keys) {
                    this.mapEntry(entries, key, attributeName);
                }
            }
        }
    }

    private void mapEntry(String[] entries, String key, String attributeName) {
        String fullName = null;
        block7: for (int i = 0; i < GeneAssociationTags.values().length; ++i) {
            GeneAssociationTags tag = GeneAssociationTags.values()[i];
            switch (tag) {
                case GO_ID: {
                    TreeSet<String> goTermSet = new TreeSet<String>();
                    if (this.nodeAttributes.getListAttribute(key, attributeName) != null) {
                        goTermSet.addAll(this.nodeAttributes.getListAttribute(key, attributeName));
                    }
                    if ((fullName = this.geneOntology.getGOTerm(entries[i]).getFullName()) != null) {
                        goTermSet.add(fullName);
                    }
                    this.nodeAttributes.setListAttribute(key, attributeName, new ArrayList(goTermSet));
                    continue block7;
                }
                case TAXON: {
                    this.nodeAttributes.setAttribute(key, "annotation." + tag.toString(), (String)this.speciesMap.get(entries[i].split(":")[1]));
                    continue block7;
                }
                case EVIDENCE: {
                    HashMap<String, String> evidences = this.nodeAttributes.getMapAttribute(key, "annotation." + tag.toString());
                    if (evidences == null) {
                        evidences = new HashMap<String, String>();
                    }
                    evidences.put(entries[4], entries[i]);
                    this.nodeAttributes.setMapAttribute(key, "annotation." + tag.toString(), evidences);
                    continue block7;
                }
                case DB_REFERENCE: {
                    HashMap<String, String> references = this.nodeAttributes.getMapAttribute(key, "annotation." + tag.toString());
                    if (references == null) {
                        references = new HashMap<String, String>();
                    }
                    references.put(entries[4], entries[i]);
                    this.nodeAttributes.setMapAttribute(key, "annotation." + tag.toString(), references);
                    continue block7;
                }
                case DB_OBJECT_SYMBOL: 
                case ASPECT: 
                case DB_OBJECT_SYNONYM: {
                    continue block7;
                }
                default: {
                    this.nodeAttributes.setAttribute(key, "annotation." + tag.toString(), entries[i]);
                }
            }
        }
    }

    public List getColumnNames() {
        ArrayList<String> colNames = new ArrayList<String>();
        for (GeneAssociationTags tag : GeneAssociationTags.values()) {
            colNames.add(tag.toString());
        }
        return colNames;
    }

    public String getReport() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public Map<String, List<String>> getGOIDToGeneIDMap() {
        return this.GOIDToGeneID;
    }

    public Set<String> getGeneIds() {
        return this.geneIds;
    }

    public Set<String> getBiologicalProcessGeneIds() {
        return this.biologicalProcessGeneIds;
    }

    public Set<String> getCellularComponentGeneIds() {
        return this.cellularComponentGeneIds;
    }

    public Set<String> getMolecularFunctionGeneIds() {
        return this.molecularFunctionGeneIds;
    }

    public Set<String> getNamespaceGeneIds(GONamespace ns) {
        if (ns == GONamespace.BioPro) {
            return this.biologicalProcessGeneIds;
        }
        if (ns == GONamespace.CelCom) {
            return this.cellularComponentGeneIds;
        }
        if (ns == GONamespace.MolFun) {
            return this.molecularFunctionGeneIds;
        }
        throw new RuntimeException(ns.getName() + " is not a known Gene Ontology Namespace");
    }

    public Collection<String[]> getAnnotationEntries() {
        return this.annotationEntries;
    }

    public Map<String, List<String>> getGOIDToGeneSynonyms() {
        return this.GOIDToGeneSynonyms;
    }

    public void setGOIDToGeneSynonyms(Map<String, List<String>> toGeneSynonyms) {
        this.GOIDToGeneSynonyms = toGeneSynonyms;
    }

    public StringBuffer getHeaderComment() {
        return this.headerComment;
    }

    public void setHeaderComment(StringBuffer headerComment) {
        this.headerComment = headerComment;
    }
}

