/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.ontology.GeneOntology;
import cytoscape.data.ontology.Ontology;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ccbr.bader.yeast.GOSlimmerException;
import org.ccbr.bader.yeast.export.RootNodeNotSelectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOSlimmerUtil {
    private static final CyAttributes nodeAtt = Cytoscape.getNodeAttributes();

    public static int getNumGenesCoveredByGoNode(Node goNode, boolean includeCoverageInferredFromDescendants) {
        int numCovered;
        List directlyCoveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_GENES");
        int n = numCovered = directlyCoveredGenes != null ? directlyCoveredGenes.size() : 0;
        if (includeCoverageInferredFromDescendants) {
            List inferredCoveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_GENES");
            numCovered += inferredCoveredGenes != null ? inferredCoveredGenes.size() : 0;
        }
        return numCovered;
    }

    public static int getNumGenesCoveredByGoNode(Node goNode, boolean includeCoverageInferredFromDescendants, boolean userGenes) {
        int numCovered;
        String inferredGeneAttributeName = userGenes ? "GOSlimmer.INFERRED_ANNOTATED_USER_GENES" : "GOSlimmer.INFERRED_ANNOTATED_GENES";
        String directGeneAttributeName = userGenes ? "GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES" : "GOSlimmer.DIRECTLY_ANNOTATED_GENES";
        List directlyCoveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), directGeneAttributeName);
        int n = numCovered = directlyCoveredGenes != null ? directlyCoveredGenes.size() : 0;
        if (includeCoverageInferredFromDescendants) {
            List inferredCoveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), inferredGeneAttributeName);
            numCovered += inferredCoveredGenes != null ? inferredCoveredGenes.size() : 0;
        }
        return numCovered;
    }

    public static List<String> getGenesCoveredByGoNode(Node goNode, boolean includeCoverageInferredFromDescendants) {
        List inferredCoveredGenes;
        ArrayList<String> coveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_GENES");
        if (coveredGenes == null) {
            coveredGenes = new ArrayList<String>();
        }
        if (includeCoverageInferredFromDescendants && (inferredCoveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_GENES")) != null) {
            coveredGenes.addAll(inferredCoveredGenes);
        }
        return coveredGenes;
    }

    public static List<String> getGenesCoveredByGoNode(Node goNode, boolean includeCoverageInferredFromDescendants, boolean userGenes) {
        List inferredCoveredGenes;
        String inferredGeneAttributeName = userGenes ? "GOSlimmer.INFERRED_ANNOTATED_USER_GENES" : "GOSlimmer.INFERRED_ANNOTATED_GENES";
        String directGeneAttributeName = userGenes ? "GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES" : "GOSlimmer.DIRECTLY_ANNOTATED_GENES";
        ArrayList<String> coveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), directGeneAttributeName);
        if (coveredGenes == null) {
            coveredGenes = new ArrayList<String>();
        }
        if (includeCoverageInferredFromDescendants && (inferredCoveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), inferredGeneAttributeName)) != null) {
            coveredGenes.addAll(inferredCoveredGenes);
        }
        return coveredGenes;
    }

    public static List<String> getDirectlyCoveredGenes(Node goNode) {
        ArrayList coveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_GENES");
        if (coveredGenes == null) {
            coveredGenes = new ArrayList();
        }
        return coveredGenes;
    }

    public static List<String> getDirectlyCoveredUserGenes(Node goNode) {
        ArrayList coveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES");
        if (coveredGenes == null) {
            coveredGenes = new ArrayList();
        }
        return coveredGenes;
    }

    public static List<String> getInferredCoveredGenes(Node goNode) {
        ArrayList coveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_GENES");
        if (coveredGenes == null) {
            coveredGenes = new ArrayList();
        }
        return coveredGenes;
    }

    public static List<String> getInferredCoveredUserGenes(Node goNode) {
        ArrayList coveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_USER_GENES");
        if (coveredGenes == null) {
            coveredGenes = new ArrayList();
        }
        return coveredGenes;
    }

    public static Set<String> getGenesCoveredByChildren(Node node, CyNetwork network) {
        return GOSlimmerUtil.getGenesCoveredByChildren(node, network, "GOSlimmer.DIRECTLY_ANNOTATED_GENES", "GOSlimmer.INFERRED_ANNOTATED_GENES");
    }

    public static Set<String> getGenesCoveredByChildren(Node node, CyNetwork network, boolean userGenes) {
        String inferredGeneAttributeName = userGenes ? "GOSlimmer.INFERRED_ANNOTATED_USER_GENES" : "GOSlimmer.INFERRED_ANNOTATED_GENES";
        String directGeneAttributeName = userGenes ? "GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES" : "GOSlimmer.DIRECTLY_ANNOTATED_GENES";
        return GOSlimmerUtil.getGenesCoveredByChildren(node, network, directGeneAttributeName, inferredGeneAttributeName);
    }

    public static Set<String> getGenesCoveredByChildren(Node node, CyNetwork network, String directCoverageAttributeName, String inferredCoverageAttributeName) {
        CyAttributes nodeAtt = Cytoscape.getNodeAttributes();
        List inferredCoveredGenes = nodeAtt.getListAttribute(node.getIdentifier(), inferredCoverageAttributeName);
        if (inferredCoveredGenes != null && inferredCoveredGenes.size() > 0) {
            return GOSlimmerUtil.listToSet(inferredCoveredGenes);
        }
        int[] childEdges = network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, true, false);
        if (childEdges == null || childEdges.length == 0) {
            return new HashSet<String>();
        }
        HashSet<String> inferredCoveredGenesS = new HashSet<String>();
        for (int childEdgeI : childEdges) {
            Node child = network.getEdge(childEdgeI).getSource();
            List childsDirectlyCoveredGenes = nodeAtt.getListAttribute(child.getIdentifier(), directCoverageAttributeName);
            if (childsDirectlyCoveredGenes != null) {
                inferredCoveredGenesS.addAll(childsDirectlyCoveredGenes);
            }
            Set<String> childsInferredCoveredGenes = GOSlimmerUtil.getGenesCoveredByChildren(child, network, directCoverageAttributeName, inferredCoverageAttributeName);
            nodeAtt.setListAttribute(child.getIdentifier(), inferredCoverageAttributeName, GOSlimmerUtil.setToList(childsInferredCoveredGenes));
            inferredCoveredGenesS.addAll(childsInferredCoveredGenes);
        }
        return inferredCoveredGenesS;
    }

    public static Set<String> listToSet(List<String> list) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(list);
        return set;
    }

    public static List<String> setToList(Set<String> set) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(set);
        return list;
    }

    public static Node getRootNode(CyNetwork network) {
        Iterator nodeI = network.nodesIterator();
        if (!nodeI.hasNext()) {
            return null;
        }
        Node node = (Node)nodeI.next();
        int[] ancestorEdges = network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, false, true);
        while (ancestorEdges != null && ancestorEdges.length > 0) {
            node = network.getNode(network.getEdgeTargetIndex(ancestorEdges[0]));
            ancestorEdges = network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, false, true);
        }
        return node;
    }

    public static Map<String, String> createGoTermRemap(CyNetwork godag) throws GOSlimmerException {
        HashMap<String, String> goTermRemap = new HashMap<String, String>();
        Node rootNode = GOSlimmerUtil.getRootNode(godag);
        Stack<String> lastSelectedTermId = new Stack<String>();
        if (!GOSlimmerUtil.isSelected(rootNode)) {
            throw new RootNodeNotSelectedException("Cannot remap because root node is not selected; some annotations would be lost.");
        }
        lastSelectedTermId.push(rootNode.getIdentifier());
        goTermRemap.put(rootNode.getIdentifier(), rootNode.getIdentifier());
        int[] childEdges = godag.getAdjacentEdgeIndicesArray(rootNode.getRootGraphIndex(), false, true, false);
        GOSlimmerUtil.remapGoTerms(childEdges, lastSelectedTermId, godag, goTermRemap);
        return goTermRemap;
    }

    public static Map<String, Set<String>> createGoTermMultipleRemap(CyNetwork godag) throws GOSlimmerException {
        HashMap<String, Set<String>> goTermRemap = new HashMap<String, Set<String>>();
        Node rootNode = GOSlimmerUtil.getRootNode(godag);
        Stack<String> lastSelectedTermId = new Stack<String>();
        if (!GOSlimmerUtil.isSelected(rootNode)) {
            throw new RootNodeNotSelectedException("Cannot remap because root node is not selected; some annotations would be lost.");
        }
        lastSelectedTermId.push(rootNode.getIdentifier());
        HashSet<String> mappedTermList = new HashSet<String>();
        mappedTermList.add(rootNode.getIdentifier());
        goTermRemap.put(rootNode.getIdentifier(), mappedTermList);
        int[] childEdges = godag.getAdjacentEdgeIndicesArray(rootNode.getRootGraphIndex(), false, true, false);
        GOSlimmerUtil.multipleRemapGoTerms(childEdges, lastSelectedTermId, godag, goTermRemap);
        return goTermRemap;
    }

    private static void remapGoTerms(int[] childEdges, Stack<String> lastSelectedTermId, CyNetwork godag, Map<String, String> remap) {
        if (childEdges == null) {
            return;
        }
        for (int childEdge : childEdges) {
            int[] grandChildEdges;
            Node node = godag.getNode(godag.getEdgeSourceIndex(childEdge));
            if (GOSlimmerUtil.isSelected(node)) {
                String goTerm = node.getIdentifier();
                remap.put(goTerm, goTerm);
                lastSelectedTermId.push(goTerm);
                grandChildEdges = godag.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, true, false);
                GOSlimmerUtil.remapGoTerms(grandChildEdges, lastSelectedTermId, godag, remap);
                if (goTerm == lastSelectedTermId.pop()) continue;
                throw new RuntimeException("element at top of stack is not the same one which was placed there, as is expected by algorithm logic.");
            }
            String lastSelectedTerm = lastSelectedTermId.peek();
            if (lastSelectedTerm == null) {
                throw new RuntimeException("cannot remap because no term on stack");
            }
            remap.put(node.getIdentifier(), lastSelectedTerm);
            grandChildEdges = godag.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, true, false);
            GOSlimmerUtil.remapGoTerms(grandChildEdges, lastSelectedTermId, godag, remap);
        }
    }

    private static void multipleRemapGoTerms(int[] childEdges, Stack<String> lastSelectedTermId, CyNetwork godag, Map<String, Set<String>> remap) {
        if (childEdges == null) {
            return;
        }
        for (int childEdge : childEdges) {
            Node node = godag.getNode(godag.getEdgeSourceIndex(childEdge));
            if (GOSlimmerUtil.isSelected(node)) {
                String goTerm = node.getIdentifier();
                Set<Object> remapList = remap.get(goTerm) != null ? remap.get(goTerm) : new HashSet();
                remapList.add(goTerm);
                remap.put(goTerm, remapList);
                lastSelectedTermId.push(goTerm);
                int[] grandChildEdges = godag.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, true, false);
                GOSlimmerUtil.multipleRemapGoTerms(grandChildEdges, lastSelectedTermId, godag, remap);
                if (goTerm == lastSelectedTermId.pop()) continue;
                throw new RuntimeException("element at top of stack is not the same one which was placed there, as is expected by algorithm logic.");
            }
            String lastSelectedTerm = lastSelectedTermId.peek();
            String currentGoTerm = node.getIdentifier();
            if (lastSelectedTerm == null) {
                throw new RuntimeException("cannot remap because no term on stack");
            }
            Set<Object> remapList = remap.get(currentGoTerm) != null ? remap.get(currentGoTerm) : new HashSet();
            remapList.add(lastSelectedTerm);
            remap.put(currentGoTerm, remapList);
            int[] grandChildEdges = godag.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, true, false);
            GOSlimmerUtil.multipleRemapGoTerms(grandChildEdges, lastSelectedTermId, godag, remap);
        }
    }

    private static boolean isSelected(Node goNode) {
        Boolean isSelected = nodeAtt.getBooleanAttribute(goNode.getIdentifier(), "GOSlimmer.INSET");
        if (isSelected == null) {
            return false;
        }
        return isSelected;
    }

    public static void deleteGOSlimmerAttributes() {
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.DIRECTLY_ANNOTATED_GENES");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.INFERRED_ANNOTATED_GENES");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.INSET");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.INFERRED_ANNOTATED_USER_GENES");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.NUMBER_DIRECTLY_ANNOTATED_GENES");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.NUMBER_INFERRED_ANNOTATED_GENES");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.DIRECTLY_ANNOTATED_GENE_SYNONYMS");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.INFERRED_ANNOTATED_GENE_SYNONYMS");
        Cytoscape.getNodeAttributes().deleteAttribute("GOSlimmer.FORMATTED_NAME");
    }

    public static void defineGOSlimmerAttributes() {
    }

    public static boolean isOntology(String ontologyName) {
        Ontology testOntology = (Ontology)Cytoscape.getOntologyServer().getOntologies().get(ontologyName);
        return testOntology != null && testOntology.getClass() == GeneOntology.class;
    }

    public static void removeUserGeneAttributes(Node node) {
        Cytoscape.getNodeAttributes().deleteAttribute(node.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_USER_GENES");
        Cytoscape.getNodeAttributes().deleteAttribute(node.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES");
    }

    public static void removeUserGeneAttributes(CyNetwork godag) {
        Iterator nodesI = godag.nodesIterator();
        while (nodesI.hasNext()) {
            Node node = (Node)nodesI.next();
            GOSlimmerUtil.removeUserGeneAttributes(node);
        }
    }

    public static boolean areUserGeneAttributesDefined() {
        return nodeAtt.getMultiHashMapDefinition().getAttributeValueType("GOSlimmer.INFERRED_ANNOTATED_USER_GENES") != -1 && nodeAtt.getMultiHashMapDefinition().getAttributeValueType("GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES") != -1;
    }

    public static Collection<String> difference(Collection<String> a, Collection<String> b) {
        HashSet<String> diff = new HashSet<String>();
        for (String as : a) {
            if (b.contains(as)) continue;
            diff.add(as);
        }
        return diff;
    }

    public static List<String> getDirectlyCoveredGeneSynonyms(Node goNode) {
        ArrayList coveredGenes = nodeAtt.getListAttribute(goNode.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_GENE_SYNONYMS");
        if (coveredGenes == null) {
            coveredGenes = new ArrayList();
        }
        return coveredGenes;
    }
}

