/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import giny.model.GraphObject;
import giny.model.Node;
import java.awt.Color;
import org.ccbr.bader.yeast.GOSlimmerUtil;
import org.ccbr.bader.yeast.view.gui.GOSlimmerGUIViewSettings;

public class GOSlimmerVisualStyle
extends VisualStyle {
    public GOSlimmerVisualStyle(String name) {
        super(name);
        this.setNodeAppearanceCalculator(new GoSlimmerNodeAppearanceCalculator());
    }

    public GOSlimmerVisualStyle(VisualStyle toCopy) {
        super(toCopy);
        this.setNodeAppearanceCalculator(new GoSlimmerNodeAppearanceCalculator());
    }

    public GOSlimmerVisualStyle(VisualStyle toCopy, String newName) {
        super(toCopy, newName);
        this.setNodeAppearanceCalculator(new GoSlimmerNodeAppearanceCalculator());
    }

    public GOSlimmerVisualStyle(String name, NodeAppearanceCalculator nac, EdgeAppearanceCalculator eac, GlobalAppearanceCalculator gac) {
        super(name, nac, eac, gac);
        this.setNodeAppearanceCalculator(new GoSlimmerNodeAppearanceCalculator());
    }

    public class GoSlimmerNodeAppearanceCalculator
    extends NodeAppearanceCalculator {
        CyAttributes nodeAtt = Cytoscape.getNodeAttributes();
        private static final int minNodeSize = 2;
        private final Color selectedNodeColor = Color.CYAN;
        private final Color unselectedNodeColor = new Color(255, 150, 150);
        private static final int maxNodeLabelLength = 25;

        public NodeAppearance calculateNodeAppearance(Node node, CyNetwork network) {
            NodeAppearance nodeAppearance = new NodeAppearance();
            this.modifyNodeAppearance(nodeAppearance, node, network);
            return nodeAppearance;
        }

        public void calculateNodeAppearance(NodeAppearance appr, Node node, CyNetwork network) {
            this.modifyNodeAppearance(appr, node, network);
            appr.applyBypass((GraphObject)node);
        }

        private boolean isSelectedForSlimSet(Node node) {
            Boolean isSelected = this.nodeAtt.getBooleanAttribute(node.getIdentifier(), "GOSlimmer.INSET");
            if (isSelected == null) {
                return false;
            }
            return isSelected;
        }

        private void modifyNodeAppearance(NodeAppearance appr, Node node, CyNetwork network) {
            int numDirectlyCoveredGenes = GOSlimmerUtil.getNumGenesCoveredByGoNode(node, GOSlimmerGUIViewSettings.includeDescendantInferredCoveredGenesInNodeSizeCalculations, GOSlimmerGUIViewSettings.sizeNodesBasedOnUserGeneAnnotation);
            double nodeDim = numDirectlyCoveredGenes > 0 ? (double)(numDirectlyCoveredGenes * 2) : 2.0;
            if ((nodeDim += 1.0) > 1.0) {
                nodeDim = Math.log(nodeDim);
            }
            appr.setLabel(node.getIdentifier());
            appr.setHeight(nodeDim *= 10.0);
            appr.setWidth(nodeDim);
            appr.setShape((byte)8);
            if (this.isSelectedForSlimSet(node)) {
                appr.setFillColor(this.selectedNodeColor);
            } else {
                appr.setFillColor(this.unselectedNodeColor);
            }
            if (GOSlimmerGUIViewSettings.labelNodesWithOntologyName) {
                String ontname = this.nodeAtt.getStringAttribute(node.getIdentifier(), "GOSlimmer.FORMATTED_NAME");
                appr.setLabel(ontname);
            } else {
                appr.setLabel(node.getIdentifier());
            }
            if (GOSlimmerGUIViewSettings.showGODefinitionAsToolTip) {
                String defn = this.nodeAtt.getStringAttribute(node.getIdentifier(), "ontology.def");
                if (defn != null) {
                    int curLength = 0;
                    int index = 0;
                    boolean prevWhiteSpace = true;
                    String newDefn = "";
                    String curWord = "";
                    int maxSize = GOSlimmerGUIViewSettings.showGODefinitionAsToolTipSize;
                    while (index < defn.length()) {
                        char c = defn.charAt(index);
                        ++index;
                        boolean curWhiteSpace = Character.isWhitespace(c);
                        if (!curWhiteSpace) {
                            curWord = curWord + c;
                        } else if (!prevWhiteSpace) {
                            int tempLength = curWord.length();
                            if (curLength + tempLength > maxSize) {
                                newDefn = newDefn + "\n" + curWord + c;
                                curLength = tempLength + 1;
                            } else if (curLength + tempLength == maxSize) {
                                newDefn = newDefn + curWord + "\n";
                                curLength = 0;
                            } else {
                                newDefn = newDefn + curWord + c;
                                curLength = curLength + tempLength + 1;
                            }
                            prevWhiteSpace = true;
                            curWord = "";
                        }
                        prevWhiteSpace = curWhiteSpace;
                    }
                    int tempLength = curWord.length();
                    newDefn = curLength + tempLength > maxSize ? newDefn + "\n" + curWord : newDefn + curWord;
                    appr.setToolTip(newDefn);
                } else {
                    appr.setToolTip("");
                }
            } else {
                appr.setToolTip("");
            }
        }
    }
}

