/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.model;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.TaskMonitor;
import giny.model.Node;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.GOSlimmerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOSlimmerCoverageStatBean {
    private CyAttributes nodeAtt = Cytoscape.getNodeAttributes();
    private int numGenesTotal;
    private int numUserGenesTotal;
    private GOSlimmerSession session;
    Set<Node> slimGoNodes = new HashSet<Node>();
    Set<String> inferredCoveredGeneIds = new HashSet<String>();
    Set<String> directlyCoveredGeneIds = new HashSet<String>();
    Set<String> inferredCoveredUserGeneIds = new HashSet<String>();
    Set<String> directlyCoveredUserGeneIds = new HashSet<String>();
    Set<String> slimGoNodeNames = new HashSet<String>();
    private double fractionInferredCovered;
    private double fractionDirectlyCovered;
    private double fractionInferredCoveredUserGenes;
    private double fractionDirectlyCoveredUserGenes;
    private boolean isUserGeneStatisticsSetup = false;

    public GOSlimmerCoverageStatBean(int numGenesTotal, GOSlimmerSession session) {
        this.numGenesTotal = numGenesTotal;
        this.session = session;
    }

    public void addToSlimSet(Node goNode) {
        String goid = goNode.getIdentifier();
        if (this.slimGoNodes.contains(goNode)) {
            return;
        }
        this.addCoveredGeneIdsToGeneSets(goNode);
        if (this.isUserGeneStatisticsSetup) {
            this.addCoveredUserGeneIdsToUserGeneSets(goNode);
        }
        this.updateFractionCovered();
        this.slimGoNodes.add(goNode);
        String goTermName = this.nodeAtt.getStringAttribute(goid, "ontology.name");
        this.slimGoNodeNames.add(goTermName + " (" + goid + ")");
    }

    private void addCoveredGeneIdsToGeneSets(Node goNode) {
        List<String> directlyCoveredGenes = GOSlimmerUtil.getDirectlyCoveredGenes(goNode);
        List<String> inferredCoveredGenes = GOSlimmerUtil.getInferredCoveredGenes(goNode);
        this.inferredCoveredGeneIds.addAll(directlyCoveredGenes);
        this.inferredCoveredGeneIds.addAll(inferredCoveredGenes);
        this.directlyCoveredGeneIds.addAll(directlyCoveredGenes);
    }

    private void addCoveredUserGeneIdsToUserGeneSets(Node goNode) {
        List<String> directlyCoveredUserGenes = GOSlimmerUtil.getDirectlyCoveredUserGenes(goNode);
        List<String> inferredCoveredUserGenes = GOSlimmerUtil.getInferredCoveredUserGenes(goNode);
        this.inferredCoveredUserGeneIds.addAll(directlyCoveredUserGenes);
        this.inferredCoveredUserGeneIds.addAll(inferredCoveredUserGenes);
        this.directlyCoveredUserGeneIds.addAll(directlyCoveredUserGenes);
    }

    public void removeFromSlimSet(Node goNode, TaskMonitor taskMonitor) {
        String goid = goNode.getIdentifier();
        this.removeNodesGenes(goNode, taskMonitor);
        if (this.isUserGeneStatisticsSetup) {
            this.removeNodesUserGenes(goNode, taskMonitor);
        }
        this.updateFractionCovered();
        this.slimGoNodes.remove(goNode);
        String goTermName = this.nodeAtt.getStringAttribute(goid, "ontology.name");
        this.slimGoNodeNames.remove(goTermName + " (" + goid + ")");
    }

    private void removeNodesUserGenes(Node goNode, TaskMonitor taskMonitor) {
        if (taskMonitor != null) {
            taskMonitor.setPercentCompleted(0);
            taskMonitor.setStatus("User genes...");
        }
        if (!this.slimGoNodes.contains(goNode)) {
            return;
        }
        HashSet<String> directlyCoveredUserGenes = new HashSet<String>();
        HashSet<String> inferredCoveredUserGenes = new HashSet<String>();
        for (Node slimNode : this.slimGoNodes) {
            if (slimNode.equals(goNode)) continue;
            directlyCoveredUserGenes.addAll(GOSlimmerUtil.getDirectlyCoveredUserGenes(slimNode));
            inferredCoveredUserGenes.addAll(GOSlimmerUtil.getInferredCoveredUserGenes(slimNode));
        }
        HashSet<String> coveredUserGenes = new HashSet<String>();
        coveredUserGenes.addAll(GOSlimmerUtil.getGenesCoveredByGoNode(goNode, true, true));
        int numGenes = coveredUserGenes.size();
        int count = 0;
        int complete = 0;
        int lastComplete = 0;
        for (String gene : coveredUserGenes) {
            if (taskMonitor != null && (complete = (int)((double)count / (double)numGenes * 100.0)) != lastComplete && complete % 10 == 0) {
                lastComplete = complete;
                taskMonitor.setPercentCompleted(complete);
            }
            if (!directlyCoveredUserGenes.contains(gene)) {
                this.directlyCoveredUserGeneIds.remove(gene);
                if (!inferredCoveredUserGenes.contains(gene)) {
                    this.inferredCoveredUserGeneIds.remove(gene);
                }
            }
            ++count;
        }
    }

    private void removeNodesGenes(Node goNode, TaskMonitor taskMonitor) {
        if (taskMonitor != null) {
            taskMonitor.setPercentCompleted(0);
            taskMonitor.setStatus("All genes...");
        }
        if (!this.slimGoNodes.contains(goNode)) {
            return;
        }
        HashSet<String> directlyCoveredGenes = new HashSet<String>();
        HashSet<String> inferredCoveredGenes = new HashSet<String>();
        for (Node slimNode : this.slimGoNodes) {
            if (slimNode.equals(goNode)) continue;
            directlyCoveredGenes.addAll(GOSlimmerUtil.getDirectlyCoveredGenes(slimNode));
            inferredCoveredGenes.addAll(GOSlimmerUtil.getInferredCoveredGenes(slimNode));
        }
        HashSet<String> coveredGenes = new HashSet<String>();
        coveredGenes.addAll(GOSlimmerUtil.getGenesCoveredByGoNode(goNode, true));
        int numGenes = coveredGenes.size();
        int count = 0;
        int complete = 0;
        int lastComplete = 0;
        for (String gene : coveredGenes) {
            if (taskMonitor != null && (complete = (int)((double)count / (double)numGenes * 100.0)) != lastComplete && complete % 10 == 0) {
                lastComplete = complete;
                taskMonitor.setPercentCompleted(complete);
            }
            if (!directlyCoveredGenes.contains(gene)) {
                this.directlyCoveredGeneIds.remove(gene);
                if (!inferredCoveredGenes.contains(gene)) {
                    this.inferredCoveredGeneIds.remove(gene);
                }
            }
            ++count;
        }
    }

    private void updateFractionCovered() {
        this.fractionInferredCovered = (double)this.inferredCoveredGeneIds.size() / (double)this.numGenesTotal;
        this.fractionDirectlyCovered = (double)this.directlyCoveredGeneIds.size() / (double)this.numGenesTotal;
        if (this.isUserGeneStatisticsSetup) {
            this.fractionDirectlyCoveredUserGenes = (double)this.directlyCoveredUserGeneIds.size() / (double)this.numUserGenesTotal;
        }
        if (this.isUserGeneStatisticsSetup) {
            this.fractionInferredCoveredUserGenes = (double)this.inferredCoveredUserGeneIds.size() / (double)this.numUserGenesTotal;
        }
    }

    public double fractionInferredCovered() {
        return this.fractionInferredCovered;
    }

    public double fractionDirectlyCovered() {
        return this.fractionDirectlyCovered;
    }

    public double fractionDirectlyCoveredUserGenes() {
        return this.fractionDirectlyCoveredUserGenes;
    }

    public double fractionInferredCoveredUserGenes() {
        return this.fractionInferredCoveredUserGenes;
    }

    public void setupUserGeneStatistics(int numUserGenesTotal) {
        this.isUserGeneStatisticsSetup = true;
        this.numUserGenesTotal = numUserGenesTotal;
        this.inferredCoveredUserGeneIds = new HashSet<String>();
        this.directlyCoveredUserGeneIds = new HashSet<String>();
        for (Node node : this.slimGoNodes) {
            this.addCoveredUserGeneIdsToUserGeneSets(node);
        }
        this.updateFractionCovered();
    }

    public Set<Node> getSlimGoNodes() {
        return this.slimGoNodes;
    }

    public String[] getListSelectedGONodes() {
        String[] returnArray = new String[this.slimGoNodeNames.size()];
        return this.slimGoNodeNames.toArray(returnArray);
    }
}

