/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.view.gui.GOSlimmerGUIViewSettings;
import org.ccbr.bader.yeast.view.gui.misc.JCheckBoxMod;
import org.ccbr.bader.yeast.view.gui.misc.JCollapsablePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedViewSettingsPanel
extends JCollapsablePanel
implements ActionListener,
PropertyChangeListener {
    private Collection<GOSlimmerController> controllers;
    private static final String lsep = System.getProperty("line.separator");
    JCheckBox includeDescendentCoverageInNodeSizeCalculationCheckBox;
    private static final String includeDescendentCoverageInNodeSizeCalculationText = "Include child nodes when calculating node size";
    private static final String includeDescendentCoverageInNodeSizeCalculationToolTip = "If checked, then the size of the node will be proportional to the number of genes" + lsep + "directly annotated by the node + the number of genes annotated by all of the nodes " + lsep + "descendants in the graph. If unchecked, size is proportional to the directly " + lsep + "annotated nodes only.";
    JCheckBox labelNodesWithOntologyName;
    private final String labelNodesWithOntologyNameLabel = "Label nodes with Ontology Term Name";
    private final String labelNodesWithOntologyNameToolTip = "If checked, nodes will be labelled with their biologically meaningful " + lsep + "ontology term name.  Otherwise, they will be labelled with their GO ID.";
    JCheckBox showGODefinitionAsToolTip;
    private final String showGODefinitionAsToolTipLabel = "Show GO definition as node tool tip";
    private final String showGODefinitionAsToolTipToolTip = "If checked, nodes will have their GO term definition " + lsep + "appear as a tool tip.  Otherwise, no tool tip will appear.";
    JCheckBox expandNodesWithGenes;
    private final String expandNodesWithGenesLabel = "Expand nodes with associated genes only";
    private final String expandNodesWithGenesToolTip = "If checked, only those children with associate genes " + lsep + "(direct or inferred) will be shown when a node is " + lsep + "expanded.";
    private JCheckBox expandNodeDepthCheckbox;
    private JTextField expandNodeDepthTextField;
    private final String expandNodeDepthTooltip = "If checked, a node's descendant tree will only be expanded to the " + lsep + "specified depth.  If uncheck, the full descendant tree will be expanded.";
    private final String expandNodeDepthCheckboxText = "Expand nodes to specified depth";
    private JCheckBox sizeNodesBasedOnNumUserGenesAnnotatedCheckbox;
    private static final String sizeNodesBasedOnNumUserGenesAnnotatedCheckboxText = "Size Nodes according to User Gene Set";
    private static final String sizeNodesBasedOnNumUserGenesAnnotatedCheckboxToolTip = "If checked, the size of the GO nodes will be determined based on the number" + lsep + "of user genes which are annotated by that node(directly or by inferrence,  " + lsep + "according to the setting of the " + "Include child nodes when calculating node size" + "'" + lsep + "CheckBox).";
    private JCheckBox displayUserGeneStatisticsCheckBox;
    private static final String displayUserGeneStatisticsCheckBoxText = "Calculate Coverage of User Specified Genes";
    private static final String displayUserGeneStatisticsCheckBoxToolTip = "If checked, the coverage statistics displayed in each GO Namespace's" + lsep + "panel will be based on the GO tree's coverage of the genes which the" + lsep + "user imported using the 'Import Gene Set' button.  Unchecked, stats " + lsep + "are calculated based on the GO tree's coverage of all the Genes in  " + lsep + "the applied Gene Annotation File.";

    public AdvancedViewSettingsPanel(Collection<GOSlimmerController> controllers) {
        super("Advanced View Settings");
        this.initComponents();
        this.controllers = controllers;
    }

    private JCheckBox getIncludeDeCheckBox() {
        if (this.includeDescendentCoverageInNodeSizeCalculationCheckBox == null) {
            this.includeDescendentCoverageInNodeSizeCalculationCheckBox = new JCheckBoxMod(includeDescendentCoverageInNodeSizeCalculationText);
            this.includeDescendentCoverageInNodeSizeCalculationCheckBox.setSelected(GOSlimmerGUIViewSettings.includeDescendantInferredCoveredGenesInNodeSizeCalculations);
            this.includeDescendentCoverageInNodeSizeCalculationCheckBox.setToolTipText(includeDescendentCoverageInNodeSizeCalculationToolTip);
            this.includeDescendentCoverageInNodeSizeCalculationCheckBox.addActionListener(this);
        }
        return this.includeDescendentCoverageInNodeSizeCalculationCheckBox;
    }

    private JCheckBox getLCheckBox() {
        if (this.labelNodesWithOntologyName == null) {
            this.labelNodesWithOntologyName = new JCheckBoxMod("Label nodes with Ontology Term Name");
            this.labelNodesWithOntologyName.setSelected(GOSlimmerGUIViewSettings.labelNodesWithOntologyName);
            this.labelNodesWithOntologyName.setToolTipText(this.labelNodesWithOntologyNameToolTip);
            this.labelNodesWithOntologyName.addActionListener(this);
        }
        return this.labelNodesWithOntologyName;
    }

    private JCheckBox getDefnCheckBox() {
        if (this.showGODefinitionAsToolTip == null) {
            this.showGODefinitionAsToolTip = new JCheckBoxMod("Show GO definition as node tool tip");
            this.showGODefinitionAsToolTip.setSelected(GOSlimmerGUIViewSettings.showGODefinitionAsToolTip);
            this.showGODefinitionAsToolTip.setToolTipText(this.showGODefinitionAsToolTipToolTip);
            this.showGODefinitionAsToolTip.addActionListener(this);
        }
        return this.showGODefinitionAsToolTip;
    }

    private JCheckBox getExpandNodesCheckBox() {
        if (this.expandNodesWithGenes == null) {
            this.expandNodesWithGenes = new JCheckBoxMod("Expand nodes with associated genes only");
            this.expandNodesWithGenes.setSelected(GOSlimmerGUIViewSettings.expandNodesWithGenes);
            this.expandNodesWithGenes.setToolTipText(this.expandNodesWithGenesToolTip);
            this.expandNodesWithGenes.addActionListener(this);
        }
        return this.expandNodesWithGenes;
    }

    private JCheckBox getExpandNodeDepthCheckbox() {
        if (this.expandNodeDepthCheckbox == null) {
            this.expandNodeDepthCheckbox = new JCheckBoxMod("Expand nodes to specified depth");
            this.expandNodeDepthCheckbox.setToolTipText(this.expandNodeDepthTooltip);
            this.expandNodeDepthCheckbox.setSelected(true);
            this.expandNodeDepthCheckbox.addActionListener(this);
        }
        return this.expandNodeDepthCheckbox;
    }

    private JTextField getExpandNodeTextField() {
        if (this.expandNodeDepthTextField == null) {
            this.expandNodeDepthTextField = new JFormattedTextField((Object)"1");
            this.expandNodeDepthTextField.setEnabled(this.expandNodeDepthCheckbox.isSelected());
            this.expandNodeDepthTextField.addActionListener(this);
            this.expandNodeDepthTextField.addPropertyChangeListener("value", this);
        }
        return this.expandNodeDepthTextField;
    }

    private JCheckBox getSizeNodesBasedOnNumUserGenesAnnotatedCheckbox() {
        if (this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox == null) {
            this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox = new JCheckBoxMod(sizeNodesBasedOnNumUserGenesAnnotatedCheckboxText);
            this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox.setToolTipText(sizeNodesBasedOnNumUserGenesAnnotatedCheckboxToolTip);
            this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox.addActionListener(this);
        }
        return this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox;
    }

    private void initComponents() {
        this.setLayout(new GridLayout(0, 1));
        this.add(this.getIncludeDeCheckBox());
        this.add(this.getDefnCheckBox());
        this.add(this.getSizeNodesBasedOnNumUserGenesAnnotatedCheckbox());
        this.add(this.getDisplayUserGeneStatisticsCheckBox());
        this.add(this.getExpandNodesCheckBox());
        this.add(this.getLCheckBox());
        this.add(this.getExpandNodeDepthCheckbox());
        this.add(this.getExpandNodeTextField());
    }

    private JCheckBox getDisplayUserGeneStatisticsCheckBox() {
        if (this.displayUserGeneStatisticsCheckBox == null) {
            this.displayUserGeneStatisticsCheckBox = new JCheckBoxMod(displayUserGeneStatisticsCheckBoxText);
            this.displayUserGeneStatisticsCheckBox.setToolTipText(displayUserGeneStatisticsCheckBoxToolTip);
            this.displayUserGeneStatisticsCheckBox.addActionListener(this);
        }
        return this.displayUserGeneStatisticsCheckBox;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src instanceof JCheckBox) {
            if (src == this.includeDescendentCoverageInNodeSizeCalculationCheckBox) {
                GOSlimmerGUIViewSettings.includeDescendantInferredCoveredGenesInNodeSizeCalculations = this.includeDescendentCoverageInNodeSizeCalculationCheckBox.isSelected();
                Cytoscape.getVisualMappingManager().applyAppearances();
            } else if (src == this.labelNodesWithOntologyName) {
                GOSlimmerGUIViewSettings.labelNodesWithOntologyName = this.labelNodesWithOntologyName.isSelected();
            } else if (src == this.showGODefinitionAsToolTip) {
                GOSlimmerGUIViewSettings.showGODefinitionAsToolTip = this.showGODefinitionAsToolTip.isSelected();
            } else if (src == this.expandNodesWithGenes) {
                GOSlimmerGUIViewSettings.expandNodesWithGenes = this.expandNodesWithGenes.isSelected();
            } else if (src == this.expandNodeDepthCheckbox) {
                boolean useFiniteExpansionDepth = this.expandNodeDepthCheckbox.isSelected();
                this.expandNodeDepthTextField.setEnabled(useFiniteExpansionDepth);
                for (GOSlimmerController controller : this.controllers) {
                    controller.setUseFiniteExpansionDepth(useFiniteExpansionDepth);
                }
            } else if (src == this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox) {
                GOSlimmerGUIViewSettings.sizeNodesBasedOnUserGeneAnnotation = this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox.isSelected();
            } else if (src == this.displayUserGeneStatisticsCheckBox) {
                for (GOSlimmerController controller : this.controllers) {
                    controller.setDisplayUserGeneCoverageStatistics(this.displayUserGeneStatisticsCheckBox.isSelected());
                }
            }
            CyNetworkView curNet = Cytoscape.getCurrentNetworkView();
            if (curNet != null) {
                curNet.redrawGraph(false, true);
            }
        } else if (src instanceof JTextField && src == this.expandNodeDepthTextField) {
            this.updateExpansionDepth();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object src = event.getSource();
        if (src instanceof JTextField && src == this.expandNodeDepthTextField) {
            this.updateExpansionDepth();
        }
    }

    private void updateExpansionDepth() {
        int newExpansionDepth;
        try {
            newExpansionDepth = Integer.parseInt(this.expandNodeDepthTextField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid value '" + this.expandNodeDepthTextField.getText() + "' for expansion depth;  expanded node depth must be a valid integer.", "Error", 0);
            for (GOSlimmerController controller : this.controllers) {
                this.expandNodeDepthTextField.setText(String.valueOf(controller.getExpansionDepth()));
            }
            return;
        }
        for (GOSlimmerController controller : this.controllers) {
            controller.setExpansionDepth(newExpansionDepth);
        }
    }

    public void setUserGeneOptions(boolean enableUserGeneOptions) {
        this.sizeNodesBasedOnNumUserGenesAnnotatedCheckbox.setSelected(enableUserGeneOptions);
        GOSlimmerGUIViewSettings.sizeNodesBasedOnUserGeneAnnotation = enableUserGeneOptions;
        this.displayUserGeneStatisticsCheckBox.setSelected(enableUserGeneOptions);
        for (GOSlimmerController controller : this.controllers) {
            controller.setDisplayUserGeneCoverageStatistics(enableUserGeneOptions);
        }
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }
}

