/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.ccbr.bader.yeast.AutomaticGOSetGenerator.AutomaticGeneratorAlgorithm;
import org.ccbr.bader.yeast.GONamespace;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.view.gui.ExpandCollapseEdit;
import org.ccbr.bader.yeast.view.gui.misc.JButtonMod;
import org.ccbr.bader.yeast.view.gui.misc.JCollapsablePanel;
import org.ccbr.bader.yeast.view.gui.misc.JLabelMod;

public class AutomaticGOSetGeneratorPanel
extends JCollapsablePanel
implements ActionListener,
PropertyChangeListener {
    Map<GONamespace, GOSlimmerController> namespaceToController;
    private GOSlimmerSession session;
    private String[] coveringSetNames = new String[0];
    private int defaultNumTerms = 10;
    private JFormattedTextField numTermsTextField;
    private JLabel numTermsLabel;
    private JButton findCoveringTermsButton;
    private String findCoveringTermsButtonText = "Find Best Covering Terms";
    private String findCoveringTermsButtonToolTip = "Find the best covering terms for the remaining uncovered genes";
    private JScrollPane coveringSetScrollPane;
    private String coveringSetScrollPaneToolTip = "List of best covering terms.";
    private JButton showCoveringTermButton;
    private String showCoveringTermButtonText = "Show";
    private String showCoveringTermButtonToolTip = "Show selected covering term in GO diagram";

    public AutomaticGOSetGeneratorPanel(GOSlimmerSession session) {
        super("Automatic GO Set Term Generator");
        this.namespaceToController = session.getNamespaceToController();
        this.session = session;
        this.initComponents();
    }

    private JFormattedTextField getNumTermsTextField() {
        if (this.numTermsTextField == null) {
            this.numTermsTextField = new JFormattedTextField((Object)this.defaultNumTerms);
            this.numTermsTextField.setEnabled(true);
            this.numTermsTextField.addActionListener(this);
            this.numTermsTextField.addPropertyChangeListener("value", this);
            this.numTermsTextField.setSize(100, 10);
        }
        return this.numTermsTextField;
    }

    private JLabel getNumTermsLabel() {
        if (this.numTermsLabel == null) {
            this.numTermsLabel = new JLabelMod("Number of terms to find:");
        }
        return this.numTermsLabel;
    }

    private JButton getFindCoveringTermsButton() {
        if (this.findCoveringTermsButton == null) {
            this.findCoveringTermsButton = new JButtonMod(this.findCoveringTermsButtonText);
            this.findCoveringTermsButton.addActionListener(this);
            this.findCoveringTermsButton.setToolTipText(this.findCoveringTermsButtonToolTip);
        }
        return this.findCoveringTermsButton;
    }

    private JScrollPane getCoveringSetScrollPane() {
        if (this.coveringSetScrollPane == null) {
            this.coveringSetScrollPane = new JScrollPane();
            this.coveringSetScrollPane.setToolTipText(this.coveringSetScrollPaneToolTip);
            this.coveringSetScrollPane.setHorizontalScrollBarPolicy(30);
            Dimension dim = new Dimension();
            dim.setSize(275.0, 94.0);
            this.coveringSetScrollPane.setPreferredSize(dim);
            JList<String> coveringSetList = new JList<String>(this.coveringSetNames);
            coveringSetList.setVisibleRowCount(4);
            coveringSetList.setSelectionMode(0);
            this.coveringSetScrollPane.getViewport().setView(coveringSetList);
        }
        return this.coveringSetScrollPane;
    }

    private JButton getShowCoveringTermButton() {
        if (this.showCoveringTermButton == null) {
            this.showCoveringTermButton = new JButtonMod(this.showCoveringTermButtonText);
            this.showCoveringTermButton.addActionListener(this);
            this.showCoveringTermButton.setToolTipText(this.showCoveringTermButtonToolTip);
        }
        return this.showCoveringTermButton;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getFindCoveringTermsButton(), c);
        c.anchor = 21;
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.3;
        this.add((Component)this.getNumTermsLabel(), c);
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.getNumTermsTextField(), c);
        c.anchor = 22;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 2;
        this.add((Component)this.getShowCoveringTermButton(), c);
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.9;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.getCoveringSetScrollPane(), c);
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src instanceof JButton) {
            JList list;
            JButton bsrc = (JButton)src;
            if (bsrc.equals(this.findCoveringTermsButton)) {
                AutomaticGeneratorAlgorithm generator = new AutomaticGeneratorAlgorithm(this.session);
                CyNetwork network = Cytoscape.getCurrentNetwork();
                GOSlimmerController controller = null;
                GONamespace namespace = null;
                for (GONamespace name_sp : this.namespaceToController.keySet()) {
                    GOSlimmerController control = this.namespaceToController.get((Object)name_sp);
                    if (!control.getNetwork().equals(network)) continue;
                    namespace = name_sp;
                    controller = control;
                    break;
                }
                if (namespace != null) {
                    int numTopTerms = (Integer)this.numTermsTextField.getValue();
                    String[] topTermsString = generator.getTopTermsStringsInferred(controller.getStatBean().getSlimGoNodes(), numTopTerms);
                    JList tempList = (JList)this.coveringSetScrollPane.getViewport().getView();
                    tempList.setListData(topTermsString);
                }
            } else if (bsrc.equals(this.showCoveringTermButton) && (list = (JList)this.coveringSetScrollPane.getViewport().getView()).getSelectedIndex() != -1) {
                String fullName = (String)list.getSelectedValue();
                int pStartIndex = fullName.lastIndexOf("(");
                int pEndIndex = fullName.indexOf(")", pStartIndex);
                String goId = fullName.substring(pStartIndex + 1, pEndIndex);
                CyNetwork network = Cytoscape.getCurrentNetwork();
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                GOSlimmerController controller = null;
                for (GOSlimmerController control : this.namespaceToController.values()) {
                    CyNetwork curNetwork = control.getNetwork();
                    if (!curNetwork.equals(network)) continue;
                    controller = control;
                }
                Iterator nodes_i = network.nodesIterator();
                Node goNode = null;
                while (nodes_i.hasNext()) {
                    Node node = (Node)nodes_i.next();
                    if (!node.toString().equals(goId)) continue;
                    goNode = node;
                    break;
                }
                if (goNode == null) {
                    System.out.println("This node is not in this network");
                } else {
                    network.unselectAllNodes();
                    if (controller != null && controller.isVisibleNode(goNode)) {
                        network.setSelectedNodeState(goNode, true);
                        view.updateView();
                    } else if (controller != null) {
                        ExpandCollapseEdit undoableEdit = new ExpandCollapseEdit(controller, "Show Node");
                        controller.displayNode(goNode);
                        network.setSelectedNodeState(goNode, true);
                        undoableEdit.post();
                        view.redrawGraph(false, false);
                    }
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object src = event.getSource();
        if (src instanceof JTextField && src == this.numTermsTextField) {
            try {
                Integer.parseInt(this.numTermsTextField.getText());
            }
            catch (NumberFormatException e) {
                this.numTermsTextField.setText(String.valueOf(this.defaultNumTerms));
            }
        }
    }
}

