/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ArgumentIsOptionTest
extends TestCase {
    private Options options = null;
    private CommandLineParser parser = null;

    public ArgumentIsOptionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ArgumentIsOptionTest.class);
    }

    public void setUp() {
        this.options = new Options().addOption("p", false, "Option p").addOption("attr", true, "Option accepts argument");
        this.parser = new PosixParser();
    }

    public void tearDown() {
    }

    public void testOptionAndOptionWithArgument() {
        String[] args = new String[]{"-p", "-attr", "p"};
        try {
            CommandLine cl = this.parser.parse(this.options, args);
            ArgumentIsOptionTest.assertTrue((String)"Confirm -p is set", (boolean)cl.hasOption("p"));
            ArgumentIsOptionTest.assertTrue((String)"Confirm -attr is set", (boolean)cl.hasOption("attr"));
            ArgumentIsOptionTest.assertTrue((String)"Confirm arg of -attr", (boolean)cl.getOptionValue("attr").equals("p"));
            ArgumentIsOptionTest.assertTrue((String)"Confirm all arguments recognized", (cl.getArgs().length == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ArgumentIsOptionTest.fail((String)e.toString());
        }
    }

    public void testOptionWithArgument() {
        String[] args = new String[]{"-attr", "p"};
        try {
            CommandLine cl = this.parser.parse(this.options, args);
            ArgumentIsOptionTest.assertFalse((String)"Confirm -p is set", (boolean)cl.hasOption("p"));
            ArgumentIsOptionTest.assertTrue((String)"Confirm -attr is set", (boolean)cl.hasOption("attr"));
            ArgumentIsOptionTest.assertTrue((String)"Confirm arg of -attr", (boolean)cl.getOptionValue("attr").equals("p"));
            ArgumentIsOptionTest.assertTrue((String)"Confirm all arguments recognized", (cl.getArgs().length == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ArgumentIsOptionTest.fail((String)e.toString());
        }
    }

    public void testOption() {
        String[] args = new String[]{"-p"};
        try {
            CommandLine cl = this.parser.parse(this.options, args);
            ArgumentIsOptionTest.assertTrue((String)"Confirm -p is set", (boolean)cl.hasOption("p"));
            ArgumentIsOptionTest.assertFalse((String)"Confirm -attr is not set", (boolean)cl.hasOption("attr"));
            ArgumentIsOptionTest.assertTrue((String)"Confirm all arguments recognized", (cl.getArgs().length == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ArgumentIsOptionTest.fail((String)e.toString());
        }
    }
}

