/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class OptionGroupTest
extends TestCase {
    private Options _options = null;
    private CommandLineParser parser = new PosixParser();

    public static Test suite() {
        return new TestSuite(OptionGroupTest.class);
    }

    public OptionGroupTest(String name) {
        super(name);
    }

    public void setUp() {
        Option file = new Option("f", "file", false, "file to process");
        Option dir = new Option("d", "directory", false, "directory to process");
        OptionGroup group = new OptionGroup();
        group.addOption(file);
        group.addOption(dir);
        this._options = new Options().addOptionGroup(group);
        Option section = new Option("s", "section", false, "section to process");
        Option chapter = new Option("c", "chapter", false, "chapter to process");
        OptionGroup group2 = new OptionGroup();
        group2.addOption(section);
        group2.addOption(chapter);
        this._options.addOptionGroup(group2);
        Option importOpt = new Option(null, "import", false, "section to process");
        Option exportOpt = new Option(null, "export", false, "chapter to process");
        OptionGroup group3 = new OptionGroup();
        group3.addOption(importOpt);
        group3.addOption(exportOpt);
        this._options.addOptionGroup(group3);
        this._options.addOption("r", "revision", false, "revision number");
    }

    public void tearDown() {
    }

    public void testSingleOptionFromGroup() {
        String[] args = new String[]{"-f"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            OptionGroupTest.assertTrue((String)"Confirm -r is NOT set", (!cl.hasOption("r") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
            OptionGroupTest.assertTrue((String)"Confirm -d is NOT set", (!cl.hasOption("d") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -s is NOT set", (!cl.hasOption("s") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -c is NOT set", (!cl.hasOption("c") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm no extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }

    public void testSingleOption() {
        String[] args = new String[]{"-r"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            OptionGroupTest.assertTrue((String)"Confirm -r is set", (boolean)cl.hasOption("r"));
            OptionGroupTest.assertTrue((String)"Confirm -f is NOT set", (!cl.hasOption("f") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -d is NOT set", (!cl.hasOption("d") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -s is NOT set", (!cl.hasOption("s") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -c is NOT set", (!cl.hasOption("c") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm no extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }

    public void testTwoValidOptions() {
        String[] args = new String[]{"-r", "-f"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            OptionGroupTest.assertTrue((String)"Confirm -r is set", (boolean)cl.hasOption("r"));
            OptionGroupTest.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
            OptionGroupTest.assertTrue((String)"Confirm -d is NOT set", (!cl.hasOption("d") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -s is NOT set", (!cl.hasOption("s") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -c is NOT set", (!cl.hasOption("c") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm no extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }

    public void testSingleLongOption() {
        String[] args = new String[]{"--file"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            OptionGroupTest.assertTrue((String)"Confirm -r is NOT set", (!cl.hasOption("r") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
            OptionGroupTest.assertTrue((String)"Confirm -d is NOT set", (!cl.hasOption("d") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -s is NOT set", (!cl.hasOption("s") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -c is NOT set", (!cl.hasOption("c") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm no extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }

    public void testTwoValidLongOptions() {
        String[] args = new String[]{"--revision", "--file"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            OptionGroupTest.assertTrue((String)"Confirm -r is set", (boolean)cl.hasOption("r"));
            OptionGroupTest.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
            OptionGroupTest.assertTrue((String)"Confirm -d is NOT set", (!cl.hasOption("d") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -s is NOT set", (!cl.hasOption("s") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -c is NOT set", (!cl.hasOption("c") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm no extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }

    public void testNoOptionsExtraArgs() {
        String[] args = new String[]{"arg1", "arg2"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            OptionGroupTest.assertTrue((String)"Confirm -r is NOT set", (!cl.hasOption("r") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -f is NOT set", (!cl.hasOption("f") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -d is NOT set", (!cl.hasOption("d") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -s is NOT set", (!cl.hasOption("s") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -c is NOT set", (!cl.hasOption("c") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm TWO extra args", (cl.getArgList().size() == 2 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }

    public void testTwoOptionsFromGroup() {
        block2: {
            String[] args = new String[]{"-f", "-d"};
            try {
                CommandLine cl = this.parser.parse(this._options, args);
                OptionGroupTest.fail((String)"two arguments from group not allowed");
            }
            catch (ParseException e) {
                if (e instanceof AlreadySelectedException) break block2;
                OptionGroupTest.fail((String)("incorrect exception caught:" + e.getMessage()));
            }
        }
    }

    public void testTwoLongOptionsFromGroup() {
        block2: {
            String[] args = new String[]{"--file", "--directory"};
            try {
                CommandLine cl = this.parser.parse(this._options, args);
                OptionGroupTest.fail((String)"two arguments from group not allowed");
            }
            catch (ParseException e) {
                if (e instanceof AlreadySelectedException) break block2;
                OptionGroupTest.fail((String)("incorrect exception caught:" + e.getMessage()));
            }
        }
    }

    public void testTwoOptionsFromDifferentGroup() {
        String[] args = new String[]{"-f", "-s"};
        try {
            CommandLine cl = this.parser.parse(this._options, args);
            OptionGroupTest.assertTrue((String)"Confirm -r is NOT set", (!cl.hasOption("r") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
            OptionGroupTest.assertTrue((String)"Confirm -d is NOT set", (!cl.hasOption("d") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm -s is set", (boolean)cl.hasOption("s"));
            OptionGroupTest.assertTrue((String)"Confirm -c is NOT set", (!cl.hasOption("c") ? 1 : 0) != 0);
            OptionGroupTest.assertTrue((String)"Confirm NO extra args", (cl.getArgList().size() == 0 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }

    public void testValidLongOnlyOptions() {
        CommandLine cl;
        try {
            cl = this.parser.parse(this._options, new String[]{"--export"});
            OptionGroupTest.assertTrue((String)"Confirm --export is set", (boolean)cl.hasOption("export"));
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
        try {
            cl = this.parser.parse(this._options, new String[]{"--import"});
            OptionGroupTest.assertTrue((String)"Confirm --import is set", (boolean)cl.hasOption("import"));
        }
        catch (ParseException e) {
            OptionGroupTest.fail((String)e.toString());
        }
    }
}

