/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;

public class ParseTest
extends TestCase {
    private Options _options = null;
    private CommandLineParser _parser = null;

    public static Test suite() {
        return new TestSuite(ParseTest.class);
    }

    public ParseTest(String name) {
        super(name);
    }

    public void setUp() {
        this._options = new Options().addOption("a", "enable-a", false, "turn [a] on or off").addOption("b", "bfile", true, "set the value of [b]").addOption("c", "copt", false, "turn [c] on or off");
        this._parser = new PosixParser();
    }

    public void tearDown() {
    }

    public void testSimpleShort() {
        String[] args = new String[]{"-a", "-b", "toast", "foo", "bar"};
        try {
            CommandLine cl = this._parser.parse(this._options, args);
            ParseTest.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
            ParseTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("toast"));
            ParseTest.assertTrue((String)"Confirm size of extra args", (cl.getArgList().size() == 2 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }

    public void testSimpleLong() {
        String[] args = new String[]{"--enable-a", "--bfile", "toast", "foo", "bar"};
        try {
            CommandLine cl = this._parser.parse(this._options, args);
            ParseTest.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
            ParseTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("toast"));
            ParseTest.assertTrue((String)"Confirm arg of --bfile", (boolean)cl.getOptionValue("bfile").equals("toast"));
            ParseTest.assertTrue((String)"Confirm size of extra args", (cl.getArgList().size() == 2 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }

    public void testComplexShort() {
        String[] args = new String[]{"-acbtoast", "foo", "bar"};
        try {
            CommandLine cl = this._parser.parse(this._options, args);
            ParseTest.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
            ParseTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseTest.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
            ParseTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("toast"));
            ParseTest.assertTrue((String)"Confirm size of extra args", (cl.getArgList().size() == 2 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }

    public void testExtraOption() {
        String[] args = new String[]{"-adbtoast", "foo", "bar"};
        boolean caught = false;
        try {
            CommandLine cl = this._parser.parse(this._options, args);
            ParseTest.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
            ParseTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseTest.assertTrue((String)"confirm arg of -b", (boolean)cl.getOptionValue("b").equals("toast"));
            ParseTest.assertTrue((String)"Confirm size of extra args", (cl.getArgList().size() == 3 ? 1 : 0) != 0);
        }
        catch (UnrecognizedOptionException e) {
            caught = true;
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
        ParseTest.assertTrue((String)"Confirm UnrecognizedOptionException caught", (boolean)caught);
    }

    public void testMissingArg() {
        String[] args = new String[]{"-acb"};
        boolean caught = false;
        try {
            CommandLine cl = this._parser.parse(this._options, args);
        }
        catch (MissingArgumentException e) {
            caught = true;
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
        ParseTest.assertTrue((String)"Confirm MissingArgumentException caught", (boolean)caught);
    }

    public void testStop() {
        String[] args = new String[]{"-c", "foober", "-btoast"};
        try {
            CommandLine cl = this._parser.parse(this._options, args, true);
            ParseTest.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
            ParseTest.assertTrue((String)("Confirm  2 extra args: " + cl.getArgList().size()), (cl.getArgList().size() == 2 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }

    public void testMultiple() {
        String[] args = new String[]{"-c", "foobar", "-btoast"};
        try {
            CommandLine cl = this._parser.parse(this._options, args, true);
            ParseTest.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
            ParseTest.assertTrue((String)("Confirm  2 extra args: " + cl.getArgList().size()), (cl.getArgList().size() == 2 ? 1 : 0) != 0);
            cl = this._parser.parse(this._options, cl.getArgs());
            ParseTest.assertTrue((String)"Confirm -c is not set", (!cl.hasOption("c") ? 1 : 0) != 0);
            ParseTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("toast"));
            ParseTest.assertTrue((String)("Confirm  1 extra arg: " + cl.getArgList().size()), (cl.getArgList().size() == 1 ? 1 : 0) != 0);
            ParseTest.assertTrue((String)("Confirm  value of extra arg: " + cl.getArgList().get(0)), (boolean)cl.getArgList().get(0).equals("foobar"));
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }

    public void testMultipleWithLong() {
        String[] args = new String[]{"--copt", "foobar", "--bfile", "toast"};
        try {
            CommandLine cl = this._parser.parse(this._options, args, true);
            ParseTest.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
            ParseTest.assertTrue((String)("Confirm  3 extra args: " + cl.getArgList().size()), (cl.getArgList().size() == 3 ? 1 : 0) != 0);
            cl = this._parser.parse(this._options, cl.getArgs());
            ParseTest.assertTrue((String)"Confirm -c is not set", (!cl.hasOption("c") ? 1 : 0) != 0);
            ParseTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("toast"));
            ParseTest.assertTrue((String)("Confirm  1 extra arg: " + cl.getArgList().size()), (cl.getArgList().size() == 1 ? 1 : 0) != 0);
            ParseTest.assertTrue((String)("Confirm  value of extra arg: " + cl.getArgList().get(0)), (boolean)cl.getArgList().get(0).equals("foobar"));
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }

    public void testDoubleDash() {
        String[] args = new String[]{"--copt", "--", "-b", "toast"};
        try {
            CommandLine cl = this._parser.parse(this._options, args);
            ParseTest.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
            ParseTest.assertTrue((String)"Confirm -b is not set", (!cl.hasOption("b") ? 1 : 0) != 0);
            ParseTest.assertTrue((String)("Confirm 2 extra args: " + cl.getArgList().size()), (cl.getArgList().size() == 2 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }

    public void testSingleDash() {
        String[] args = new String[]{"--copt", "-b", "-", "-a", "-"};
        try {
            CommandLine cl = this._parser.parse(this._options, args);
            ParseTest.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
            ParseTest.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
            ParseTest.assertTrue((String)"Confirm arg of -b", (boolean)cl.getOptionValue("b").equals("-"));
            ParseTest.assertTrue((String)("Confirm 1 extra arg: " + cl.getArgList().size()), (cl.getArgList().size() == 1 ? 1 : 0) != 0);
            ParseTest.assertTrue((String)("Confirm value of extra arg: " + cl.getArgList().get(0)), (boolean)cl.getArgList().get(0).equals("-"));
        }
        catch (ParseException e) {
            ParseTest.fail((String)e.toString());
        }
    }
}

