/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.AutomaticGOSetGenerator;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import ding.view.DGraphView;
import giny.model.Node;
import giny.view.EdgeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ccbr.bader.yeast.AutomaticGOSetGenerator.GOSetTerm;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.GOSlimmerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticGeneratorAlgorithm {
    private GOSlimmerSession session;

    public AutomaticGeneratorAlgorithm(GOSlimmerSession session) {
        this.session = session;
    }

    public Set<Node> getCoveringSet(Set<Node> selectedGONodes) {
        HashSet<Node> coveringSet = new HashSet<Node>(selectedGONodes);
        Set<String> geneIds = null;
        boolean userGenesImported = this.session.isUserGeneSetImported();
        geneIds = userGenesImported ? new HashSet<String>(this.session.getUserGeneSet()) : this.session.getGaru().getGeneIds();
        Node nextBestNode = this.getNextBestTerm(coveringSet, geneIds, userGenesImported);
        while (nextBestNode != null) {
            coveringSet.add(nextBestNode);
            nextBestNode = this.getNextBestTerm(coveringSet, geneIds, userGenesImported);
        }
        return coveringSet;
    }

    public String[] getTopTermsStringsDirect(Set<Node> selectedGONodes, int numTerms) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        Set<String> geneIds = null;
        boolean userGenesImported = this.session.isUserGeneSetImported();
        geneIds = userGenesImported ? new HashSet<String>(this.session.getUserGeneSet()) : this.session.getGaru().getGeneIds();
        ArrayList<GOSetTerm> goTermList = new ArrayList<GOSetTerm>();
        HashSet<String> coveredGenes = new HashSet<String>();
        for (Node node : selectedGONodes) {
            coveredGenes.addAll(GOSlimmerUtil.listToSet(GOSlimmerUtil.getGenesCoveredByGoNode(node, false, userGenesImported)));
        }
        HashSet<String> uncoveredGenes = new HashSet<String>();
        for (String gene : geneIds) {
            if (coveredGenes.contains(gene)) continue;
            uncoveredGenes.add(gene);
        }
        int numUncoveredGenes = uncoveredGenes.size();
        Iterator nodes_i = network.nodesIterator();
        while (nodes_i.hasNext()) {
            Node node = (Node)nodes_i.next();
            if (selectedGONodes.contains(node)) continue;
            HashSet<String> nodeCoveredGenes = new HashSet<String>(GOSlimmerUtil.getGenesCoveredByGoNode(node, false, userGenesImported));
            HashSet<String> newCoveredGenes = new HashSet<String>();
            if (nodeCoveredGenes.size() < numUncoveredGenes) {
                for (String gene : nodeCoveredGenes) {
                    if (!uncoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            } else {
                for (String gene : uncoveredGenes) {
                    if (!nodeCoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            }
            if (newCoveredGenes.size() <= 0) continue;
            GOSetTerm goSetTerm = new GOSetTerm(node, newCoveredGenes.size());
            goTermList.add(goSetTerm);
        }
        Collections.sort(goTermList);
        int numSortedTerms = goTermList.size();
        int actualNumTerms = Math.min(numTerms, numSortedTerms);
        String[] goTermsStr = new String[actualNumTerms];
        for (int i = 0; i < actualNumTerms; ++i) {
            goTermsStr[i] = ((GOSetTerm)goTermList.get(numSortedTerms - 1 - i)).getDescriptiveString();
        }
        return goTermsStr;
    }

    public String[] getTopTermsStringsInferred(Set<Node> selectedGONodes, int numTerms) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        Set<String> geneIds = null;
        boolean userGenesImported = this.session.isUserGeneSetImported();
        geneIds = userGenesImported ? new HashSet<String>(this.session.getUserGeneSet()) : this.session.getGaru().getGeneIds();
        ArrayList<GOSetTerm> goTermList = new ArrayList<GOSetTerm>();
        HashSet<String> coveredGenes = new HashSet<String>();
        for (Node node : selectedGONodes) {
            coveredGenes.addAll(GOSlimmerUtil.listToSet(GOSlimmerUtil.getGenesCoveredByGoNode(node, true, userGenesImported)));
        }
        HashSet<String> uncoveredGenes = new HashSet<String>();
        for (String gene : geneIds) {
            if (coveredGenes.contains(gene)) continue;
            uncoveredGenes.add(gene);
        }
        int numUncoveredGenes = uncoveredGenes.size();
        Iterator nodes_i = network.nodesIterator();
        while (nodes_i.hasNext()) {
            Node node = (Node)nodes_i.next();
            if (selectedGONodes.contains(node)) continue;
            HashSet<String> nodeCoveredGenes = new HashSet<String>(GOSlimmerUtil.getGenesCoveredByGoNode(node, true, userGenesImported));
            HashSet<String> newCoveredGenes = new HashSet<String>();
            if (nodeCoveredGenes.size() < numUncoveredGenes) {
                for (String gene : nodeCoveredGenes) {
                    if (!uncoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            } else {
                for (String gene : uncoveredGenes) {
                    if (!nodeCoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            }
            if (newCoveredGenes.size() <= 0) continue;
            GOSetTerm goSetTerm = new GOSetTerm(node, newCoveredGenes.size());
            goTermList.add(goSetTerm);
        }
        Collections.sort(goTermList);
        int numSortedTerms = goTermList.size();
        int actualNumTerms = Math.min(numTerms, numSortedTerms);
        String[] goTermsStr = new String[actualNumTerms];
        for (int i = 0; i < actualNumTerms; ++i) {
            goTermsStr[i] = ((GOSetTerm)goTermList.get(numSortedTerms - 1 - i)).getDescriptiveString();
        }
        return goTermsStr;
    }

    public Node getNextBestTerm(Set<Node> selectedGONodes, Set<String> geneIds, boolean userGenesImported) {
        return this.getNextBestTermDirect(selectedGONodes, geneIds, userGenesImported);
    }

    public Node getNextBestTermDirect(Set<Node> selectedGONodes, Set<String> geneIds, boolean userGenesImported) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        HashSet<String> coveredGenes = new HashSet<String>();
        for (Node node : selectedGONodes) {
            coveredGenes.addAll(GOSlimmerUtil.listToSet(GOSlimmerUtil.getGenesCoveredByGoNode(node, false, userGenesImported)));
        }
        HashSet<String> uncoveredGenes = new HashSet<String>();
        for (String gene : geneIds) {
            if (coveredGenes.contains(gene)) continue;
            uncoveredGenes.add(gene);
        }
        int numUncoveredGenes = uncoveredGenes.size();
        int topRank = -1;
        Node topRankedNode = null;
        Iterator nodes_i = network.nodesIterator();
        while (nodes_i.hasNext()) {
            Node node = (Node)nodes_i.next();
            if (selectedGONodes.contains(node)) continue;
            HashSet<String> nodeCoveredGenes = new HashSet<String>(GOSlimmerUtil.getGenesCoveredByGoNode(node, false, userGenesImported));
            HashSet<String> newCoveredGenes = new HashSet<String>();
            if (nodeCoveredGenes.size() < numUncoveredGenes) {
                for (String gene : nodeCoveredGenes) {
                    if (!uncoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            } else {
                for (String gene : uncoveredGenes) {
                    if (!nodeCoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            }
            if (newCoveredGenes.size() <= topRank) continue;
            topRank = newCoveredGenes.size();
            topRankedNode = node;
        }
        if (topRank == 0) {
            return null;
        }
        return topRankedNode;
    }

    public Node getNextBestTermInferred(Set<Node> selectedGONodes, Set<String> geneIds, boolean userGenesImported) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        HashSet<String> coveredGenes = new HashSet<String>();
        for (Node node : selectedGONodes) {
            coveredGenes.addAll(GOSlimmerUtil.listToSet(GOSlimmerUtil.getGenesCoveredByGoNode(node, true, userGenesImported)));
        }
        HashSet<String> uncoveredGenes = new HashSet<String>();
        for (String gene : geneIds) {
            if (coveredGenes.contains(gene)) continue;
            uncoveredGenes.add(gene);
        }
        int numUncoveredGenes = uncoveredGenes.size();
        int topRank = -1;
        Node topRankedNode = null;
        Iterator nodes_i = network.nodesIterator();
        while (nodes_i.hasNext()) {
            Node node = (Node)nodes_i.next();
            if (selectedGONodes.contains(node) || this.isAncestorOfNodeInSet(node, selectedGONodes)) continue;
            HashSet<String> nodeCoveredGenes = new HashSet<String>(GOSlimmerUtil.getGenesCoveredByGoNode(node, true, userGenesImported));
            HashSet<String> newCoveredGenes = new HashSet<String>();
            if (nodeCoveredGenes.size() < numUncoveredGenes) {
                for (String gene : nodeCoveredGenes) {
                    if (!uncoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            } else {
                for (String gene : uncoveredGenes) {
                    if (!nodeCoveredGenes.contains(gene)) continue;
                    newCoveredGenes.add(gene);
                }
            }
            if (newCoveredGenes.size() <= topRank) continue;
            topRank = newCoveredGenes.size();
            topRankedNode = node;
        }
        System.out.println("top ranked node: " + topRankedNode + " with a rank of " + topRank);
        if (topRank == 0) {
            return null;
        }
        return topRankedNode;
    }

    private boolean isAncestorOfNodeInSet(Node node, Set<Node> otherNodes) {
        for (Node eachNode : otherNodes) {
            if (!this.isAncestorNode(node, eachNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isAncestorNode(Node ancestor, Node child) {
        int[] outgoingEdges;
        DGraphView view = (DGraphView)Cytoscape.getCurrentNetworkView();
        for (int outgoingEdge : outgoingEdges = Cytoscape.getCurrentNetwork().getAdjacentEdgeIndicesArray(child.getRootGraphIndex(), false, false, true)) {
            EdgeView ev = view.getEdgeView(outgoingEdge);
            Node parentNode = ev.getEdge().getTarget();
            if (ancestor.equals(parentNode)) {
                return true;
            }
            if (!this.isAncestorNode(ancestor, parentNode)) continue;
            return true;
        }
        return false;
    }
}

